package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassPartner extends ClassModelObject{

	/**
	 *
	 */
	public ClassPartner() {
		this.m_tableName = "PARTNER";
	}

	/**
	 *
	 * @param db
	 */
	public ClassPartner(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "PARTNER";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Partner> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("PART_NUMBER");
		selectParams.add("NAME");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("CATEGORY");
		selectParams.add("NAME_KANA");
		selectParams.add("POSTAL_CODE");
		selectParams.add("ADDRESS");
		selectParams.add("PHONE_NUMBER");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Partner> objects = new ArrayList<Partner>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Partner object = new Partner(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
