package system;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassColumnSetting extends ClassModelObject{

	/**
	 *
	 */
	public ClassColumnSetting() {
		this.m_tableName = "COLUMN_SETTING";
	}

	/**
	 *
	 * @param db
	 */
	public ClassColumnSetting(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "COLUMN_SETTING";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<ColumnSetting> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("SUPER_IDENTIFICATION");
		selectParams.add("USER_NUMBER");
		selectParams.add("DISPLAY");
		selectParams.add("STRUCT_ORDER");
		selectParams.add("WITDH");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<ColumnSetting> objects = new ArrayList<ColumnSetting>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			ColumnSetting object = new ColumnSetting(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ColumnSetting create(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertTypes, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<ColumnSetting> accounts;
		accounts = select(condition, conditionTypes, conditionValues);

		return accounts.get(0);
	}
}
