package system;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassDealingSchedule extends ClassModelObject{

	/**
	 *
	 */
	public ClassDealingSchedule() {
		this.m_tableName = "DEALING_SCHEDULE";
	}

	/**
	 *
	 * @param db
	 */
	public ClassDealingSchedule(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "DEALING_SCHEDULE";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<DealingSchedule> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("APPLICATION_START_DATE");
		selectParams.add("APPLICATION_FINISH_DATE");
		selectParams.add("CREDIT_ACCOUNT_NUMBER");
		selectParams.add("DEBIT_ACCOUNT_NUMBER");
		selectParams.add("PART_NUMBER");
		selectParams.add("PRICE");
		selectParams.add("QUANTITY");
		selectParams.add("AMOUNT");
		selectParams.add("PARTNER_NUMBER");
		selectParams.add("DUE_DATE");
		selectParams.add("HOLIDAY_CORRESPONDENCE");
		selectParams.add("NEXT_DUE_DATE");
		selectParams.add("PAYMENT_MONTH");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<DealingSchedule> objects = new ArrayList<DealingSchedule>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			DealingSchedule object = new DealingSchedule(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
