# NFC Copy Cat

NFC Copy Cat, manufactured by Electronic Cats, is a small device that combines two powerful cybersecurity tools, NFCopy and MagSpoof. NFCopy works by reading or emulating a NFC card; depending on the necessities of the researcher. On the other hand, MagSpoof can wirelessly emulate/spoof any magnetic stripe card. So using NFC Copy Cat, the user will have a device capable of storing magnetic stripe data or NFC payment data to be replayed later — known in the cybersecurity world as a replay attack. 

To show the capabilities of NFC Copy Cat, the emulation example will use a Visa MSD protocol. So be aware that this type of transaction will not be accepted in some payment systems.

NFC Copy Cat combines a simple user interface that can be programmed using Arduino IDE. Adding a micro USB connection, 3.7V LiPo battery connector, antenna, two programmable buttons, LEDs and a reset button. The most important part, NFC Copy Cat is an open hardware project. So anyone could modify or redesign on their own.

Devices like NFC Copy Cat are essential for researchers, students, teachers or anyone interested in payment systems. It will help to understand how the payment system works, the communications or the APDU protocol. 

Some of the code examples that will be available introduce different concepts. For example, how to detect a card reader, how to detect a NFC card, how to use MagSpoof using a button as trigger to spoof, how to use NFC with a button to emulate, how to read a Visa card, how to emulate a Visa MSD card, how to generate challenges to extract card information or how to combine both tools: NFCopy and MagSpoof.

## Features:
- Microcontroller SAMD21 ARM 32 bit Cortex M0
- Memory Flash for support Circuit Python
- Battery Charger 3.7v
- Compatible con Adafruit PN532 breakout
- Compatible con NFC Module V3

### Included Complete Version:
- NFC Copy Cat
- Coil for Magspoof
- NFC Module V3 +Tag 
### Included Single Version:
- NFC Copy Cat
- Coil for Magspoof

<a href="https://electroniccats.com/store/nfc-copy-cat/">
  <img src="https://electroniccats.com/wp-content/uploads/badge_store.png" width="200" height="104" />
</a>

# DISCLAIMER
T
he NFC Copy Cat is a wireless penetration testing tool for use in authorized security audits where permitted. Check laws and obtain permission before using. Electronic Cats and Salvador Mendoza claim no responsibility for unauthorized use or damages.

Electronic Cats invests time and resources providing this open source design, please support Electronic Cats and open-source hardware by purchasing products from Electronic Cats!

Designed by Electronic Cats.

## License
![OpenSourceLicense](https://github.com/ElectronicCats/AjoloteBoard/raw/master/OpenSourceLicense.png)

Firmware released under an GNU AGPL v3.0 license. See the LICENSE file for more information.

Hardware released under an CERN Open Hardware Licence v1.2. See the LICENSE_HARDWARE file for more information.

Electronic Cats is a registered trademark, please do not use if you sell these PCBs.

8 July 2019
