#!/bin/sh
OSEK_CONFIG=.osek_config

#
# Manual or Auto
#
echo "Auto mode ?
 1: Auto config mode
 2: Manual config mode"
read auto
case "$auto" in
	"1")
		echo "# 3.2 Conformance classes" > $OSEK_CONFIG
		echo "class=ecc2" >> $OSEK_CONFIG;
		
		echo "# Target Name" >> $OSEK_CONFIG
		echo "target=osek.out" >> $OSEK_CONFIG;
		
		echo "# Status" >> $OSEK_CONFIG
		echo "define=EXTENDED" >> $OSEK_CONFIG;
		echo "" >> $OSEK_CONFIG;
		
		echo "create -> .osek_config";
		exit 0;;
	  *) ;;
esac

echo "# OSEK/VDX Config" > $OSEK_CONFIG

#
#
#
echo "arch
  1: C9 (ARM Cortex-A9)
  2: 
  [default=CA9] ?"
read arch

echo "# arch" >> $OSEK_CONFIG
if [ $arch="" ]; then
	arch=CA9
fi
echo "arch=$arch" >> $OSEK_CONFIG

#
# Conformance Class
#
echo "Conformance Class
 1: BCC1
 2: BCC2
 3: ECC1
 4: ECC2
 [default=4] ?"
read class

echo "# 3.2 Conformance classes" >> $OSEK_CONFIG
case "$class" in
	"1") echo "class=bcc1" >> $OSEK_CONFIG ;;
	"2") echo "class=bcc2" >> $OSEK_CONFIG ;;
	"3") echo "class=ecc1" >> $OSEK_CONFIG ;;
	  *) echo "class=ecc2" >> $OSEK_CONFIG ;;
esac

#
# Target Name
#
echo "Target Name
 [default:osek.out] ?"
read target

if [ $target="" ]; then
	target="osek.out";
fi

echo "# Target Name" >> $OSEK_CONFIG
echo "target=$target" >> $OSEK_CONFIG

#
# Status
#
echo "Status
 1: STANDARD
 2: EXTENDED
 [default=2]?"
read task

echo "# Status" >> $OSEK_CONFIG
case "$task" in
	"1") echo "define=STANDARD" >> $OSEK_CONFIG ;;
	  *) echo "define=EXTENDED" >> $OSEK_CONFIG ;;
esac

#
# main object
#
echo "sample object"
echo "input >"
read main

echo "# main" >> $OSEK_CONFIG
echo "main=$main" >> $OSEK_CONFIG

#
# End
#
echo "" >> $OSEK_CONFIG
echo "create => .osek_config"

