/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generate the MPH_to_*.h tables for C compilers that don't support designated initializers

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "MPH.h"
#include "MPH_to.h"

static void convert(const signed char MPH_to[MPH_MAX], const char *filename)
{
    FILE *fp = fopen(filename, "w");
    assert(NULL != fp);
    fputs("// This file is automagically generated by mphtogen, do not edit\n", fp);
    unsigned i;
    unsigned len = 0;
    for (i = 0; i < MPH_MAX; ++i) {
        if (len > 0) {
            fputc(',', fp);
            ++len;
        }
        if (len > 78) {
            fputc('\n', fp);
            len = 0;
        }
        fprintf(fp, "%3d", MPH_to[i]);
        len += 3;
    }
    if (len > 0) {
        fputc('\n', fp);
    }
    fclose(fp);
}

#define _(x) convert(MPH_to_##x, "../../libopensles/MPH_to_" #x ".h");

int main(int argc, char **argv)
{
    _(3DGroup)
    _(AudioPlayer)
    _(AudioRecorder)
    _(Engine)
    _(LEDDevice)
    _(Listener)
    _(MetadataExtractor)
    _(MidiPlayer)
    _(OutputMix)
    _(Vibra)
    _(MediaPlayer)
    return EXIT_SUCCESS;
}
