cal.percent.lowerboot <-
function(res.list,bootres=NULL,boot.range=c(3,303),
                     limit.year=c(2010,2026),limit.percentile=c("ATHL","0.1","0.2"),
                     sp.season=4){ # res: $B>-MhM=B,$N7k2L(B  # bootres: bootstrap$B$N7k2L(B
  
  # $B%V!<%H%9%H%i%C%W$N2s?t$H$=$l$>$l$N%V!<%H%9%H%i%C%W$G9T$C$?%7%_%e%l!<%7%g%s$N2s?t$rM?$($k(B
#  nboot <- nrow(bootres$biom.mat)
  nboot <- boot.range[2]-boot.range[1]+1
  boot.range2 <- boot.range[1]:boot.range[2]
  n.tmp <- nrow(res.list[[1]]$SSB)/nboot # $BA4$F$N>-MhM=B,$OF1$82s?t9T$C$F$$$k$H2>Dj(B  

  # ssb.hist; limit$B$H$J$k(BSSB$B$N4p=`!#%V!<%H%9%H%i%C%W$N2s?t(Bx$B9MN8$9$k4p=`$N?t(B
  ssb.hist <- rec.hist <- matrix(0,nboot,length(limit.percentile))
  dimnames(ssb.hist) <- dimnames(rec.hist) <- list(boot.range2,limit.percentile)

  a <- bootres$biom.list[[1]]
  # $BC1=c$J(Bquantile
  limit.tmp <- which(limit.percentile!="ATHL")
  for(i in 1:nboot){
    ssb.hist[i,limit.tmp] <- quantile(as.numeric(bootres$biom.mat[boot.range2[i],
                                                                  tmp <- a$period=="TIME" & a$season==sp.season]),
                                      probs=as.numeric(limit.percentile[limit.tmp]))
  }
  #$B2a5n(B10$B8D$NJ?6Q$r$H$k>l9g(B
  limit.tmp <- which(limit.percentile=="ATHL")
  for(i in 1:nboot){
    ssb.hist[i,limit.tmp] <- mean(sort(as.numeric(bootres$biom.mat[boot.range2[i],
                                                                   tmp <- a$period=="TIME" & a$season==sp.season]))[1:10])
    
  }  

  pr.ssb.min1 <- matrix(0,length(res.list),length(limit.percentile))
  dimnames(pr.ssb.min1) <- list(names(res.list),limit.percentile)  
  years <- as.numeric(colnames(res.list[[1]]$SSB))

  tmp.year <- years>=limit.year[1]&years<limit.year[2]&qtback(years)==sp.season
  for(k in 1:length(limit.percentile)){
      for(j in 1:length(res.list)){
        s1 <- 0      
        for(i in 1:nboot){
          s1 <- s1 + sum(apply(res.list[[j]]$SSB[(n.tmp*(i-1)+1):(n.tmp*i),tmp.year]<
                               ssb.hist[i,k],1,sum)>0)
        }
        pr.ssb.min1[j,k] <- s1/(n.tmp*nboot)* 100
      }
    }

  return(list(pr.ssb=pr.ssb.min1,ssb.hist=ssb.hist))
}

