create.defconf <-
function(MP=NULL,R.fun=NULL,interactive=TRUE){#interaction=FALSE){
  if(interactive==TRUE | is.null(MP) | is.null(R.fun)){
    cat("available option of MP: (1) MP.CESqt3 (constant F, and able to set upper limit of catch by fleet)
                        (2) MP.CESqt4 (constant F, and able to set constant catch by a specified fleet)
                        (3) MP.CHSfleet (constant quarterly catch)
                        (4) MP.CHS (prototype of MP.CHSfleet, not quarterly catch)\n")
    cat("Please select 1-4 [default: 1]: ")
    MP <- c("MP.CESqt3","MP.CESqt4","MP.CHSfleet","MP.CHS")[as.numeric(readline())]
    MP <- ifelse(is.na(MP),"MP.CESqt3",MP)    

    cat("available option of R.fun: (1) REC.resample (Resampling of past recruitment)
                           (2) REC.beverton.ss (inherit Beverton-Holt relation assumed in SS))
                           (3) REC.twophase (If SSB > historical median, resample R > R[SSB > historical median])\n")
    cat("Please select 1-4 [default: 1]: ")
    R.fun <- c("REC.resample","REC.beverton.ss","REC.twophase")[as.numeric(readline())]
    R.fun <- ifelse(is.na(R.fun),"REC.resample",R.fun)
  }

  char1 <- "config.tmp <- list(boot=c(1,300),     # specification of bootstrap from and to
                   pred.year=30,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=FALSE,  # Is detailed results such as NAA produced?
                   initial.year=2008, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean 
                   qt=4,              # Number of season per year\n"
  if(R.fun=="REC.resample"){
    char2 <- c("                  Rec.fun=\"REC.resample\", # Function for future recruitment
                   args.R=list(year.lim=c(1966,2006), # Options for future recruitment
                               qt=4,recruit.qt=2),\n")#,high.year=NULL,high.limit=Inf,high.time=0),\n")
  }
  else{
    if(R.fun=="REC.beverton.ss"){
    char2 <- c("                  Rec.fun=\"REC.beverton.ss\",     # Function for future recruitment
                   args.R=list(recruit.qt=2,resampled=FALSE,year.lim=c(1966,2006))      # Options for future recruitment,\n")
    }
    else{
      if(R.fun=="REC.twophase"){
    char2 <- c("                  Rec.fun=\"REC.twophase\",         # Function for future recruitment
                   args.R=list(recruit.qt=2),      # Options for future recruitment,\n")        
      }
    }}

  if(MP=="MP.CESqt3"){
    char3 <- c("                  MP=\"MP.CESqt3\",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2000,
                                    Fyear1=c(2004,2006),Fyear2=c(2004,2006)),\n")
  }
  else{
    if(MP=="MP.CESqt4"){
    char3 <- c("                  MP=\"MP.CESqt4\",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2000,
                                    Fyear1=c(2004,2006),Fyear2=c(2004,2006)),\n")      
    }
    else{
    if(MP=="MP.CHSfleet"){
    char3 <- c("                  MP=\"MP.CHSfleet\",    # Function for future harvesting
                   args.mp=list(CHS.qt=rep(1000,4), # Options for future harvesting
                                    start.regulation=2000,CES.plus=0,
                                    Fyear1=c(2004,2006),Fyear2=c(2004,2006)),\n")      
    }
    else{
      if(MP=="MP.CHS"){
    char3 <- c("                  MP=\"MP.CHS\",    # Function for future harvesting
                   args.mp=list(CHS0=NULL,CHS.year=c(2004,2006), # Options for future harvesting
                                    CHS.plus=0,select.year=c(2004,2006)),\n")      
            }      
        }
    }
  }
  char4 <- c("                  HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.    
                   )\n")
  cat(paste(char1,char3,char2,char4))
}

