do.boot.func <-
function(config){
  if(.Platform$OS.type=="unix"){
    system(paste2("cp -r orgrun_tmp ",config$wd))
  }
  else{
    system(paste2("xcopy orgrun_tmp ",config$wd," /I"))    
  }
  setwd(config$wd)

  file.copy2(from="ss3-org.par",to="ss3.par")
  file.copy2(from=paste2("../data-",config$wd,".ss"),to="data-boot.ss")                              
  s <- 1
  grad.tmp <- 10
  while(grad.tmp>config$grad.criteria && s < config$max.calc){ # $B7W;;$O#52s$^$G(B
    if(config$debug.mode==F){
      doss3(ss3.arg=config$ss3.arg,use.wine=config$use.wine)
    }
    grad.tmp <- read.grad(parfile="ss3.par")
    s <- s+1      
  }
  grad.rec <- list(grad=numeric(),ncalc=numeric())
  grad.rec$grad <- grad.tmp
  grad.rec$ncalc <- s-1
      
  file.copy2(from="Report.sso",to=paste2("../Report_",config$wd,".sso"))
  file.copy2(from="CompReport.sso",to=paste("../CompReport_",config$wd,".sso",sep=""))    
  file.copy2(from="ss3.par",to=paste("../ss3_",config$wd,".par",sep=""))

  faa <- calFAA.ss("Report.sso")
  save(faa,file=paste2("../faa",config$wd,".R"))

  setwd("../")
  unlink(config$wd,recursive=TRUE)  
  return(grad.rec)
}

