do.bootstrap.ss3.mc <-
function(namesfile="starter.ss",control.boot="control_boot.ctl",
                                orgdir="orgrun",
                                ss3.arg="-nox -nohess",nboot=300,use.wine=FALSE,
                                only.readdat=FALSE,use.parfile=TRUE,mcore=1,
                                is.plot=F,debug.mode=F,max.calc=5,grad.criteria=0.1,additive.num=0){

  # (1) starter.ss2$B$rFI$`(B
  # (2) $B#69TL\$NCM$r(Bnboot$B$KJQ99$7$F!"(Bstarter.ss2$B$r=q$-D>$9(B
  # (3) $BJQ99$5$l$?(Bstarter.ss2$B$,=q$-=P$5$l!"0l2s(BSS$B$,<B9T$5$l%V!<%H%9%H%i%C%WMQ$N(Bdat$B%U%!%$%k$,$G$-$k(B
  # (4) $B%3%s%H%m!<%k%U%!%$%k$,!"%V!<%H%9%H%i%C%WMQ$KMQ0U$5$l$F$$$?$b$N(B(control.boot)$B$HCV$-49$o$k(B
  # (3) ($B0J2<!"%V!<%H%9%H%i%C%W2sJ,$@$17+$jJV$9(B)
  #     SS2-nudata.dat$B$+$i0l8DJ,$N(Bdat$B%U%!%$%k$r@Z$j$@$7!"$=$N(Bdat$B%U%!%$%k(B(data-boot.ss)$B$r$b$H$K(B
  #     $B?dDj$7!"7k2L$r(Bss2boot-(i+additive.num).rep$B$K%3%T!<(B

  #--- error_check ---------------
  need.files <- c(orgdir,
                  paste2(orgdir,"/",control.boot),
                  paste2(orgdir,"/",namesfile))
  if(file.exists(need.files[3])){
    starter.tmp <- read.table(need.files[3],as.is=T)[1:2,]
    need.files <- c(need.files,
                    paste2(orgdir,"/",starter.tmp))
  }
#  need.files <- c(need.files,"ss3.exe","
  tmp <- file.exists(need.files)
  if(!all(tmp)) stop(paste2("Needed file(s) of \'",need.files[!tmp],"'\ is missing, and then stopped.\n"))
#  browser()  
  #-------------------------------

  # remove orgrun_tmp
  if(file.exists("orgrun_tmp")) unlink("orgrun_tmp",recursive=TRUE)

  # copy orgrun to orgrun_tmp
  if(.Platform$OS.type=="unix"){
    system(paste2("cp -r ",orgdir," orgrun_tmp"))
  }
  else{
    system(paste2("xcopy ",orgdir," orgrun_tmp /I"))    
  }  

  # move orgrun
  setwd("orgrun_tmp")
  file.copy2(from=namesfile,to=paste2(namesfile,"_o"))  

  #--- when the program is terminated, the namesfile (or starter file)---XS
  #                                  is replaced with the original one

  exit.function <- function(){
    save(grad.rec,file="grad.rec.R")
    if(mcore>2){
      sfStop()
    }
  }

  on.exit(exit.function())

  #---------- Read starter file
  names.obj <- names.obj.o <- read.table(namesfile,as.is=T)
  if(is.null(nboot)){
    nboot <- as.numeric(names.obj[11,1])  # Number of boot straps
  }
  if(nboot==0) stop("Please input a figure more than 0 in the 11th line")
  
  grad.rec <- data.frame(grad=rep(0,nboot+1),ncalc=rep(0,nboot+1))
  grad.tmp <- 10

  # if only.readdat==FALSE, do ss3 in orgrun_tmp
  if(only.readdat==FALSE){
    #---------- Write starter file
    names.obj[11,1] <- nboot
    names.obj[3,1] <- 0 # not use ss2.par
    write.table("#NuStarter.SS2",file=namesfile,row.names=F,col.names=F,quote=FALSE)      
    write.table(names.obj,file=namesfile,row.names=F,col.names=F,quote=FALSE,append=T)      
    #----------
  
    grad.tmp <- 10
    s <- 1
    #---------- Conduct 1 process for create dat files for bootstraps
    while(grad.tmp>grad.criteria && s<max.calc){ # $B7W;;$O#52s$^$G(B
      if(s>1){ # $B#22sL\$+$i$O(Bss.par$B$rFI$`(B
        names.obj[3,1] <- 1 
        write.table("#NuStarter.SS2",file=namesfile,row.names=F,col.names=F,quote=FALSE)      
        write.table(names.obj,file=namesfile,row.names=F,col.names=F,quote=FALSE,append=T)            
      }
      if(debug.mode==F){
        doss3(ss3.arg=ss3.arg,use.wine=use.wine) #!!
      }
      grad.tmp <- read.grad(parfile="ss3.par") #!!
      s <- s+1
    }
    grad.rec$grad[1] <- grad.tmp
    grad.rec$ncalc[1] <- s-1
  
    file.copy2(from="Report.sso",to="Report_org.sso")  #!!
    file.copy2(from="ss3.par",to="ss3-org.par")  #!!
    file.copy2(from="data.ss_new",to="data.ss_new_org")  #!!
    #  file.copy2(from=namesfile2,to=namesfile)
  }

  file.copy2(from="data.ss_new",to="data.ss_new_org")
  cf <- count.fields("data.ss_new",comment.char="")  #!!
  a <- read.table("data.ss_new",fill=T,col.names=paste("V",1:max(cf),sep=""),comment.char="") #!!
  
  cut.point <- c(2,which(a[,1]==999))

  #---------- modify starter.ss for bootstrapping
  names.obj[1,1] <- "data-boot.ss"
  names.obj[2,1] <- control.boot
  names.obj[3,1] <- as.numeric(use.parfile)
  names.obj[11,1] <- 0
  write.table("#NuStarter.SS2",file=namesfile,row.names=F,col.names=F,quote=FALSE)      
  write.table(names.obj,file=namesfile,row.names=F,col.names=F,quote=FALSE,append=T)
  #----------
  for(i in 1:nboot){
    if(debug.mode==FALSE){
      write.table(a[(cut.point[i]+1):cut.point[i+1],],na="",
                  file=paste("../data-b",sprintf("%03.0f",i+additive.num),".ss",sep=""),                
                  row.names=F,col.names=F,quote=FALSE)  # boot.dat$B$N99?7(B
    }
    else{
      write.table(a,na="",
                  file=paste("../data-b",sprintf("%03.0f",i+additive.num),".ss",sep=""),                
                  row.names=F,col.names=F,quote=FALSE)  # boot.dat$B$N99?7(B      
    }
#    file.copy2(from="data-boot.ss",to=paste("data-boot",sprintf("%03.0f",i+additive.num),".ss",sep=""))
  }

  setwd("../")  

  bootnames <- paste2("b",sprintf("%03.0f",1:nboot+additive.num))
  config.list <- as.list(1:nboot)
  config.list <- lapply(config.list,as.list)
  for(i in 1:nboot){
    config.list[[i]]$wd <- bootnames[i]
    config.list[[i]]$max.calc <- max.calc
    config.list[[i]]$grad.criteria <- grad.criteria
    config.list[[i]]$debug.mode <- debug.mode
    config.list[[i]]$ss3.arg <- ss3.arg
    config.list[[i]]$use.wine <- use.wine
  }
  if(mcore<2){
    res <- lapply(config.list,do.boot.func)
  }
  else{
#    library(snow)
#    cl <- makeCluster(mcore,"SOCK")
#    clusterEvalQ(cl,library(sstools))
#    res <- parLapply(cl,config.list,do.boot.func)
#    stopCluster(cl)
    library(snowfall)
    sfInit(parallel=TRUE,cpus=mcore)
    sfLibrary(sstools)
    sfLibrary(ssfuture)
    res <- sfLapply(config.list,do.boot.func)
    sfStop()    
  }

  ## plot of the results
  if(is.plot==T){
    tmp <- getBabs.ss2("ss3-org.rep")#,cl=cl0,tb=tb0)
    biom <- tmp[[1]]
    biom.target <- tmp[[2]]
    biom.list <- as.list(1:nboot)
    for(i in 1:nboot){
      biom.list[[i]] <- getBabs.ss2(paste2("Report",i+additive.num,".sso"),
                                    target.line=biom.target-10-nrow(biom))[[1]]
    }
    plotBSR(biom,biom.list)
  }
  save(res,file="grad.rec.R")

#  if(save.faa==TRUE){
#    for(i in 1:nboot){
#      faa <- calFAA.ss2(paste2("Report_b",sprintf("%03.0f",i+additive.num),".SSO"))
#      save(faa,file=paste2("faa",sprintf("%03.0f",i+additive.num),".R"))
#    }
#}
  return(res)
}

