MP.CESqt6 <-
function(cl,args.mp=list(
                           # 必ず必要なオプション
                           Fcur1=NULL, # CurrentF=漁業別年齢別Fのベクトル。管理前 <- do.projectionでは、Fyear1 を与えればdo.projectionで計算してくれる
                           Fcur2=NULL, # CurrentF=漁業別年齢別Fのベクトル。管理後 <- do.projectionでは、Fyear2 を与えればdo.projectionで計算してくれる
                         #  start.regulation=2011, # 管理を実施する年(この年から、Fcur2を用いる。さらに、cappingが設定されていればcappingを実施する。
                                                  # Fcur2を用いる年とcappingを実施する年を別の年にすることはできないので注意。cappingでadvanceオプションを用いる場合でも、advanceの設定の上にstart.regulationの年は上書きされる）
                           # 基本的には、make.partcachargの返り値を用いる
                           CES.multi=1,
                           # 必ずしも必要でないオプション
                           CES.plus=0,
                           CES.multi.year=NULL,# 1000年以上の将来予測をするとこのオプションでエラー出るので注意
                           # 内部で計算されるもの。翌年にも引き渡される引数
                           CES0=NULL,
                           # 漁獲量のキャッピングのオプション
                           catch.capping=NULL,
                           # or list(reg.fleet=c(2,3), #regulationをする漁業
                           #         upper.catch=c(3000,1000),# 漁獲量の上限
                           #         reset.timing=c(2,1)) # 漁獲量の上限をリセットするタイミング
                           # or list(advance=crule) # crule <- 特定の書式を満たした管理ルール
                           Fcur.list=NULL, # 漁業別年齢別Fのベクトルのリスト、Fの管理方策が変更になる時期毎に与える
                          # Fyear.list=NULL,# Fcur.listに対応した年のベクトルのリスト
                           Fcur.table=NULL # 1列目が、年四半期(数値、または文字列)、2列目が、当該年四半期に何番目のFcurを使用するか(integer)
                           )){
  qt.label <- c(0,0.25,0.5,0.75)
  current.season <- get.qtcode(cl$timing[1],qt.label=qt.label)
  year.label <- as.numeric(rownames(cl$faat))
  now.time <- as.numeric(cl$timing[1])


  #---- 入力されていないパラメータの入力
  if(is.null(args.mp$CES.plus)) args.mp$CES.plus <- 0
  if(is.null(args.mp$CES.multi.year)) args.mp$CES.multi.year <- rep(1,1000)
#  if(is.null(args.mp$gm))   args.mp$gm <- FALSE

  #----- tmp.CESの作成
  tmp.CES <- args.mp$CES0 * args.mp$CES.multi * args.mp$CES.multi.year[floor(now.time-cl$initial.year)+1]+ args.mp$CES.plus

  #------------------- catchのキャッピングを行う場合
  #-------------------
  args.mp$new.partial.ratio <- NULL # このオプションで使うnew.partial.ratioは毎回更新する
  cc.op <- args.mp$catch.capping


  # catch cappingが設定されていて、start.regulationよりもあと
  #
  #  cat("HERE42,")
 # if(now.time>=args.mp$start.regulation){
#    cat("(!is.null(cc.op)&&is.null(cc.op$advance)):",(!is.null(cc.op)&&is.null(cc.op$advance)),",")

  ## start.regulationの前か後かでは無くcapping,Fの設定のみで毎年の管理を決める
  #
  # 1) 当該年のベースのFを決定する
  # 2) cappingの設定をする
  # 3) 当該年にcappingが適用される場合は、cappingに応じて実際のFを漁業毎に調整する

  if(!is.null(args.mp$Fcur.list))Fcur.list<-args.mp$Fcur.list
  if(!is.null(args.mp$Fcur.table))Fcur.table<-args.mp$Fcur.table
 # cat("now.time:",now.time,"\n")
  Fcur<-Fcur.list[[Fcur.table[as.numeric(Fcur.table[,1])==now.time,2]]] #これは常に決まっているはず
##   cappingの開始時期を特定できるようにした）
  if(now.time>=args.mp$start.regulation.capping){
   # if((!is.null(cc.op)&&is.null(cc.op$advance)) || ifelse(!is.null(cc.op$advance),!all(is.na(cc.op$advance[cc.op$advance$Year==now.time,-1])),FALSE)){

     if(!is.null(cc.op) && is.null(cc.op$advance) || !is.null(cc.op$advance) && any(!is.na(cc.op$advance[cc.op$advance$Year==now.time,-1]))){
      ### cc.opは存在するが、cc.op$advanceは与えられていない ||  cc.op$advanceが存在して、当該年のcappingがNAでない漁業が一つでもある。
      if(!is.null(cc.op$advance)){
        if(is.null(args.mp$remaining.catch)){
          tmp <- cc.op$advance[cc.op$advance$Year==now.time,-1]
        }
        else{
          tmp <- args.mp$remaining.catch
        }
        reg.fleet <- which(!is.na(tmp))
        args.mp$remaining.catch <- tmp[!is.na(tmp)]
        #!!!これはどうなる？？      reset.timing <- cc.op$reset.timing
      }
      else{
#        browser()
        #------ 変数の初期化
        reg.fleet <- cc.op$reg.fleet
        upper.catch <- cc.op$upper.catch # 漁獲量上限量（年計）
        reset.timing <- cc.op$reset.timing
        # remaining catchの設定がされていないまたはスタート年の場合（計算の一番最初）
        if(now.time==args.mp$start.regulation){
          args.mp$remaining.catch <- upper.catch
        }
        #今の四半期がreset.timingなら、残りの漁獲量をリセットする
        for(i in 1:length(reg.fleet)){
          if(sum(current.season==reset.timing[[i]])>0){ # 複数の四半期がreset.timingとなってもいい
            args.mp$remaining.catch[i] <- upper.catch[i]
          }
        }
      }
  }

#      cat("HERE76,")

      #-------------- 予想される漁獲量(part.catch)を計算する
      #---- 複数漁業でupper limitを考える場合は、両方のFを動かして両方の漁獲量をぴったり合わせられる
      #---- とは限らない。その場合を考え、ある程度の残差を残して計算をストップさせるようにする？
      #---- ↑まだ実装はしていない
      #    part.F <- sweep(cl$partial.catch$ratio,1,tmp.CES,FUN="*")
      #    part.catch <- get.partialcatch(cl=cl,fleet.multi=rep(1,cl$nfleet),part.F=part.F)$part.catch

      # 今年の漁獲分と来年漁獲できる残りの漁獲量
 #     part.catch <- get.partialcatch(cl=cl,fleet.multi=rep(1,cl$nfleet),part.F=args.mp$Fcur2)$part.catch
      part.catch <- get.partialcatch(cl=cl,fleet.multi=rep(1,cl$nfleet),part.F=Fcur)$part.catch
  #    part.catch <- get.partialcatch(cl=cl,fleet.multi=ifelse(is.null(cl$fleet.multi),rep(1,cl$nfleet),cl$fleet.multi),part.F=args.mp$Fcur2)$part.catch
      ###    一部の漁業のFだけ上げる 2013/06/08
      remaining.catch.next <- args.mp$remaining.catch-part.catch[reg.fleet]
#      cat("r.c=",args.mp$remaining.catch)
#      cat(",r.c.next=",remaining.catch.next)
#      cat(",p.c=",part.catch[reg.fleet])
#      cat("\n")
      # 来年漁獲できる残りが負だったら ->その漁業はupper limit分だけ漁獲できないようにする
      adjust.F <- rep(1,cl$nfleet)
      if(sum(remaining.catch.next<0)>0){
        this.season.reg.fleet <- reg.fleet[which(remaining.catch.next<0)]
        this.season.upper <- args.mp$remaining.catch[which(remaining.catch.next<0)]
        # 漁獲量がゼロの場合
        if(sum(this.season.upper==0)){
          adjust.F[this.season.reg.fleet[this.season.upper==0]] <- 0
        }
      }

      # part.catchと残りの漁獲量を更新
 #     part.catch <- get.partialcatch(cl=cl,fleet.multi=adjust.F,part.F=args.mp$Fcur2)$part.catch
       part.catch <- get.partialcatch(cl=cl,fleet.multi=adjust.F,part.F=Fcur)$part.catch
      remaining.catch.next <- args.mp$remaining.catch-part.catch[reg.fleet]
      if(sum(remaining.catch.next<0)>0){
        this.season.reg.fleet <- reg.fleet[which(remaining.catch.next<0)]  # まず既定のFで、その四半期の
        this.season.upper <- args.mp$remaining.catch[which(remaining.catch.next<0)]
        # 残りの漁獲量が中度半端だった場合
        if(sum(this.season.upper>0)){ 
          tmp.F <- sweep(Fcur,2,adjust.F,FUN="*")
          tmp <- this.season.upper>0
          Npar <- length(this.season.reg.fleet[tmp])
          if(Npar>1){
            res <- optim(rep(0.3,Npar),# 初期値 1を0.1に変更した（2013/06/20）、なぜならこの計算を行う場合は、現在のFでは、cappingの上限に達してしまうケースが大半（全部？）
                         # であるため
                         cal.diffpartcatch,# 最小化すべき関数
                         part.F=tmp.F,cl=cl,reg.fleet=this.season.reg.fleet[tmp],
                         method="L-BFGS-B",
                         lower=0,
                         upper=5,
                         control=list(factr=1.0e7,maxit=50), # change maxit from 100(default to 50 2013-06-21)
                         upper.catch=this.season.upper[tmp]#upper.catch
                         )
            adjust.F[this.season.reg.fleet[tmp]] <- res$par  # 各漁業へのmultipler
          }
          else{
           res <- optimize(interval=c(0,1.3),#rep(1,Npar),# 初期値
                         f=cal.diffpartcatch,# 最小化すべき関数
                         part.F=tmp.F,cl=cl,reg.fleet=this.season.reg.fleet[tmp],
                         upper.catch=this.season.upper[tmp]#upper.catch
                         )
            adjust.F[this.season.reg.fleet[tmp]] <- res$minimum  # 各漁業へのmultipler
#            cat(res$objective," ")
         }
          #        cat(cl$timing," ",round(adjust.F,2),"\n")
        }
      }

      #   part.catch2 <- get.partialcatch(cl=cl,fleet.multi=adjust.F,part.F=args.mp$Fcur2) # 実際の漁獲量（たしかめ用）
      #args.mp$new.partial.ratio <- sweep(args.mp$Fcur2,2,adjust.F,FUN="*")
      args.mp$new.partial.ratio <- sweep(Fcur,2,adjust.F,FUN="*")
#      part.catch3 <- get.partialcatch(cl=cl,fleet.multi=adjust.F,part.F=args.mp$Fcur2)$part.catch
#      cat("|",round(part.catch3[[1]])[this.season.reg.fleet]," vs ",round(this.season.upper),"\n")

#      part.catch.final <- get.partialcatch(cl=cl,fleet.multi=adjust.F,part.F=args.mp$Fcur2)$part.catch
      part.catch.final <- get.partialcatch(cl=cl,part.F=args.mp$new.partial.ratio)$part.catch
      remaining.catch.next <- args.mp$remaining.catch-part.catch.final[reg.fleet]
#      browser()

      #      cat(" Actual:",round(part.catch3[[1]][this.season.reg.fleet]),"\n")
      tmp.CES <- apply(args.mp$new.partial.ratio,1,sum)

      # 来年の残りの漁獲量の更新
      if(!is.null(cc.op$advance)){
        tmp <- args.mp$catch.capping$advance[which(now.time==cc.op$advance$Year)+1,-1]
        tmp2 <- numeric()
        tmp2[reg.fleet] <- ifelse(remaining.catch.next>0,remaining.catch.next,0)
        tmp[which(tmp==-100)] <- tmp2[which(tmp==-100)]
#        args.mp$catch.capping$advance[which(now.time==cc.op$advance$Year)+1,-1] <- tmp
        args.mp$remaining.catch <- tmp
      }
      else{
        args.mp$remaining.catch <- ifelse(remaining.catch.next>0,remaining.catch.next,0)
#        cat(args.mp$remaining.catch,"\n")
      }
  }

  #----- ここまで来て、まだnew.partial.ratioがNULLだったら、、。
  #----- Fcur1とFcur2を設定しつつ、upper limitは設定していない場合、ということ
  if(is.null(args.mp$new.partial.ratio)){
    f.factor <- args.mp$CES.multi * args.mp$CES.multi.year[floor(now.time-cl$initial.year)+1]+ args.mp$CES.plus
      args.mp$CES0 <- apply(Fcur,1,sum)
      args.mp$new.partial.ratio <- Fcur * f.factor
    tmp.CES <- args.mp$CES0 * f.factor
  }

  list(res=tmp.CES,args.mp=args.mp)
}

