config.tmp <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=15,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                              #      fleet.multi2=c(1,5,5,5,1, 1,1,1,1,1, 1,5, 1,1),
                   catch.capping=list(reg.fleet=c(2,3,4,12), #regulationをする漁業
                                    upper.catch=c(5500,200,500,5000),# 漁獲量の上限
                                    reset.timing=c(2,3,3,3))), # 漁獲量の上限をリセットするタイミング),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )


config.1980s <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1980,1989), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )



config.BH <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=200,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation=2010,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),

                   Rec.fun="REC.beverton.ss", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               resampled=FALSE,steepness=0.95,sigmaR=0.8,R0=1.2e7),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )
# config.list[[1]]$args.mp$catch.capping$advance <-read.csv("capping_rule_BQ.csv")

config.res3_2yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                  catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2012,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_3yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2013,c(2010,2014:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_4yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                   catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2014,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.res3_5yrs <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=1000,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt3",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                start.regulation=2010,
                                Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                              catch.capping=list(advance=read.csv("capping_rule_1yr.csv"))),
                   Rec.fun="REC.resample3", # Function for future recruitment
                   args.R=list(year.lim=c(1952,2009), # Options for future recruitment
                               qt=4,recruit.qt=1,
                               # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
                               pyear.range =list(1991:1993,1952:2009),
                               # fyear.range <- list(2010:2012,2013:2013))
                               fyear.range=list(2011:2015,c(2010,2013:2031))),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
)

config.Fmult <- list(boot=c(1,1),     # specification of bootstrap from and to
                   pred.year=21,      # Projection year
                   N=20,              # N of simulations
                   record.NAA=TRUE,  # Is detailed results such as NAA produced?
                   initial.year=2010, # initial year of projection
                   ex.ssb=0,          # Below this number, the population is considered to extinct
                   gm=TRUE,           # Calculate selectivity by geometric or arithmetic mean
                   qt=4,              # Number of season per year
                   MP="MP.CESqt5",    # Function for future harvesting
                   args.mp=list(CES0=NULL,CES.multi=1, # Options for future harvesting
                                    start.regulation.capping=2011,
                                    Fyear1=c(2002,2004),Fyear2=c(2007,2009),
                                    fleet.multi.list=list(rep(1,14),rep(1,14),rep(1,14),rep(1,14)),
                                    Fyear.list=list(c(2007,2009),c(2007,2009),c(2007,2009),c(2007,2009)),
                                    fleet.multi.list=list(rep(1,14),rep(1,14),rep(1,14),rep(1,14)),
                                    Fcur.regime.list=list(c(2010,2010),c(2011,2014),c(2015,2017),c(2018,2031)),
                                    Age.multi.list=list(rep(1,21),rep(1,21),c(rep(0,3),rep(1,18)),rep(1,21)),
                    catch.capping=list(reg.fleet=c(2,3,4,12), #regulationをする漁業
                                    upper.catch=c(5500,200,500,5000),# 漁獲量の上限
                                    reset.timing=c(2,3,3,3))), # 漁獲量の上限をリセットするタイミング),
                   Rec.fun="REC.resample", # Function for future recruitment
                   args.R=list(year.lim=c(1980,1989), # Options for future recruitment
                               qt=4,recruit.qt=1),
                   HSlimit.tmp=NULL  # Is hockey-stick option used? If yes, input vectors of SSB breakpoint.
                   )


# res<-do.projection.ss(mcore=1,bootfiles=c("report.sso","report.sso"),config.list=config.Fmult)

config.list<-list(config.1980s,config.res3_2yrs,config.res3_3yrs,config.res3_4yrs,config.res3_5yrs)

do.proj<-function(configs=list(config.1980s,config.res3_2yrs,config.res3_3yrs,config.res3_4yrs,config.res3_5yrs),
    nsim=NA,smtp="mail.affrc.go.jp",HSlimit=NULL,do.parallel=FALSE,nparallel=4,seed=1234,reduce.cap=NA,record.NAA=TRUE){
 library(sendmailR)
 library(foreach)
 library(sstools)
 library(ssfuture)
 if(do.parallel){
    library(parallel)
#    library(doRNG)
    library(doParallel)
    cl<-makeCluster(nparallel)
    registerDoParallel(cl)
    on.exit(stopCluster(cl))
 }
  to<-c("yukiot@fra.affrc.go.jp","yukio_takeuchi@icloud.com")
  from<-"yukiot@fra.affrc.go.jp"

  subject <- paste("Finished in ",Sys.info()[4])
#  clusterSetRNGStream(cl, 123)
  for(i in 1:length(configs)){
      if(!is.na(nsim))configs[[i]]$N<-nsim
      if(!is.na(reduce.cap))configs[[i]]$args.mp$capping$advance<-reduce.cap*configs[[i]]$args.mp$capping$advance
      if(!is.null(HSlimit))configs[[i]]$HSlimit.tmp<-HSlimit
      configs[[i]]$record.NAA<-record.NAA
  }
  if(do.parallel){
    clusterEvalQ(cl,{library(sstools);library(ssfuture)})
    #clusterExport(cl,varlist=seed)
    #clusterEvalQ(cl,set.seed(seed))
    clusterEvalQ(cl,set.seed(1234))
  }else{
    set.seed(seed)
  }
  bsres_mix_recs<-list()
  bsres_mix_recs<-
    foreach(i=1:length(configs)) %dopar%{
      cat(i,";")
      if(!is.na(nsim))configs[[i]]$N<-nsim
      if(!is.null(HSlimit))configs[[i]]$HSlimit.tmp<-HSlimit
      bsres_mix_recs[[i]]<-do.projection.ss(mcore=1,bootfiles=c("Report.sso","Report.sso"),config.list=configs[[i]])
    }

  msg <- paste(" calculation(s) on ",Sys.info()[4], " finished at ",format(Sys.time(), "%Y-%m-%d  %H:%M:%OS3"))

  sapply(to,function(x){sendmail(from=from, to=x, subject=subject, msg=msg,control=list(smtpServer=smtp))})
  return(bsres_mix_recs)
}

if(0){
do.proj<-function(configs=list(config.1980s,config.res3_2yrs,config.res3_3yrs,config.res3_4yrs,config.res3_5yrs),
    nsim=NA,smtp="mail.affrc.go.jp",HSlimit=NULL,do.parallel=FALSE,nparallel=4,seed=1234,reduce.cap=NA,record.NAA=TRUE){
 library(sendmailR)
 library(foreach)
 library(sstools)
 library(ssfuture)
 if(do.parallel){
    library(parallel)
#    library(doRNG)
    library(doParallel)
    cl<-makeCluster(nparallel)
    registerDoParallel(cl)
    on.exit(stopCluster(cl))
 }
  to<-c("yukiot@fra.affrc.go.jp","yukio_takeuchi@icloud.com")
  from<-"yukiot@fra.affrc.go.jp"

  subject <- paste("Finished in ",Sys.info()[4])
#  clusterSetRNGStream(cl, 123)
  for(i in 1:length(configs)){
      if(!is.na(nsim))configs[[i]]$N<-nsim
      if(!is.na(reduce.cap))configs[[i]]$args.mp$capping$advance<-reduce.cap*configs[[i]]$args.mp$capping$advance
      if(!is.null(HSlimit))configs[[i]]$HSlimit.tmp<-HSlimit
      configs[[i]]$record.NAA<-record.NAA
  }
  if(do.parallel){
    clusterEvalQ(cl,{library(sstools);library(ssfuture)})
    #clusterExport(cl,varlist=seed)
    #clusterEvalQ(cl,set.seed(seed))
    clusterEvalQ(cl,set.seed(1234))
  }else{
    set.seed(seed)
    registerDoSEQ()
  }
  bsres_mix_recs<-list()
  bsres_mix_recs<-
    foreach(i=1:length(configs)) %dopar%{
      cat(i,";")
      if(!is.na(nsim))configs[[i]]$N<-nsim
      if(!is.null(HSlimit))configs[[i]]$HSlimit.tmp<-HSlimit
      do.projection.ss(mcore=1,bootfiles=c("Report.sso","Report.sso"),config.list=configs[[i]])
    }

  msg <- paste(" calculation(s) on ",Sys.info()[4], " finished at ",format(Sys.time(), "%Y-%m-%d  %H:%M:%OS3"))

  sapply(to,function(x){sendmail(from=from, to=x, subject=subject, msg=msg,control=list(smtpServer=smtp))})
  return(bsres_mix_recs)
}
}

do.4.projs<-function(reportFile="Report.sso",nsim=100){
  system.time(res<-do.proj(nsim=nsim,do.parallel=TRUE,reduce.cap=NA,reportFile=reportFile))
  save(list="res",file="res1.0.r")
  rm(res)
  system.time(res<-do.proj(nsim=nsim,do.parallel=TRUE,reduce.cap=0.9,reportFile=reportFile))
  save(list="res",file="res0.9.r")
  rm(res)
  system.time(res<-do.proj(nsim=nsim,do.parallel=TRUE,reduce.cap=NA,HSlimit=20000,reportFile=reportFile))
  save(list="res",file="res1.0_20000.r")
  rm(res)
  system.time(res<-do.proj(nsim=nsim,do.parallel=TRUE,reduce.cap=0.9,HSlimit=20000,reportFile=reportFile))
  save(list="res",file="res0.9_20000.r")
  rm(res)
}