REC.resample3 <-
function(cl,args.R=list(pyear.range=NULL,fyear.range=NULL,
                          qt=4,recruit.qt=1)){
  # give two lists of pyear.range and fyear.range
  # pyear.range <- list(c(1950:1960,1970:1980),c(2000:2003))
  # fyear.range <- list(2010:2012,2013:2013)

  #  rec.low <- rec[rec<args.R$high.limit*10000]
  res <- rep(0,nrow(cl$naat.pred))
  fyears <- rownames(cl$naat.pred)
  pyears <- as.numeric(rownames(cl$outdata$Numbers))
  rec.list <- list()

  for(i in 1:length(args.R$pyear.range)){
 #   cat("i:",i,",args.R$pyear.range[[",i,"]]=",args.R$pyear.range[[i]])
    rec.list[[i]] <- cl$outdata$Numbers[pyears %in% args.R$pyear.range[[i]]
                              ,colnames(cl$outdata$Numbers)==0]
    rec.list[[i]] <- rec.list[[i]][rec.list[[i]]!=0]
    tmp <- fyears %in% args.R$fyear.range[[i]]
    res[tmp] <-
         sample(rec.list[[i]],sum(tmp),replace=TRUE)
#    cat("HERE22\n")
#    browser()
  }

  # ss2に対応する部分。加入はrecruit.qtのみにおこるとする
  if(args.R$qt>2){
    tmp <- 1:length(res)
    res[tmp%%4!=args.R$recruit.qt] <- 0
  }
  res <- list(res=res,args.R=args.R)  # 第一年目も推定値を使う
}

