plotFuture.ss3 <-
function(z,rep.org,bootfiles=NULL,bootres=NULL,fig.legend=NULL,
                           multiplot=FALSE,datfile=NULL,plot.boot=T,sp.season=4,
                           rec.season=1,old.year.range=c(1965,2010),title.legend=NULL,
                           ylim.factor.tmp=c(1,1), # y$B<4$N>e8B%Y%/%H%k$ND9$5$K>h$8$k78?t!#2CF~$H(BSSB$B$KBP$7$F$N$_!#(B
                           last.year=c(2020,2040) # $B>-MhM=B,$N;~7ONs$rI=<($9$k$=$l$>$l$N4p=`G/(B
                           ){
#  library(RColorBrewer)
  old.par <- par()  

  if(is.null(bootres) & !is.null(bootfiles)){
    bootres <- read.bootfiles(bootfiles)
  }

  # boxplot ==> 90$B!s$N?.Mj6h4V$rI&$ND9$5$K$9$k$h$&$K$9$k(B
#  library(rgr)
#  boxplot <- function(at=at,...){
#    bwplots(xpos=at,label=NULL,...)
#  }
  boxplot2 <- function(x,probs=90,...){
    res <- boxplot.default(x,plot=F)
    res$stats[1,] <- sapply(x,quantile,probs=(100-probs)/200)
    res$stats[5,] <- sapply(x,quantile,probs=1-(100-probs)/200)
    bxp(res,...)
  }
  
   
  biom <- bootres$biom.list
  biom.mat <- bootres$biom.mat
  rec.mat <- bootres$rec.mat
  b0 <- getBabs.ss2(rep.org[1])[[1]]
  b0.rev <- b0[b0$period!="FORE" & b0$year>=old.year.range[1] & b0$year<old.year.range[2]+1,]
  
  #---- calculate total catch
  tmp <- apply(b0[b0$period=="TIME",substr(colnames(b0),1,9)=="ret_catch"],1,sum)  # total catch
  if(sum(tmp)==0){ #for the version of >=3.00
    tmp <- apply(b0[b0$period=="TIME",substr(colnames(b0),1,9)=="retain(B)"],1,sum)  # total catch    
  }  
  tot.org <- tapply(tmp,b0$year[b0$period=="TIME"],sum)
  #----
  
  if(length(rep.org)>1){
    b0.list <- list(numeric())
    tot.org.list <- list(numeric())
    for(i in 2:length(rep.org)){
      b0.list[[i-1]] <- getBabs.ss2(rep.org[i])[[1]]
      b0.list[[i-1]] <- b0.list[[i-1]][b0.list[[i-1]]$period!="FORE" &
                                       b0.list[[i-1]]$year>=old.year.range[1] &
                                       b0.list[[i-1]]$year<old.year.range[2]+1,]
      tmp <- apply(b0.list[[i-1]][b0.list[[i-1]]$period=="TIME",
                                substr(colnames(b0.list[[i-1]]),1,9)=="ret_catch"],1,sum)  # total catch
      if(sum(tmp)==0){ #for the version of >=3.00
        tmp <- apply(b0.list[[i-1]][b0.list[[i-1]]$period=="TIME",
                        substr(colnames(b0.list[[i-1]]),1,9)=="retain(B)"],1,sum)  # total catch    
      }  
      tot.org.list[[i-1]] <- tapply(tmp,b0.list[[i-1]]$year[b0.list[[i-1]]$period=="TIME"],sum)      
    }
  }
  else{
    b0.list <- NULL
  }
  
  if(multiplot==TRUE){
    tmp <- unlist(lapply(z,is.null))
    if(sum(tmp)>1){
      cat("warning :: no results are in res[[" ,which(tmp),"]]. Skip the results\n")
    }
    z <- z[!tmp]
    zs <- z[2:length(z)]      
    z <- z[[1]]
    wex.tmp <- 0.15
  }
  else{
    wex.tmp <- 0.5
  }

  years <- as.numeric(colnames(z$SSB))
  oldyears <- as.numeric(colnames(biom.mat))

#  set.mypar()
  
  layout(matrix(c(1,1,2,3,4,5,6,7,8,9,9,9),4,3,byrow=T),c(1,1.5,0.5),c(1,1,1,0.2))

  col.tmp <- c("white","gray","black","white")
  fg.tmp <- c("black","black",gray(0.5),gray(0.5))
  par(oma=c(0,0,3,0))#,cex.main=1)

  # Total recruitment
  years <- as.numeric(colnames(z$SSB))

  par(mar=c(3,3,2,0.3))
  if(length(rep.org)==1){
    a <- plotBSR(b0.rev,
                 what.plot=c(F,F,T),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[1],x.adjust=-0.25) # -0.25$B$O%S%s%J%,MQ$N(Bad hoc$B$J@_Dj!#%/%m%^%0%m$N$H$-$O(B0$B$H$+$KLa$9$3$H(B
  }
  else{
    a <- plotBSR(b0.rev,b0.list,
                 what.plot=c(F,F,T),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[1],col.var=1:length(rep.org),x.adjust=-0.25)
  }

  if(!is.null(bootres)){
#    browser()
    boxplot2(rec.mat[,tmp <- (qtback(oldyears)==rec.season & oldyears>=old.year.range[1]
                             & oldyears<old.year.range[2]+1) ],
            boxfill="lightgreen",lwd=0.5,yaxt="n",
            at=floor(oldyears)[tmp],add=T,show.names=FALSE,
            boxwex=0.5,cex=0.5,pch=20,names=F,lty=1)
  }

  # $BF1$8IA2h$r7+$jJV$9!J>e$KE@?dDjCM$N7k2L$r8+$;$k$?$a!"!"!K(B
  if(length(rep.org)==1){
    a <- plotBSR(b0.rev,
                 what.plot=c(F,F,T),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[1],add=TRUE,x.adjust=-0.25)
  }
  else{
    a <- plotBSR(b0.rev,b0.list,
                 what.plot=c(F,F,T),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[1],col.var=1:length(rep.org),add=TRUE,x.adjust=-0.25)
  }

  par(mar=c(3,0.3,2,1))
  years <- as.numeric(colnames(z$SSB))
  plot(0,type="n",xlim=last.year[2]+c(-0.2,0.6),ylim=c(0,a$ylim.res[3]),yaxt="n",xaxt="n",main="Future recruit",xlab="")
  boxplot2(as.data.frame(z$Recruitment[,qtback(years)==rec.season&floor(years)==last.year[2]]/1000),
           boxfill=col.tmp[1],lty=1,show.names=FALSE,
           at=last.year[2],add=T,
           boxwex=wex.tmp,outline=FALSE,names="",yaxt="n",lwd=0.5)
  mtext(side=1,last.year[2],line=1)
  if(multiplot==TRUE){
    #      abline(v=(2006:2035)+0.9,col="gray",lty=2)              
    for(i in 1:length(zs)){
      years <- as.numeric(colnames(zs[[i]]$SSB))          
      boxplot2(as.data.frame(zs[[i]]$Recruitment[,qtback(years)==rec.season&floor(years)==last.year[2]]/1000),
              type="l",boxfill=col.tmp[i+1],show.names=FALSE,
              at=last.year[2]+0.2*i,add=T,border=fg.tmp[i+1],lty=1,
              boxwex=wex.tmp,cex=0,pch=20,names=F,yaxt="n",lwd=0.5)
    }}

  abline.tmp <- function(b0.list){
    abline(h=quantile(x <- b0$Spawn[b0$period=="TIME" & b0$season==sp.season],probs=c(0,0.5)),
           col=gray(0.5),lty=2)
    abline(h=mean(sort(x)[1:10]),lty=1,col="gray")
    if(!is.null(b0.list)){
      for(i in 1:length(b0.list)){
        abline(h=quantile(x <- b0.list[[i]]$Spawn[b0.list[[i]]$period=="TIME" &
                 b0.list[[i]]$season==sp.season],probs=c(0,0.5)),
               col=i+1,lty=2)
        abline(h=mean(sort(x)[1:10]),lty=1,col=i+1)
      }
    }
      
  }

  # Total SSB
  par(mar=c(3,3,2,0.3))
  if(length(rep.org)==1){
    a <- plotBSR(b0.rev,
                 what.plot=c(F,T,F),xlim=old.year.range,rev.setting=T,nline=1,ylim.factor=ylim.factor.tmp[2])
  }
  else{
    a <- plotBSR(b0.rev,
                 biom.list=b0.list,what.plot=c(F,T,F),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[2],col.var=1:length(rep.org))    
  }
  abline.tmp(b0.list)  

  if(!is.null(bootres)){
    boxplot2(biom.mat[,tmp <- (qtback(oldyears)==sp.season & oldyears>=old.year.range[1]
                              & oldyears<old.year.range[2]+1) ],
            boxfill="lightgreen",lwd=0.5,show.names=FALSE,
            at=floor(oldyears)[tmp],add=T,
            boxwex=0.5,cex=0.5,pch=20,names=F,lty=1)
  }

  # Repeat same 
  if(length(rep.org)==1){
    a <- plotBSR(b0.rev,add=T,
                 what.plot=c(F,T,F),xlim=old.year.range,rev.setting=T,nline=1,ylim.factor=ylim.factor.tmp[2])
  }
  else{
    a <- plotBSR(b0.rev,add=T,
                 biom.list=b0.list,what.plot=c(F,T,F),xlim=old.year.range,rev.setting=T,nline=1,
                 ylim.factor=ylim.factor.tmp[2],col.var=1:length(rep.org))    
  }
  
  par(mar=c(3,0.3,2,1))
  years <- as.numeric(colnames(z$SSB))            
  plot(0,type="n",xlim=c(min(years),last.year[1]+0.8),ylim=c(0,a$ylim.res[2]),yaxt="n",xlab="Year",xaxt="n")
  abline.tmp(b0.list)
  axis(at=(min(years):last.year[1]) + 0.3,labels=(min(years):last.year[1]),side=1,tick=TRUE)
  points(floor(years[qtback(years)==sp.season]),apply(z$SSB[,qtback(years)==sp.season],2,median),type="l",lwd=1,
         col="darkgreen",yaxt="n")  
  boxplot2(as.data.frame(z$SSB[,qtback(years)==sp.season]),type="l",boxfill=col.tmp[1],lty=1,
          at=floor(years[qtback(years)==sp.season]),add=T,yaxt="n",show.names=FALSE,
          boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5)

  if(multiplot==TRUE){
    for(i in 1:length(zs)){
      years <- as.numeric(colnames(zs[[i]]$SSB))
      points(floor(years[qtback(years)==sp.season])+0.2*i,
             apply(zs[[i]]$SSB[,qtback(years)==sp.season],2,median),type="l",lwd=1,yaxt="n",
             col="darkgreen")      
      boxplot2(as.data.frame(zs[[i]]$SSB[,qtback(years)==sp.season]),type="l",boxfill=col.tmp[i+1],lty=1,
              at=floor(years[qtback(years)==sp.season])+0.2*i,add=T,yaxt="n",show.names=FALSE,
              boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5,border=fg.tmp[i+1])
    }}

#  browser()
  
  # Plot results of Equibrium year
  years <- as.numeric(colnames(z$SSB))                
  plot(0,type="n",xlim=last.year[2]+c(-0.2,0.6),ylim=c(0,a$ylim.res[2]),yaxt="n",xaxt="n",xlab="")
  abline.tmp(b0.list)  

  mtext(side=1,last.year[2],line=1)    

  if(multiplot==TRUE){
    for(i in 1:length(zs)){
        years <- as.numeric(colnames(zs[[i]]$SSB))                          
      boxplot2(as.data.frame(zs[[i]]$SSB[,qtback(years)==sp.season & floor(years)==last.year[2]]),
              type="l",boxfill=col.tmp[i+1],lty=1,show.names=FALSE,
              at=last.year[2]+0.1*i,add=T,yaxt="n",
              boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5,border=fg.tmp[i+1])
      }}

  # Total catch
  par(mar=c(3,3,2,0.3))
#  browser()
  tmp.year <- as.numeric(names(tot.org))
  plot(tmp.year[tmp.year>=old.year.range[1] & tmp.year<old.year.range[2]+1],
       tot.org[tmp.year>=old.year.range[1] & tmp.year<old.year.range[2]+1],
       type="l",xlab="Year",ylab="Total catch (MT)",ylim=c(0,max(tot.org)))
#  abline(h=(1:3)*10000,col=gray(0.5),lty=2)
  title("Total catch",line=1)
  if(length(rep.org)>1){
    for(i in 2:length(rep.org)){
#      browser()
      points(as.numeric(names(tot.org.list[[i-1]])),tot.org.list[[i-1]],type="l",col=i)
    }
  }

  par(mar=c(3,0.3,2,1))
  years <- as.numeric(colnames(z$SSB))                  
  plot(0,type="n",xlim=c(min(years),last.year[1]+0.8),yaxt="n",xlab="Year",
       ylim=c(0,max(tot.org)),xaxt="n")
#  abline(h=(1:3)*10000,col=gray(0.5),lty=2)
  axis(at=(min(years):last.year[1]) + 0.3,labels=(min(years):last.year[1]),side=1,tick=TRUE)
  y <- as.data.frame(t(rowtapply(t(z$Totcatch))))
  y <- y[,-ncol(y)]
  points(floor(years[qtback(years)==sp.season]),apply(y,2,median),type="l",lwd=1,
         col="darkgreen",yaxt="n")  
  boxplot2(y,boxfill=col.tmp[1],lty=1,show.names=FALSE,
          at=floor(years[qtback(years)==sp.season]),add=T,yaxt="n",
          boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5)
#    abline(v=2006,col="gray",lty=2)

  if(multiplot==TRUE){
    #      abline(v=(2006:2035)+0.9,col="gray",lty=2)      
    for(i in 1:length(zs)){
      y <- as.data.frame(t(rowtapply(t(zs[[i]]$Totcatch))))
      y <- y[,-ncol(y)]
      years <- as.numeric(colnames(zs[[i]]$SSB))
      points(floor(years[qtback(years)==sp.season])+0.2*i,apply(y,2,median),type="l",lwd=1,yaxt="n",
             col="darkgreen")      
      boxplot2(y,boxfill=col.tmp[i+1],lty=1,border=fg.tmp[i+1],show.names=FALSE,
              at=floor(years[qtback(years)==sp.season])+0.2*i,add=T,yaxt="n",
              boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5)
    }
  }

  # plot of 2026
  y <- as.data.frame(t(rowtapply(t(z$Totcatch))))
  y <- y[,-ncol(y)]
  years <- as.numeric(colnames(z$SSB))                  
  plot(0,type="n",xlim=last.year[2]+c(-0.2,0.6),yaxt="n",ylim=c(0,max(tot.org)),xlab="",xaxt="n")
#  abline(h=(1:3)*10000,col=gray(0.5),lty=2)                  
  boxplot2(y[colnames(y)==last.year[2]],boxfill=col.tmp[1],lty=1,
          at=last.year[2],add=T,yaxt="n",show.names=FALSE,
          boxwex=wex.tmp,cex=0,pch=20,names=NA,lwd=0.5)
  mtext(side=1,last.year[2],line=1)
#  browser()

  if(multiplot==TRUE){
    #      abline(v=(2006:2035)+0.9,col="gray",lty=2)      
    for(i in 1:length(zs)){
      y <- as.data.frame(t(rowtapply(t(zs[[i]]$Totcatch))))
      y <- y[,-ncol(y)]
      years <- as.numeric(colnames(zs[[i]]$SSB))                                      
      boxplot2(y[colnames(y)==last.year[2]],boxfill=col.tmp[i+1],lty=1,border=fg.tmp[i+1],
              at=last.year[2]+0.1*i,add=T,yaxt="n",show.names=FALSE,
              boxwex=wex.tmp,cex=0,pch=20,names=F,lwd=0.5)
    }
 }

  if(!is.null(fig.legend)){
    par(mar=c(0,2,0,2))
    nplot()
    legend("topleft",legend=fig.legend,title=title.legend,fill=col.tmp[1:length(fig.legend)],
           border=fg.tmp[1:length(fig.legend)],horiz=TRUE,
           bty="n",cex=1)
    legend("bottomright",legend=c("SSB lowest or 50%","ATHL"),col=c("gray","gray"),
         lty=c(2,1),horiz=TRUE,bty="n",cex=1)    
  }
#  par(old.par)  
}

