﻿#define DEBUG
using System;
using System.Xml.Serialization;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Threading.Tasks;
using System.IO;
using Windows.ApplicationModel.Store;
using Windows.System;
using Windows.Storage;
using Windows.UI.Core;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using System.Runtime.Serialization;
using FooEditEngine.Metro;

// 基本ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234237 を参照してください

namespace FooEditor
{
    /// <summary>
    /// 多くのアプリケーションに共通の特性を指定する基本ページ。
    /// </summary>
    public sealed partial class MainPage : FooEditor.Common.LayoutAwarePage
    {
        LicenseInformation licenseInfomation;
        public MainPage()
        {
            this.InitializeComponent();
            this.DataContext = this;
            this.DocumentCollectionBar.DataContext = this;
#if DEBUG
            this.licenseInfomation = CurrentAppSimulator.LicenseInformation;
            this.ad1.ApplicationId = "d25517cb-12d4-4699-8bdc-52040c712cab";
            this.ad1.AdUnitId = "10043134";
#else
            this.licenseInfomation = CurrentApp.LicenseInformation;
            this.ad1.ApplicationId = "10d877d4-6c21-42fe-8b89-9c8001a31f29";
            this.ad1.AdUnitId = "10076683";
#endif
            this.licenseInfomation.LicenseChanged += LicenseInformation_LicenseChanged;

            //this.LicenseInformation_LicenseChanged();

            Window.Current.CoreWindow.KeyUp += CoreWindow_KeyUp;
        }

        void CoreWindow_KeyUp(CoreWindow sender, KeyEventArgs e)
        {
            bool isCtrlPressed = WindowUtils.IsModiferKeyPressed(VirtualKey.Control);
            bool isShiftPressed = WindowUtils.IsModiferKeyPressed(VirtualKey.Shift);
            if (isCtrlPressed)
            {
                switch (e.VirtualKey)
                {
                    case VirtualKey.N:
                        this.AddCommand.Execute(null);
                        break;
                    case VirtualKey.Tab:
                        int selIndex = isShiftPressed ? this.DocumentCollectionList.SelectedIndex - 1 : this.DocumentCollectionList.SelectedIndex + 1;
                        if (selIndex > this.DocumentCollection.Count - 1)
                            selIndex = 0;
                        else if (selIndex < 0)
                            selIndex = this.DocumentCollection.Count - 1;
                        this.ActiveDocument(selIndex);
                        break;
                }
            }
        }

        void LicenseInformation_LicenseChanged()
        {
            this.ad1.Visibility = this.licenseInfomation.IsTrial ? Visibility.Visible : Visibility.Collapsed;
        }

        public ObservableCollection<DocumentPageInfo> DocumentCollection
        {
            get;
            private set;
        }

        /// <summary>
        /// このページには、移動中に渡されるコンテンツを設定します。前のセッションからページを
        /// 再作成する場合は、保存状態も指定されます。
        /// </summary>
        /// <param name="navigationParameter">このページが最初に要求されたときに
        /// <see cref="Frame.Navigate(Type, Object)"/> に渡されたパラメーター値。
        /// </param>
        /// <param name="pageState">前のセッションでこのページによって保存された状態の
        /// ディクショナリ。ページに初めてアクセスするとき、状態は null になります。</param>
        protected override async void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            try
            {
                StorageFile file = await ApplicationData.Current.LocalFolder.GetFileAsync("DocumentCollection.xml");
                using (Stream fs = await file.OpenStreamForReadAsync())
                {
                    DataContractSerializer serializer = new DataContractSerializer(typeof(ObservableCollection<DocumentPageInfo>));
                    this.DocumentCollection = (ObservableCollection<DocumentPageInfo>)serializer.ReadObject(fs);
                    this.DocumentCollectionList.ItemsSource = this.DocumentCollection;
                }
                await file.DeleteAsync();
                if (pageState != null && pageState.Count > 0)
                {
                    int selIndex = (int)pageState["ActiveIndex"];
                    if (selIndex != -1)
                    {
                        this.ActiveDocument(selIndex);
                        return;
                    }
                }
            }
            catch (FileNotFoundException)
            {
                this.DocumentCollection = new ObservableCollection<DocumentPageInfo>();
                this.DocumentCollectionList.ItemsSource = this.DocumentCollection;
            }
            this.Frame.Navigate(typeof(HomePage), this);
        }

        /// <summary>
        /// アプリケーションが中断される場合、またはページがナビゲーション キャッシュから破棄される場合、
        /// このページに関連付けられた状態を保存します。値は、
        /// <see cref="SuspensionManager.SessionState"/> のシリアル化の要件に準拠する必要があります。
        /// </summary>
        /// <param name="pageState">シリアル化可能な状態で作成される空のディクショナリ。</param>
        protected override async void SaveState(Dictionary<String, Object> pageState)
        {
            pageState["ActiveIndex"] = this.DocumentCollectionList.SelectedIndex;
            DataContractSerializer serializer = new DataContractSerializer(typeof(ObservableCollection<DocumentPageInfo>));
            StorageFile file = await ApplicationData.Current.LocalFolder.CreateFileAsync("DocumentCollection.xml", CreationCollisionOption.ReplaceExisting);
            using (Stream fs = await file.OpenStreamForWriteAsync())
            {
                serializer.WriteObject(fs, this.DocumentCollection);
            }
        }

        public DelegateCommand<object> AddCommand
        {
            get
            {
                return new DelegateCommand<object>((param) =>
                {
                    this.Frame.Navigate(typeof(HomePage), this);
                    this.TopAppBar.IsOpen = false;
                });
            }
        }

        public DelegateCommand<DocumentPageInfo> RemoveCommand
        {
            get
            {
                return new DelegateCommand<DocumentPageInfo>((param) =>
                {
                    param.doc.Dispose();
                    int index = this.DocumentCollection.IndexOf(param);
                    this.DocumentCollection.RemoveAt(index);
                    if (this.DocumentCollection.Count == 0)
                        this.Frame.Navigate(typeof(HomePage), this);
                    else if (index != -1)
                    {
                        this.ActiveDocument(index == 0 ? 0 : index - 1);
                    }
                    this.TopAppBar.IsOpen = false;
                });
            }
        }

        public async Task CreateDocument(FileType doctype)
        {
            DocumentControl doc = new DocumentControl();

            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            doc.Title = string.Format(loader.GetString("NewDocumentTitle"), this.DocumentCollection.Count);
            await doc.SetDocumentType(doctype);

            DocumentPageInfo info = new DocumentPageInfo(doc);
            this.DocumentCollection.Add(info);
            this.ActiveDocument(info);
        }

        public async Task CreateDocument(StorageFile file)
        {
            if (file != null)
            {
                DocumentControl doc = new DocumentControl();
                
                await doc.LoadFile(file);
                doc.Title = file.Name;
                
                DocumentPageInfo info = new DocumentPageInfo(doc);
                this.DocumentCollection.Add(info);
                this.ActiveDocument(info);
            }
        }

        private void DocumentCollectionList_ItemClick(object sender, ItemClickEventArgs e)
        {
            DocumentPageInfo info = (DocumentPageInfo)e.ClickedItem;
            this.ActiveDocument(info);
            this.TopAppBar.IsOpen = false;
        }

        private void ActiveDocument(int index)
        {
            DocumentPageInfo info = this.DocumentCollection[index];
            info.doc.ApplySetting(AppSettings.Current);
            this.Frame.Navigate(typeof(DocumentPage), new DocumentPageParam(this, info.doc));
            if(this.DocumentCollectionList.SelectedIndex != index)
                this.DocumentCollectionList.SelectedIndex = index;
        }

        private void ActiveDocument(DocumentPageInfo info)
        {
            this.ActiveDocument(this.DocumentCollection.IndexOf(info));
        }
    }
    public struct DocumentPageInfo : IXmlSerializable
    {
        public DocumentControl doc;
        public string Title
        {
            get
            {
                return doc.Title;
            }
        }
        public DocumentPageInfo(DocumentControl doc)
        {
            this.doc = doc;
        }

        public System.Xml.Schema.XmlSchema GetSchema()
        {
            return null;
        }

        public void ReadXml(System.Xml.XmlReader reader)
        {
            reader.ReadStartElement("DocumentPageInfo");
            this.doc = new DocumentControl();
            this.doc.ReadXml(reader);
        }

        public void WriteXml(System.Xml.XmlWriter writer)
        {
            writer.WriteStartElement("DocumentControl");
            this.doc.WriteXml(writer);
            writer.WriteEndElement();
        }
    }
}
