#ifndef GGAFDXCORE_GGAFDXALPHAFADER_H_
#define GGAFDXCORE_GGAFDXALPHAFADER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * tF[fBOxNX .
 * GgafDxDrawableActor ̃o
 * _alpha(AN^[̃x)Ȃ߂炩ɕωA<BR>
 * tF[fBOsƂȖړI<BR>
 * @version 1.00
 * @since 2010/07/28
 * @author Masatoshi Tsuge
 */
class GgafDxAlphaFader : public GgafCore::GgafObject {

public:
    /** [r]ΏۃAN^[ */
    GgafDxDrawableActor* const _pActor;

    /** [r/w]̋x(0:`1.0:s) */
    float _alpha;
    /** [r/w]̖ڕW̋x */
    float _target_alpha;
    /** [r/w]̋x */
    float _top_alpha;
    /** [r/w]̋x */
    float _bottom_alpha;
    /** [r/w]̖t[̋x̑ */
    float _velo_alpha;
    /** [r/w]̖t[̋x̑̑ */
    float _acce_alpha;
    /** [r]̃[vJEgA2łP[vi1̓At@x偨I(Г)A2̓At@x`1[vj */
    int _one_way_cnt;
    /** [r]̃Xgbv\̃[vJEg */
    int _stop_one_way_num;
    /** [r]̃tF[fBO@ */
    GgafDxAlphaFadingMethod _method;

    /** [r]r[gȂ`g̔g`ŃtF[fBÕA^bNt[ */
    frame _beat_attack_frames;
    /** [r]r[gȂ`g̔g`ŃtF[fBÕXgt[ */
    frame _beat_rest_frames;
    /** [r]r[gȂ`g̔g`ŃA^bN̎t[ */
    frame _beat_duration_frames;
    /** [r]r[gÃtF[fBOɔ₷t[ */
    frame _beat_target_frames;
    /** [r]r[gÃA^bN牺܂ł̃t[ */
    frame _beat_down_frames;
    /** [r]r[gAJE^[ */
    frame _beat_frame_count;
    /** [r]r[gAiԍ */
    int _beat_progres;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpΏۂActor
     */
    GgafDxAlphaFader(GgafDxDrawableActor* prm_pActor);

    /**
     * x𑊑Ύw .
     * @param prm_alpha_diff xl
     */
    inline void addAlpha(float prm_alpha_diff) {
        setAlpha(_alpha+prm_alpha_diff);
    }

    /**
     * xΎw
     * @param prm_alpha xl
     */
    inline void setAlpha(float prm_alpha) {
        if (_top_alpha < prm_alpha) {
            _alpha = _top_alpha;
        } else if (_bottom_alpha > prm_alpha) {
            _alpha = _bottom_alpha;
        } else {
            _alpha = prm_alpha;
        }
    }

    /**
     * x̏ݒ
     * @param prm_alpha1 xl1
     * @param prm_alpha2 xl2
     */
    inline void forceRange(float prm_alpha1, float prm_alpha2) {
        if (prm_alpha1 < prm_alpha2) {
            _bottom_alpha = prm_alpha1;
            _top_alpha = prm_alpha2;
        } else {
            _bottom_alpha = prm_alpha2;
            _top_alpha = prm_alpha1;
        }
    }

    /**
     * xZbg
     * {IuWFNg(GgafDxAlphaFader)ɂĕωO
     * ̑傫ɖ߂B
     */
    inline void setToBottom() {
        _alpha = _bottom_alpha;
    }

    inline void setToTop() {
        _alpha = _top_alpha;
    }

    /**
     * tF[fBO~B
     */
    inline void stopImmed() {
        _method = NO_ALPHAFADE;
    }

    /**
     * ԂZbg .
     * tF[h̏ꍇ͒~B
     * ӁFAAAt@l͕ύX܂B
     */
    void reset();

    /**
     * ݃tF[fBOǂ .
     * @return
     */
    inline bool isFading() {
        if (_method == NO_ALPHAFADE) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * ГtF[fBOit[wj .
     * ڕW̋xֈ葬xŃtF[fBOB
     * @param prm_target_alpha ڕWx
     * @param prm_spend_frame ₷t[
     */
    void fadeLinerUntil(float prm_target_alpha, frame prm_spend_frame);

    /**
     * ГtF[fBOixxwj .
     * ڕW̋xֈ葬xŃtF[fBOixwj .
     * @param prm_target_alpha ڕWx
     * @param prm_velo_alpha t[Z鋭x(>0.0)B̋xw肷鎖BZZ͎fB
     */
    void fadeLinerStep(float prm_target_alpha, float prm_velo_alpha);

    /**
     * ГtF[fBOixxExxwj .
     * ڕW̋x։wŃtF[fBOixxAxxwj .
     * xx0Ɏw肷 fadeLinerStep ƂقړӖɂȂB
     * fadeLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * @param prm_target_alpha ڕWx
     * @param prm_velo_alpha xx
     * @param prm_acce_alpha xx
     */
    void fadeAcceStep(float prm_target_alpha, float prm_velo_alpha, float prm_acce_alpha);

    /**
     * tF[fBOit[wj
     * ڕW̋xֈ葬xŃtF[fBOA葬xŌɖ߂B
     * [vw肷BiP[ṽt[wj .
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(frame prm_beat_target_frames, float prm_beat_num);

    /**
     * `gŃtF[fBOB .
     * <PRE>
     *             B
     * D  _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
     *            /      _                     /      _
     *           /         _                  /         _
     *          /            _               /            _
     *         /               _            /               _
     *        /                  _         /                  _
     * E  Q/                     _QQQ/                     _Q
     *
     *       A                  C
     *        @ 
     * </PRE>
     * KvȐݒl<BR>
     * @ P[ṽt[<BR>
     * A A^bN܂ł̃t[<BR>
     * B t[<BR>
     * C xet[<BR>
     * D x(_top_alphaAێ郿̋x)<BR>
     * E x(_bottom_alphaAێ郿̋x)<BR>
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_duration_frames }ŇB̃t[
     * @param prm_rest_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_duration_frames,
              frame prm_rest_frames,
              float prm_beat_num);

    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     */
    virtual void behave();

    virtual ~GgafDxAlphaFader();
};

}
#endif /*GGAFDXCORE_GGAFDXALPHAFADER_H_*/

