#ifndef GGAFDXCORE_GGAFDXAXESMOVERHELPERA_H_
#define GGAFDXCORE_GGAFDXAXESMOVERHELPERA_H_
#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/dxcore/util/GgafDxAccelerator.hpp"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 * B̏A .
 * t(B)̕⍲s܂B
 * @version 1.00
 * @since 2013/12/16
 * @author Masatoshi Tsuge
 */
class GgafDxAxesMoverHelperA : public GgafCore::GgafObject {

public:
    /** [r]t */
    GgafDxAxesMover* _pMaster;
    GgafDxAccelerator<coord> _smthVxMv;
    GgafDxAccelerator<coord> _smthVyMv;
    GgafDxAccelerator<coord> _smthVzMv;
public:
    /**
     * RXgN^<BR>
     * @param   prm_pMaster  t
     */
    GgafDxAxesMoverHelperA(GgafDxAxesMover* prm_pMaster);

    /**
     * Ȃ߂炩ȈړxωV[NGXs(ԁEwAxϓ) .
     * ړɔ₳鎞(Te)3̃ZNVɕÂ悤ȑxIɍsB<BR>
     * E 0     `  p1*Te ܂ EEE ݂̑xgbvXs[h܂ŉ(or)ړ<BR>
     * E p1*Te `  p2*Te ܂ EEE gbvXs[hœړ<BR>
     * E p2*Te `  Te    ܂ EEE gbvXs[hŏIXs[h֌(or)ړ<BR>
     * }Q<BR>
     * <pre>
     *
     *    x(v)
     *     ^
     *     |
     *     |                         V0:_̑x
     *     |                         Ve:ŏIx
     *     |                          D:ڕWړ
     *   Vt|....___________          Te:ڕWԁit[j
     *     |   /:         :_        p1:gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(0.0`1.0)
     *   Ve|../.:.........:.._      p2:JnƂȂ悤ȁATeɑ΂銄(0.0`1.0)
     *     | /  :         :    |     Vt:EԂ瓱gbvXs[h
     *     |/   :         :    |
     *   V0|    :    D    :    |
     *     |    :         :    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |  p1*Te     p2*Te  Te
     *
     * </pre>
     * ŏIXs[h(Ve)AڕWړ(D)ABڕW(Te)Ay p1, p2 w肷B<BR>
     * gbvXs[h(Vt)͓ŎvZ肳B<BR>
     * @param prm_target_distance ڕWړ(D)
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_velo ŏIXs[h(Ve)
     * @param prm_endacc_flg true:ڕWړɒBۂɉxOɋݒ/false:x͂̂܂܂ɂĂ
     */
    void slideVxMvByDt(coord prm_target_distance, int prm_target_frames,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVyMvByDt(coord prm_target_distance, int prm_target_frames,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVzMvByDt(coord prm_target_distance, int prm_target_frames,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVxyzMvByDt(coord prm_x_target_distance, coord prm_y_target_distance, coord prm_z_target_distance,
                         int prm_target_frames,
                         float prm_p1, float prm_p2, velo prm_end_velo,
                         bool prm_endacc_flg) {
        slideVxMvByDt(prm_x_target_distance, prm_target_frames,
                      prm_p1, prm_p2, prm_end_velo,
                      prm_endacc_flg);
        slideVyMvByDt(prm_y_target_distance, prm_target_frames,
                      prm_p1, prm_p2, prm_end_velo,
                      prm_endacc_flg);
        slideVzMvByDt(prm_z_target_distance, prm_target_frames,
                      prm_p1, prm_p2, prm_end_velo,
                      prm_endacc_flg);
    }

    void slideVxyzMvByDtTo(coord prm_x_target, coord prm_y_target, coord prm_z_target,
                           int prm_target_frames,
                           float prm_p1, float prm_p2, velo prm_end_velo,
                           bool prm_endacc_flg);

    /**
     * Ȃ߂炩ȈړxωV[NGXs(xEwAԕϓ) .
     * ړ3̃ZNV(d1,d2,d3)ɕÂ悤ȑxIɍsB<BR>
     * E 0     `  d1       ܂ EEE ݂̑xgbvXs[h܂ŉ(or)ړ<BR>
     * E d1    `  d1+d2    ܂ EEE gbvXs[hœړ<BR>
     * E d1+d2 `  d1+d2+d3 ܂ EEE gbvXs[hŏIXs[h֌(or)ړ<BR>
     * }Q<BR>
     * <pre>
     *    x(v)
     *     ^
     *     |                         V0:_̑x
     *     |                         Vt:gbvXs[h
     *     |                         Ve:ŏIx
     *     |         D=d1+d2+d3       D:ڕWړ(D=d1+d2+d3)
     *   Vt|....___________          p1:gbvXs[hɒB鋗ƂȂ悤ȁA(D)ɑ΂銄
     *     |   /|         |_            ܂    d1 = D*p1 ƂȂ悤 p1 (0.0`1.0)
     *   Ve|../.|.........|.._      p2:JnƂȂ悤ȁA(D)ɑ΂銄
     *     | /  |         |    |         ܂ d1+d2 = D*p2 ƂȂ悤 p2 (0.0`1.0)
     *     |/   |         |    |     Te:₳Kvԁit[j
     *   V0| d1 |    d2   | d3 |
     *     |    |         |    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |                  Te
     *
     * </pre>
     * gbvXs[h(Vt)AŏIXs[h(Ve)AڕWړ(D)Ay p1, p2 w肷B<BR>
     * ₳鎞(Te)͓Ŏv肳B<BR>
     * <BR>
     * @param prm_top_velo gbvXs[h(Vt)
     * @param prm_target_distance ڕWړ(D)
     * @param prm_p1 gbvXs[hɒB鋗ƂȂ悤ȁA(D)ɑ΂銄B(d1 = D*prm_p1)
     * @param prm_p2 JnƂȂ悤ȁA(D)ɑ΂銄 (d1+d2 = D*p2)
     * @param prm_end_velo ŏIXs[h(Ve)
     * @param prm_endacc_flg true:ڕWԂɒBۂɉxOɋݒ/false:x͂̂܂܂ɂĂ
     */
    void slideVxMvByVd(velo prm_top_velo, coord prm_target_distance,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVyMvByVd(velo prm_top_velo, coord prm_target_distance,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVzMvByVd(velo prm_top_velo, coord prm_target_distance,
                       float prm_p1, float prm_p2, velo prm_end_velo,
                       bool prm_endacc_flg);

    void slideVxyzMvByVd(velo prm_top_velo,
                         coord prm_x_target_distance, coord prm_y_target_distance, coord prm_z_target_distance,
                         float prm_p1, float prm_p2, velo prm_end_velo,
                         bool prm_endacc_flg);

    void slideVxyzMvByVdTo(velo prm_top_velo,
                          coord prm_x_target, coord prm_y_target, coord prm_z_target,
                          float prm_p1, float prm_p2, velo prm_end_velo,
                          bool prm_endacc_flg);

    bool isSlidingMv() {
        if (_smthVxMv._prm._flg || _smthVyMv._prm._flg || _smthVzMv._prm._flg) {
            return true;
        } else {
            return false;
        }
    }

    void stopSlidingMv() {
        _smthVxMv._prm._flg = false;
        _smthVyMv._prm._flg = false;
        _smthVzMv._prm._flg = false;
    }

    bool isJustFinishSlidingMv() {
        if (isSlidingMv()) {
            return false;
        } else {
            if (_smthVxMv._prm._progress != -1 || _smthVyMv._prm._progress != -1 || _smthVzMv._prm._progress != -1) {
                return true;
            } else {
                return false;
            }
        }
    }
    virtual void behave();

    virtual ~GgafDxAxesMoverHelperA();
};

}
#endif /*GGAFDXCORE_GGAFDXAXESMOVERHELPERA_H_*/

