#ifndef GGAFDXCORE_GGAFDXTEXTUREBLINKER_H_
#define GGAFDXCORE_GGAFDXTEXTUREBLINKER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * J[_ŎxNX.
 * GgafDxModel ̃o _power_blink <BR>
 * AȒPɑ삷邽߂ɐ݌vB<BR>
 * ŏIIɃsNZVF[_[ŐF(float4)ɏ悸lƂȂB
 * Fx 1.0 ͐FxA
 * Fx 2.0 ͐FxQ{B邭ȂB
 * Fx 0.5 ͐Fx1/Q{BÂȂB
 * TODO:GgafDxScaler,GgafDxMorpher,GgafDxTextureBlinker ʉB
 * @version 1.00
 * @since 2009/05/22
 * @author Masatoshi Tsuge
 */
class GgafDxTextureBlinker : public GgafCore::GgafObject {

public:
    /** ΏۃAN^[ */
    GgafDxModel* const _pModel;

    /** Fx(0.0 ` 100.0) */
    float _power_blink;
    /** ڕW̐Fx */
    float _target_power_blink;
    /** Fx */
    float _top_power_blink;
    /** Fx */
    float _bottom_power_blink;
    /** t[̐Fx̑ */
    float _velo_power_blink;
    /** t[̐Fx̑̑ */
    float _acce_power_blink;
    /** Opg̔g`œ_ł̃A^bNt[ */
    frame _beat_attack_frames;
    /** Opg̔g`œ_ł̃Xgt[ */
    frame _beat_rest_frames;
    /** _łɔ₷t[ */
    frame _beat_target_frames;
    /** _łJnt[ */
    frame _frame_of_beat_begin;
    /** r[gAẽA^bN牺܂ł̃t[ */
    frame _beat_down_frames;
    /** r[gAJE^[ */
    frame _beat_frame_count;
    /** r[gAiԍ */
    int _beat_progres;
    /** [vJEgi2œ_ŃZbgA1ȂΓ_o̕Гj */
    int _one_way_cnt;
    /** Xgbv\̃[vJEg */
    int _stop_one_way_num;
    /** _ŕ@ */
    GgafDxBlinkingMethod _method;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pModel  KpΏۂModel
     */
    GgafDxTextureBlinker(GgafDxModel* prm_pModel);

    /**
     * Fx𑊑Ύw
     * @param prm_power_blink_diff Fxl
     */
    void addPower(float prm_power_blink_diff) {
        setPower(_power_blink + prm_power_blink_diff);
    }

    /**
     * FxΎw
     * @param prm_power_blink Fxl
     */
    void setPower(float prm_power_blink) {
        //_TRACE_("setPower ["<<prm_<<"]prm_power_blink="<<prm_power_blink);
        //_TRACE_("setPower _bottom_power_blink["<<prm_<<"]="<<_bottom_power_blink<<"/_top_power_blink["<<prm_<<"]="<<_top_power_blink<<"");
        if (_top_power_blink < prm_power_blink) {
            _power_blink = _top_power_blink;
        } else if (_bottom_power_blink > prm_power_blink) {
            _power_blink = _bottom_power_blink;
        } else {
            _power_blink = prm_power_blink;
        }
        //_TRACE_("setPower _power_blink ["<<prm_<<"] _power_blink="<<prm_power_blink);
    }

    /**
     * ΏېFlƁAFx̏ݒ .
     * ΏېFlƂ́A_łΏۂ̃eNX`̐F̋łB<BR>
     * sNZVF[_[ɂāA<BR>
     * E܂ł̌vZFieNX`⃉Cglς݁jEEE colOut.rgba<BR>
     * EeNX`̐F EEE colTex.rgba<BR>
     * EΏېFl EEE g_tex_blink_threshold<BR>
     * E݂̐Fxl EEE g_tex_blink_power<BR>
     * ƂꍇAȉ̗lȏsȂĂ܂B<BR>
     * <code><pre>
     * <BR>
     * if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
     *     colOut *= g_tex_blink_power; //ă{|B_łڗB
     * }
     * </pre></code>
     * @param prm_blink_threshold _ł̑ΏېFl (0.0 ` 1.0)
     * @param prm_power_blink1 Fxl1 (̐ ` 0: ` 1.0:{x ` )
     * @param prm_power_blink2 Fxl2 (̐ ` 0: ` 1.0:{x ` )
     */
    void setBlinkableRange(float prm_blink_threshold, float prm_power_blink1, float prm_power_blink2);

    /**
     * FxɃZbg
     */
    void setPowerToBottom() {
        _power_blink = _bottom_power_blink;
    }

    /**
     * FxɃZbg
     */
    void setPowerToTop() {
        _power_blink = _top_power_blink;
    }

    /**
     * _ł~B.
     */
    void stopImmed();

    /**
     * Г_iSEt[wj .
     * ڕW̐Fxֈ葬xłP_ij
     * @param prm_target_power_blink ڕWFx
     * @param prm_spend_frame ₷t[
     */
    void blinkLinerUntil(float prm_target_power_blink, frame prm_spend_frame);

    /**
     * Г_iSEFxxwj .
     * ڕW̐Fxֈ葬xłP_ij
     * @param prm_target_power_blink ڕWFx
     * @param prm_velo_power_blink t[ZFx(>0.0)B̐Fxw肷鎖B
     *                             Fx̉ZZ݂͌̐FxڕWFxႢŎfB
     */
    void blinkLinerStep(float prm_target_power_blink, float prm_velo_power_blink);

    /**
     * Г_iSEFxxEFxxwj .
     * ڕW̐Fx։włP_ij
     * Fxx0Ɏw肷 blinkLinerStep ƂقړӖɂȂB
     * blinkLinerStep ̑Q͐Cɂ邱ƖA{\bh͐̎͂Ȃ̂ŒӂĐݒ肹B
     * @param prm_target_power_blink ڕWFx
     * @param prm_velo_power_blink Fxx
     * @param prm_acce_power_blink Fxx
     */
    void blinkAcceStep(float prm_target_power_blink, float prm_velo_power_blink, float prm_acce_power_blink);

    /**
     * _ .
     * ڕW̐Fxi_top_power_blinkjֈ葬xŌA葬xŐFxi_bottom_power_blinkjɖ߂B
     * P[vƂA₷t[w肷B
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(frame prm_beat_target_frames, float prm_beat_num);

    /**
     * Opg̔g`œ_łB.
     * <PRE>
     * C  _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
     *            /_                     /_
     *           /   _                  /   _
     *          /      _               /      _
     *         /         _            /         _
     *        /            _         /            _
     * D  Q/               _QQQ/               _Q
     *
     *       A            B
     *        @ 
     * </PRE>
     * KvȐݒl<BR>
     * @ P[ṽt[<BR>
     * A A^bN܂ł̃t[<BR>
     * B xet[<BR>
     * C Fx(_top_power_blinkێ)<BR>
     * D Fx(_bottom_power_blinkێ)<BR>
     * <BR>
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num);


    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     */
    virtual void behave();

    virtual ~GgafDxTextureBlinker();
};

}
#endif /*GGAFDXCORE_GGAFDXTEXTUREBLINKER_H_*/

