#ifndef GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_
#define GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_
#include "jp/ggaf/dxcore/sound/GgafDxBgmPerformer.h"

namespace GgafDxCore {

/**
 * BGMtxNX .
 * V[IuWFNgɁAێ鎖ɂāA
 * BGMtF[hCAtF[hAEg@\tB
 * GgafDxScene::processSettlementBehavior() ŁA{NX
 * behave() \bhR[dlB<BR>
 * GgafDxBgmPerformer 番
 * @version 1.00
 * @since 2012/03/22
 * @author Masatoshi Tsuge
 */
class GgafDxBgmPerformerForScene : public GgafDxBgmPerformer {
private:

    void fadein_f(int prm_id, frame prm_frame);
    void play_fadein_f(int prm_id, frame prm_frame);
    void fadeout_f(int prm_id, frame prm_frame);
    void fadeout_stop_f(int prm_id, frame prm_frame);

public:
    /** [r]BGMƊ֘AtV[ */
    GgafDxScene* _pDxScene;
    /** [r]tF[h^[Qbg{[̔z(Y̓`l) */
    double* _paDouble_target_volume;
    /** [r]{[Zl̔z(Y̓`l) */
    double* _paDouble_inc_volume;
    /** [r]݃tF[hۂ̔z(Y̓`l) */
    bool* _paBool_is_fade;
    /** [r]tF[h~̂ǂ̔z(Y̓`l) */
    bool* _paBool_is_fadeout_stop;
    /** [r/w]ftHg̃tF[hCEtF[hAEg̔₷t[ */
    frame _default_fade;

public:
    /**
     * RXgN^
     * @param prm_pDxScene V[
     */
    GgafDxBgmPerformerForScene(GgafDxScene* prm_pDxScene);

    /**
     * BGM錾 .
     * @param prm_bgm_num       tBGM
     * @param prm_default_fade  tF[hCtF[hAEg̃ftHgt[
     */
    virtual void useBgm(int prm_bgm_num, frame prm_default_fade);

    /**
     * BGM錾 .
     * tF[hCtF[hAEg̃t[Ԃ360(6b)ɐݒ肳B
     * @param prm_bgm_num tBGM
     */
    virtual void useBgm(int prm_bgm_num) override {
        useBgm(prm_bgm_num, 360);
    }

    /**
     * BGM̐U镑 .
     * Ƀ{[ωAtF[hCEAEgʂB
     */
    virtual void behave();

    /**
     * ĐBGMɃtF[hʂsB
     * @param prm_id              BGM`lԍ(0 ` )
     * @param prm_frame           tF[hɔ₷t[
     * @param prm_target_volume   BڕW{[(0 ` 100)
     */
    virtual void fade(int prm_id, frame prm_frame, int prm_target_volume);

    /**
     * ĐBGMɃtF[hCʂsB
     * @param prm_id  BGM`lԍ(0 ` )
     */
    virtual void fadein(int prm_id);

    /**
     * BGMAtF[hCɂĐJnB
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void play_fadein(int prm_id);

    /**
     * ĐBGMɃtF[hAEgʂsB
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void fadeout(int prm_id);

    /**
     * ĐBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void fadeout_stop(int prm_id);

    /**
     * BGMAtF[hʖŁAʂɍĐJnB
     * @param prm_id       BGM`lԍ(0 ` )
     * @param prm_volume   {[(0`100)
     * @param prm_is_loop  [v邩ǂitrue:[vĐ^false:[vĐȂj
     */
    virtual void play(int prm_id, int prm_volume, bool prm_is_loop) override;

    /**
     * BGMAtF[hʖŁAʂɃ[vĐJnB
     * @param prm_id       BGM`lԍ(0 ` )
     * @param prm_volume   {[(0`100)
     */
    virtual void play(int prm_id, int prm_volume) override {
        play(prm_id, prm_volume, true);
    }

    /**
     * BGMAtF[hʖŁAʂɃ{[100Ń[vĐJnB
     * @param prm_id       BGM`lԍ(0 ` )
     */
    virtual void play(int prm_id) override {
        play(prm_id, GGAF_MAX_VOLUME);
    }

    /**
     * S`lԍ̍ĐBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     */
    virtual void fadeout_stop();

    /**
     * tF[hCtF[hAEg̃ftHgt[Ԃݒ .
     * @param prm_default_fade tF[hɔ₷t[
     */
    void setDefaultFadeFrames(frame prm_default_fade) {
        _default_fade = prm_default_fade;
    }

    virtual ~GgafDxBgmPerformerForScene();
};

}
#endif /*GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_*/
