#include "stdafx.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"

#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/core/util/GgafRepeatSeq.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"
#include "jp/ggaf/dxcore/effect/GgafDxEffect.h"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/GgafDxGod.h"
#include "jp/ggaf/dxcore/manager/GgafDxEffectManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelConnection.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelManager.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/dxcore/scene/GgafDxScene.h"
#include "jp/ggaf/dxcore/sound/GgafDxSe.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxDrawableActor* GgafDxUniverse::_apAlphaActorFirstList_DrawDepthLevel[MAX_DRAW_DEPTH_LEVEL+1];
GgafDxDrawableActor* GgafDxUniverse::_apAlphaActorLastList_DrawDepthLevel[MAX_DRAW_DEPTH_LEVEL+1];
//GgafDxDrawableActor* GgafDxUniverse::_pActors_DrawMaxDrawDepth = nullptr;
GgafDxDrawableActor* GgafDxUniverse::_pActor_DrawActive = nullptr;
std::string GgafDxUniverse::_seqkey_se_delay = "_SE_D_";

coord GgafDxUniverse::_x_gone_left   = 0;
coord GgafDxUniverse::_x_gone_right  = 0;
coord GgafDxUniverse::_y_gone_top    = 0;
coord GgafDxUniverse::_y_gone_bottom = 0;
coord GgafDxUniverse::_z_gone_far   = 0;
coord GgafDxUniverse::_z_gone_near  = 0;


GgafDxUniverse::SeArray::SeArray() {
#ifdef MY_DEBUG
    if (PROPERTY::MAX_SE_AT_ONCE > 64) {
        throwGgafCriticalException("vpeBl MAX_SE_AT_ONCE A(64)𒴂Ă܂BvpeBt@CmFĂBPROPERTY::MAX_SE_AT_ONCE="<<PROPERTY::MAX_SE_AT_ONCE);
    }
#endif
    _p = 0;
    for (int i = 0; i < PROPERTY::MAX_SE_AT_ONCE; i++) {
        _apSe[i] = nullptr;
        _apActor[i] = nullptr;
    }
}

void GgafDxUniverse::SeArray::add(GgafDxSe* prm_pSe, int prm_volume, float prm_pan, float prm_rate_frequency, GgafDxGeometricActor* prm_pActor) {
    if (_p < PROPERTY::MAX_SE_AT_ONCE) {
        _apSe[_p] = prm_pSe;
        _rate_frequency[_p] = prm_rate_frequency;
        _volume[_p] = prm_volume;
        _pan[_p] = prm_pan;
        _apActor[_p] = prm_pActor;
        _p++;
    }
#ifdef MY_DEBUG
    else {
        _TRACE_("GgafDxUniverse::SeArray::add() SEԂĖ܂B"<<
                "="<<prm_pActor->getName()<<"("<<prm_pActor<<") SE="<<prm_pSe->_wave_key<<"("<<prm_pSe->_wave_file_name<<")");
    }
#endif
}

void GgafDxUniverse::SeArray::play(int index) {
    _apSe[index]->play(_volume[index], _pan[index], _rate_frequency[index]);
    _apSe[index]->_pActor_LastPlayed = _apActor[index];
    _apActor[index] = nullptr;
    _apSe[index] = nullptr;
}

GgafDxUniverse::GgafDxUniverse(const char* prm_name, GgafDxCamera* prm_pCamera) : GgafUniverse(prm_name) {
    _obj_class |= Obj_GgafDxUniverse;
    _class_name = "GgafDxUniverse";
//TODO:tHO
//    _colFog.r = 0.0;
//    _colFog.g = 0.0;
//    _colFog.b = 0.0;
//    _colFog.a = 1.0;

    for (int i = 0; i < MAX_DRAW_DEPTH_LEVEL+1; i++) {
        _apAlphaActorFirstList_DrawDepthLevel[i] = nullptr;
        _apAlphaActorLastList_DrawDepthLevel[i] = nullptr;
    }
    //ɃJNEWĂȂƂȂB
    _pCamera = prm_pCamera;
    GgafDxUtil::_pCam = prm_pCamera;

    getSceneDirector()->addSubGroup(_pCamera);
    _pActor_DrawActive = nullptr;

    //J̎ʂ͈́B
    coord F = DX_C(_pCamera->_zf);
    _x_gone_right  = +F;
    _x_gone_left   = -F;
    _y_gone_top    = +F;
    _y_gone_bottom = -F;
    _z_gone_far    = +F;
    _z_gone_near   = -F;
    _TRACE_("Gone=X ("<<_x_gone_left<<" ~ "<<_x_gone_right<<") Y("<<_y_gone_bottom<<" ~ "<<_y_gone_top<<") Z("<<_z_gone_near<<" ~ "<<_z_gone_far<<")");

    _pRing_pSeArray = NEW GgafLinkedListRing<SeArray>();
    for (int i = 0; i < PROPERTY::MAX_SE_DELAY; i++) { //GGAF_END_DELAY͍őxt[ASE̒x̍ōt[ƂĂg
        _pRing_pSeArray->addLast(NEW SeArray(), true);
    }
    _pRing_pSeArray->indexedValue();

    GgafRepeatSeq::create(_seqkey_se_delay, 0, 8); //YSEĐt[
}

void GgafDxUniverse::registerSe(GgafDxSe* prm_pSe,
                                int prm_volume,
                                float prm_pan,
                                float prm_rate_frequency,
                                int prm_delay,
                                GgafDxGeometricActor* prm_pActor) {
//    int bpm = GgafDxBgmPerformer::_active_bgm_bpm;
    //Yt[vZ
    //1Ԃ60*60=3600t[
    //4^C~O 3600/_bpm
    //8^C~O 3600/(_bpm*2) = 1800/_bpm
    //16^C~O 3600/(_bpm*4) = 900/_bpm
    //0t[BGMƂāÃ݂t[fƂƁAߖ16^C~O
    //F = f%(900/_bpm)
    //F = 0̏ꍇA f
    //F != 0 ̏ꍇ {f/(900/_bpm)̏ * (900/_bpm)} + (900/_bpm) ߖ16^C~O
    //TODO:߂Ă̂ɃCx[_[GNXg[ɐĂ܂(ƎvĂ)II{Vvf~BII

    //SE̖^C~O 0`8t[炵ăo
    int delay = prm_delay+1+(GgafRepeatSeq::nextVal(_seqkey_se_delay));
    if (delay > PROPERTY::MAX_SE_DELAY-1) {
        delay = PROPERTY::MAX_SE_DELAY-1;
    }
    _pRing_pSeArray->getNext(delay)->add(prm_pSe, prm_volume, prm_pan, prm_rate_frequency, prm_pActor);
}

void GgafDxUniverse::processSettlementBehavior() {
    GgafUniverse::processSettlementBehavior();
    //SE炷
    SeArray* pSeArray = _pRing_pSeArray->next(); //i߂SEz擾
    if (pSeArray->_p > 0) {
        int se_p = pSeArray->_p;
        for (int p = 0; p < se_p; p++) {
            pSeArray->play(p);
        }
        pSeArray->_p = 0; //Zbg
    }
    GgafRepeatSeq::setMin(_seqkey_se_delay); //nextVal0Ԃ
}

void GgafDxUniverse::draw() {
    GgafDxModelConnection* pModelCon = GgafDxGod::_pModelManager->getFirstConnection();
    while (pModelCon) {
        pModelCon->peek()->_pTexBlinker->behave();
        pModelCon = (GgafDxModelConnection*)(pModelCon->getNext());
    }

    //EffectManagerŉ񂵂Vewϊݒ肷悤ɂ
    GgafDxGod::_pEffectManager->setParamPerFrameAll();

    //iK_O`
    IDirect3DDevice9* pDevice = GgafDxGod::_pID3DDevice9;
    GgafDxScene* pScene;
    GgafDxDrawableActor* pDrawActor;
    for (int i = MAX_DRAW_DEPTH_LEVEL; i >= 0; i--) {
        pDrawActor = _pActor_DrawActive = _apAlphaActorFirstList_DrawDepthLevel[i];
        while (pDrawActor) {
#ifdef MY_DEBUG
            if (pDrawActor->getPlatformScene()->instanceOf(Obj_GgafDxScene)) {
                //OK
            } else {
                throwGgafCriticalException("GgafDxUniverse::draw() err2. _pActor_DrawActive["<<(pDrawActor->getName())<<"->getPlatformScene()["<<(_pActor_DrawActive->getPlatformScene()->getName())<<"]AGgafDxScene ɕϊsłBthis="<<getName());
            }
#endif
            //eV[̃J[eݒ肷B
            pScene = (GgafDxScene*)pDrawActor->getPlatformScene();
            pDrawActor->_pEffect->_pID3DXEffect->SetFloat(
                    pDrawActor->_pEffect->_h_alpha_master, pScene->_master_alpha);

            //vf̏ꍇJOꎞOFF
            if (pDrawActor->_alpha < 1.0f) {
                pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
            }
            //Zobt@lݒ
            if (!pDrawActor->_zenable) {
                pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
            }
            // Zobt@ݕsݒ
            if (!pDrawActor->_zwriteenable) {
                pDevice->SetRenderState(D3DRS_ZWRITEENABLE, FALSE );
            }

            pDrawActor->processDraw(); //`III

            //JOLɖ߂
            if (pDrawActor->_alpha < 1.0f) {
                pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);
            }
            //Zobt@lݒ
            if (!pDrawActor->_zenable) {
                pDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
            }
            // Zobt@ݕsݒ
            if (!pDrawActor->_zwriteenable) {
                pDevice->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
            }

            pDrawActor = _pActor_DrawActive = _pActor_DrawActive->_pNext_TheSameDrawDepthLevel;
        }
        _apAlphaActorFirstList_DrawDepthLevel[i] = nullptr; //̂߂ɃZbg
        _apAlphaActorLastList_DrawDepthLevel[i] = nullptr;
    }

    //ŌEndPass
    HRESULT hr;
    if (GgafDxEffectManager::_pEffect_Active) {

        TRACE4("EndPass("<<GgafDxEffectManager::_pEffect_Active->_pID3DXEffect<<"): /_pEffect_Active="<<GgafDxEffectManager::_pEffect_Active->_effect_name<<"("<<GgafDxEffectManager::_pEffect_Active<<")");
        hr = GgafDxEffectManager::_pEffect_Active->_pID3DXEffect->EndPass();
        checkDxException(hr, D3D_OK, "GgafDxUniverse::processDraw() EndPass() Ɏs܂B");
        hr = GgafDxEffectManager::_pEffect_Active->_pID3DXEffect->End();
        checkDxException(hr, D3D_OK, "GgafDxUniverse::processDraw() End() Ɏs܂B");
#ifdef MY_DEBUG
        if (GgafDxEffectManager::_pEffect_Active->_begin == false) {
            throwGgafCriticalException("begin Ă܂ "<<(GgafDxEffectManager::_pEffect_Active==nullptr?"nullptr":GgafDxEffectManager::_pEffect_Active->_effect_name)<<"");
        } else {
            GgafDxEffectManager::_pEffect_Active->_begin = false;
        }
#endif
        GgafDxEffectManager::_pEffect_Active = nullptr;
        GgafDxModelManager::_pModelLastDraw = nullptr;
        GgafDxDrawableActor::_hash_technique_last_draw = 0;
    }

}

int GgafDxUniverse::setDrawDepthLevel(int prm_draw_depth_level, GgafDxDrawableActor* prm_pActor) {
    int draw_depth_level;
    //Jbg
    if (prm_draw_depth_level > MAX_DRAW_DEPTH_LEVEL - 4) {
        draw_depth_level = MAX_DRAW_DEPTH_LEVEL - 4;
    } else if (prm_draw_depth_level < 1) {
        draw_depth_level = 1;
    } else {
        draw_depth_level = prm_draw_depth_level;
    }

    if (_apAlphaActorFirstList_DrawDepthLevel[draw_depth_level] == nullptr) {
        //prm_draw_depth_levelōŏ̃AN^[̏ꍇ
        prm_pActor->_pNext_TheSameDrawDepthLevel = nullptr;
        _apAlphaActorFirstList_DrawDepthLevel[draw_depth_level] = prm_pActor;
        _apAlphaActorLastList_DrawDepthLevel[draw_depth_level] = prm_pActor;
    } else {
        GgafDxDrawableActor* pActorTmp;
        if (prm_pActor->_is_2D) {
            //[x2D̏ꍇAAXĝKɒǉĂ
            //܂AŌ addSubLast() ΂قǁA`揇ɂȂAvCIeBB
            pActorTmp = _apAlphaActorLastList_DrawDepthLevel[draw_depth_level];
            pActorTmp->_pNext_TheSameDrawDepthLevel = prm_pActor;
            prm_pActor->_pNext_TheSameDrawDepthLevel = nullptr;
            _apAlphaActorLastList_DrawDepthLevel[draw_depth_level] = prm_pActor;
        } else {
            //[x3D̏ꍇAOɒǉƁAKɒǉ݂ɍsB
            //̂ȂƂ邩ƂƁAZobt@L̃eNX`ɓIuWFNgAIuWFNgꍇA
            //[xȂ̂ŁAvCIeBi`揇jɂēȂĂ܂B
            //`揇𖈃t[ω邱ƂŁAݕ\ł኱̂܂sB
            //TODO:(ۑ)QAR̃IuWFNǧ͏ꍇ͌ڂɂeł邪Ał܂Ɩ{Ƀ``B
            if ((GgafGod::_pGod->_pUniverse->_frame_of_behaving & 1) == 1) { //
                //Oɒǉ
                pActorTmp = _apAlphaActorFirstList_DrawDepthLevel[draw_depth_level];
                prm_pActor->_pNext_TheSameDrawDepthLevel = pActorTmp;
                _apAlphaActorFirstList_DrawDepthLevel[draw_depth_level] = prm_pActor;
            } else {
                //Kɒǉ
                pActorTmp = _apAlphaActorLastList_DrawDepthLevel[draw_depth_level];
                pActorTmp->_pNext_TheSameDrawDepthLevel = prm_pActor;
                prm_pActor->_pNext_TheSameDrawDepthLevel = nullptr;
                _apAlphaActorLastList_DrawDepthLevel[draw_depth_level] = prm_pActor;
            }
        }
    }
    return draw_depth_level;
}


GgafDxUniverse::~GgafDxUniverse() {
    GGAF_DELETE(_pRing_pSeArray);
}
