#ifndef GGAFLIB_STRAIGHTLASERCHIP_H_
#define GGAFLIB_STRAIGHTLASERCHIP_H_
#include "jp/ggaf/lib/actor/laserchip/LaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"

namespace GgafLib {

/**
 * Xg[g[U[p|C̃`bv .
 * Xg[g[U[Ȃǂƕ\Ă邪Amɂ<BR>
 * EˍWCӁAˌWړƁAɂƂȂĕsړiƂ\j<BR>
 * E˕CӁAˌ̊pxωƁAɂƂȂĔˌ𒆐Sɉ]ړiƂ\j<BR>
 * Eړ@͊{Œi<BR>
 * EAS`bvˌIuWFNgWƌ̍ZBƂB<BR>
 * ƌׂAOfBEXC_[\ȃ[U[ƌׂAȊB<BR>
 * o[ _veloMv ňړ܂Bdispatch() AWƕy _veloMv ݒ肵ĉB<BR>
 * ˌƘAēꍇ setSource() ݒ肵ĉB̏ꍇAWƕ͎ݒ肳܂B
 * @version 1.00
 * @since 2009/08/25
 * @author Masatoshi Tsuge
 */
class StraightLaserChip : public LaserChip {
    friend class LaserChipDepository;

public:
    /** [U[̈ʒu𓯊邽߂́AXWϐꏊ */
    int* _pSource_x;
    /** [U[̈ʒu𓯊邽߂́AYWϐꏊ */
    int* _pSource_y;
    /** [U[̈ʒu𓯊邽߂́AZWϐꏊ */
    int* _pSource_z;
    /** [U[̌̂𓯊邽߂́AX]AOlϐꏊ */
    angle* _pSource_rx;
    /** [U[̌̂𓯊邽߂́AY]AOlϐꏊ */
    angle* _pSource_ry;
    /** [U[̌̂𓯊邽߂́AZ]AOlϐꏊ */
    angle* _pSource_rz;
    /** [U[̈ړ𓯊邽߂́APʕxNgXϐꏊ */
    float* _pSource_vX;
    /** [U[̈ړ𓯊邽߂́APʕxNgYϐꏊ */
    float* _pSource_vY;
    /** [U[̈ړ𓯊邽߂́APʕxNgZϐꏊ */
    float* _pSource_vZ;
    /** [r/w]ړx */
    velo _veloMv;

    GgafDxGeometricActor* _pSourceActor;

public:
    StraightLaserChip(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat=nullptr);

    virtual void onCreateModel() override {}

    virtual void initialize() override {}

    /**
     * [U[`bvWvZ .
     * Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
     * ̍ ́A{NX processBehavior() \bhĂяoĂB
     */
    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void processSettlementBehavior() override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    /**
     * ˌ̈ړƉ]ɂāAƂ锭˃AN^[ݒ .
     * @param prm_pGeoActor ˌAN^[
     */
    void setSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_x = &prm_pGeoActor->_x;
        _pSource_y = &prm_pGeoActor->_y;
        _pSource_z = &prm_pGeoActor->_z;
        _pSource_rx = &prm_pGeoActor->_rx;
        _pSource_ry = &prm_pGeoActor->_ry;
        _pSource_rz = &prm_pGeoActor->_rz;
        _pSource_vX = &prm_pGeoActor->_pKuroko->_vX;
        _pSource_vY = &prm_pGeoActor->_pKuroko->_vY;
        _pSource_vZ = &prm_pGeoActor->_pKuroko->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̈ړ݂̂ɂāAƂ锭˃AN^[ݒ .
     * ǂĂĂɔˁB
     * @param prm_pGeoActor ˌAN^[
     */
    void setPositionSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_x = &prm_pGeoActor->_x;
        _pSource_y = &prm_pGeoActor->_y;
        _pSource_z = &prm_pGeoActor->_z;
        _pSource_rx = &_rx;
        _pSource_ry = &_ry;
        _pSource_rz = &_rz;
        _pSource_vX = &_pKuroko->_vX;
        _pSource_vY = &_pKuroko->_vY;
        _pSource_vZ = &_pKuroko->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̉]݂̂ɂāAƂ锭˃AN^[ݒ .
     * {˂ȂǂɎgp邩ȁEEEB
     * @param prm_pGeoActor ˌAN^[
     */
    void setAngleSource(GgafDxCore::GgafDxGeometricActor* prm_pGeoActor) {
        _pSource_x = &_x;
        _pSource_y = &_y;
        _pSource_z = &_z;
        _pSource_rx = &prm_pGeoActor->_rx;
        _pSource_ry = &prm_pGeoActor->_ry;
        _pSource_rz = &prm_pGeoActor->_rz;
        _pSource_vX = &prm_pGeoActor->_pKuroko->_vX;
        _pSource_vY = &prm_pGeoActor->_pKuroko->_vY;
        _pSource_vZ = &prm_pGeoActor->_pKuroko->_vZ;
        _pSourceActor = prm_pGeoActor;
    }

    virtual ~StraightLaserChip();
};

}
#endif /*GGAFLIB_STRAIGHTLASERCHIP_H_*/

