#ifndef GGAFLIB_VIRTUALBUTTON_H_
#define GGAFLIB_VIRTUALBUTTON_H_
#include "jp/ggaf/core/GgafObject.h"

#include <string>
#include <map>
#include "jp/ggaf/dxcore/util/GgafDxInput.h"

typedef unsigned long int vbsta;

namespace GgafLib {

#define VB_BUTTON1 (0x1)               //&B 00000000 00000000 00000000 00000001
#define VB_BUTTON2 (0x2)               //&B 00000000 00000000 00000000 00000010
#define VB_BUTTON3 (0x4)               //&B 00000000 00000000 00000000 00000100
#define VB_BUTTON4 (0x8)               //&B 00000000 00000000 00000000 00001000
#define VB_BUTTON5 (0x10)              //&B 00000000 00000000 00000000 00010000
#define VB_BUTTON6 (0x20)              //&B 00000000 00000000 00000000 00100000
#define VB_BUTTON7 (0x40)              //&B 00000000 00000000 00000000 01000000
#define VB_BUTTON8 (0x80)              //&B 00000000 00000000 00000000 10000000
                                       //&B 00000000 00000000 00000001 00000000
                                       //&B 00000000 00000000 00000010 00000000
#define VB_PAUSE          (0x400)      //&B 00000000 00000000 00000100 00000000
#define VB_UP             (0x800)      //&B 00000000 00000000 00001000 00000000
#define VB_DOWN           (0x1000)     //&B 00000000 00000000 00010000 00000000
#define VB_LEFT           (0x2000)     //&B 00000000 00000000 00100000 00000000
#define VB_RIGHT          (0x4000)     //&B 00000000 00000000 01000000 00000000
#define VB_UI_UP          (0x8000)     //&B 00000000 00000000 10000000 00000000
#define VB_UI_DOWN        (0x10000)    //&B 00000000 00000001 00000000 00000000
#define VB_UI_LEFT        (0x20000)    //&B 00000000 00000010 00000000 00000000
#define VB_UI_RIGHT       (0x40000)    //&B 00000000 00000100 00000000 00000000
#define VB_UI_EXECUTE     (0x80000)    //&B 00000000 00001000 00000000 00000000
#define VB_UI_CANCEL      (0x100000)   //&B 00000000 00010000 00000000 00000000
#define VB_UI_DEBUG       (0x200000)   //&B 00000000 00100000 00000000 00000000
#define VB_NEUTRAL_STC    (0x400000)   //&B 00000000 01000000 00000000 00000000
#define VB_UP_RIGHT_STC   (0x800000)   //&B 00000000 10000000 00000000 00000000
#define VB_DOWN_RIGHT_STC (0x1000000)  //&B 00000001 00000000 00000000 00000000
#define VB_DOWN_LEFT_STC  (0x2000000)  //&B 00000010 00000000 00000000 00000000
#define VB_UP_LEFT_STC    (0x4000000)  //&B 00000100 00000000 00000000 00000000
#define VB_UP_STC         (0x8000000)  //&B 00001000 00000000 00000000 00000000
#define VB_RIGHT_STC      (0x10000000) //&B 00010000 00000000 00000000 00000000
#define VB_DOWN_STC       (0x20000000) //&B 00100000 00000000 00000000 00000000
#define VB_LEFT_STC       (0x40000000) //&B 01000000 00000000 00000000 00000000

#define VB_UDLR           (VB_UP|VB_DOWN|VB_LEFT|VB_RIGHT)
#define VB_UI_UDLR        (VB_UI_UP|VB_UI_DOWN|VB_UI_LEFT|VB_UI_RIGHT)

#define VB_STC_CLIP_MASK  (0x803FFFFF) //&B 10000000 00111111 11111111 11111111
#define VB_STC_MASK       (0x7FC00000) //&B 01111111 11000000 00000000 00000000

#define VB_MAP_BUFFER 120
#define VB_NUM 29

/**
 * z{^ .
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class VirtualButton : public GgafCore::GgafObject {

public:
    /**
     * z{^Xg .
     */
    class VBRecord {
    public :
        VBRecord* _next; //nŎ̃t[̓͏
        VBRecord* _prev; //nőÕt[̓͏
        vbsta _state;
    public:
        VBRecord() {
            _next = nullptr;
            _prev = nullptr;
            _state = (vbsta)0;
        }
        ~VBRecord() {
        }
    };


    struct KEYBOARDMAP {
        int BUTTON1;
        int BUTTON2;
        int BUTTON3;
        int BUTTON4;
        int BUTTON5;
        int BUTTON6;
        int BUTTON7;
        int BUTTON8;
        int PAUSE;
        int UP;
        int DOWN;
        int LEFT;
        int RIGHT;
        int UI_UP;
        int UI_DOWN;
        int UI_LEFT;
        int UI_RIGHT;
        int UI_EXECUTE;
        int UI_CANCEL;
        int UI_DEBUG;
    };

    struct JOYSTICKMAP {
        int BUTTON1;
        int BUTTON2;
        int BUTTON3;
        int BUTTON4;
        int BUTTON5;
        int BUTTON6;
        int BUTTON7;
        int BUTTON8;
        int PAUSE;
        int UI_EXECUTE;
        int UI_CANCEL;
    };

public:
    /** L[{[h蓖Ēl */
    static KEYBOARDMAP _keyboardmap;
    /** WCXeBbN蓖Ēl */
    static JOYSTICKMAP _joystickmap;

    static std::map<std::string, int> _mapStr2Dik;
    static std::map<std::string, int> _mapStr2JoyBtn;
    static std::map<int, std::string> _mapDik2Str;
    static std::map<int, std::string> _mapJoyBtn2Str;

    static bool _is_init;


    /** I[gs[gpJE^[ */
    std::map<vbsta, frame> _auto_repeat_counter;
    /** I[gs[gȂ true */
    bool _is_auto_repeat;

    VBReplayRecorder* _pRpy;

    /** [r]vC[h:true^[U[́ivC[hLj[h:false */
    bool _is_replaying;
    /** [r]:false^vC[hI:true */
    bool _was_replay_done;
    /** ݃t[̓͏ */
    VirtualButton::VBRecord* _pVBRecord_Active;

public:
    /**
     * RXgN^ .
     * ̃vCt@C݂ꍇvC[[hB
     * ̃vCt@C݂Ȃꍇ[U[͎t  vCt@CL[hB
     * @param prm_replay_file vCt@C
     */
    VirtualButton(const char* prm_replay_file = "VirtualButton.rep");

    /**
     * ߋ̓͏Ԃ擾 .
     * @param prm_frame_ago ݂艽t[ߋw
     * @return ߋ̓͏
     */
    VirtualButton::VBRecord* getPastVBRecord(frame prm_frame_ago);

    /**
     * ݃{^Ă邩 .
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @return true / false
     */
    inline vbsta isBeingPressed(vbsta prm_VB) {
        return (_pVBRecord_Active->_state & prm_VB);
    }

    /**
     * ݃{^ĂȂ .
     * isBeingPressed(vbsta) ̔ے̌ʂԂB
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @return true / false
     */
    vbsta isNotBeingPressed(vbsta prm_VB);

    /**
     * ߋɃ{^Ăǂ .
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_ago t[O(>0)𔻒肷̂wB
     * 1  1t[OA2  2t[OA0  isBeingPressed(vbsta) ƓӖɂȂB
     * ő (VB_MAP_BUFFER-1) t[O܂ŉ
     * @return true / false
     */
    vbsta wasBeingPressed(vbsta prm_VB, frame prm_frame_ago);

    /**
     * ߋɃ{^ĂȂ̂ǂ .
     * wasBeingPressed(vbsta, frame) ̔ے̌ʂԂB
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_ago t[O(>0)𔻒肷̂wB
     *                      1  1t[OA2  2t[OA0  isBeingPressed(vbsta) ƓӖɂȂB
     *                      ő (VB_MAP_BUFFER-1) t[O܂ŉ
     * @return true / false
     */
    vbsta wasNotBeingPressed(vbsta prm_VB, frame prm_frame_ago);

    /**
     * ݃{^ꂽuԂȂ̂ǂ .
     * ݂͉ĂAAPt[O͉ĂȂꍇ true
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @return true / false
     */
    inline vbsta isPushedDown(vbsta prm_VB) {
        return (!(_pVBRecord_Active->_prev->_state & prm_VB) && (_pVBRecord_Active->_state & prm_VB)) ? true : false;
    }

    /**
     * ߋɃ{^ꂽuԂ̂ǂ .
     * prm_frame_agot[O͉ĂAA(prm_frame_ago+1)t[O͉ĂȂꍇ true
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_ago t[O(>0)𔻒肷̂wB
     *                      1  1t[OA2  2t[OA0  isPushedDown(vbsta) ƓӖɂȂB
     *                      ő (VB_MAP_BUFFER-1) t[O܂ŉ
     * @return true / false
     */
    vbsta wasPushedDown(vbsta prm_VB, frame prm_frame_ago);

    /**
     * ݃{^𗣂uԂȂ̂ǂ .
     * ݂͉ĂȂAAPt[O͉Ăꍇ true
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @return true / false
     */
    vbsta isReleasedUp(vbsta prm_VB);

    /**
     * ߋɃ{^𗣂uԂ̂ǂ .
     * prm_frame_agot[O͉ĂȂAA(prm_frame_ago+1)t[O͉Ăꍇ true
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_ago t[O(>0)𔻒肷̂wB
     *                      1  1t[OA2  2t[OA0  isReleasedUp(vbsta) ƓӖɂȂB
     * @return true / false
     */
    vbsta wasReleasedUp(vbsta prm_VB, frame prm_frame_ago);

    /**
     * ` .
     * u{^ĂȂ{^{^𗣂vƂԑJڂA
     * ݐǂ肷B
     * AĂԂ prm_frame_push ȏ㉟ĂƐȂi`ƔF߂ȂjB
     * ƂΓƕG{^Ȃ prm_frame_push=2 wBɺ;
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_push e{^Ăԃt[(default=5)
     * @return true / false
     */
    vbsta isPushedUp(vbsta prm_VB, frame prm_frame_push = 5);

    /**
     * _uvbV .
     * u(a){^ĂȂ(b){^(c){^𗣂(d){^vƂԑJڂA
     * ݐǂ肷B
     * A   (b)`(c)̉ĂԂ prm_frame_push ȏ㉟ĂƐȂB
     *  (c)`(d)̂Qڂ̃{^܂ł̊Ԃ prm_frame_delay ȏJĂƐȂB
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_frame_push e(b)`(c) ̊
     * @param prm_frame_delay e(c)`(d) ̊
     * @return true / false
     */
    vbsta isDoublePushedDown(vbsta prm_VB, frame prm_frame_push = 5, frame prm_frame_delay = 5);

    /**
     * {^ .
     * isPushedDown(vbsta) ̈ɕ{^w肵Ĕs΁A͉\łB
     * A̔@͕{^ۂ1t[łocLΐA
     * SɓɉȂ΂ȂȂ߁AVrAƂ_B
     * ŁA{\bh́ÃocLelłB
     * ̓Iɂ́Âꂼ̊e{^݂̌Ɏ܂ł̂St[̏ԗA
     * ̂ꂩ̏ԑJڂł1񐬗ƂsĂB(܂3t[P\)
     * <pre>
     *  > H > H > 
     *       or
     * H >  > H > 
     *       or
     * H > H >  > 
     *
     * FĂ ^ FĂ ^ HFC
     * ԉȄ݂ԁAߋ
     * </pre>
     * @param prm_aVB (3tP\)Ώۉz{^z
     * @param prm_num_button z̗vf
     * @return true / false
     */
    vbsta arePushedDownAtOnce(vbsta prm_aVB[], int prm_num_button);

    /**
     * RtP\̂Q{^ .
     * @param prm_VB1 Ώۉz{^P
     * @param prm_VB2 Ώۉz{^Q
     * @return true / false
     */
    vbsta arePushedDownAtOnce(vbsta prm_VB1, vbsta prm_VB2) {
        vbsta vb[2];
        vb[0] = prm_VB1;
        vb[1] = prm_VB2;
        return arePushedDownAtOnce(vb, 2);
    }

    /**
     * RtP\̂R{^ .
     * @param prm_VB1 Ώۉz{^P
     * @param prm_VB2 Ώۉz{^Q
     * @param prm_VB3 Ώۉz{^R
     * @return true / false
     */
    vbsta arePushedDownAtOnce(vbsta prm_VB1, vbsta prm_VB2, vbsta prm_VB3) {
        vbsta vb[3];
        vb[0] = prm_VB1;
        vb[1] = prm_VB2;
        vb[2] = prm_VB3;
        return arePushedDownAtOnce(vb, 3);
    }

    /**
     * RtP\̂S{^ .
     * @param prm_VB1 Ώۉz{^P
     * @param prm_VB2 Ώۉz{^Q
     * @param prm_VB3 Ώۉz{^R
     * @param prm_VB4 Ώۉz{^S
     * @return true / false
     */
    vbsta arePushedDownAtOnce(vbsta prm_VB1, vbsta prm_VB2, vbsta prm_VB3, vbsta prm_VB4) {
        vbsta vb[4];
        vb[0] = prm_VB1;
        vb[1] = prm_VB2;
        vb[2] = prm_VB3;
        vb[3] = prm_VB4;
        return arePushedDownAtOnce(vb, 4);
    }

    /**
     * I[gs[g͔ .
     * @param prm_VB Ώۉz{^BVB_ Ŏn܂萔(̘_a)
     * @param prm_begin_repeat I[gs[gJnt[
     * @param prm_while_repeat I[gs[gJnAs[gԊut[
     * @return true / false
     */
    vbsta isAutoRepeat(vbsta prm_VB, frame prm_begin_repeat = 20, frame prm_while_repeat = 5);

    /**
     * Obƃ|ۂ .
     * UMGt̃XN[pChCo[R}h͔łB
     * ̓Iɂ́Aprm_frame_delay ȓ
     *     ̂S{^AisPushedDown(prm_VB) B
     * ̏ꍇ true ƂĂ܂B
     * @param prm_VB uObƃ|v́u|ṽ{^
     * @param prm_frame_delay uObƃ|vŜ̋et[
     * @return true / false
     */
    bool isScrewPushDown(vbsta prm_VB, frame prm_frame_delay=30);

    /**
     * ݉ςȂ̃XeBbN̔ԍԂB
     * @return ̉ꂩ
     * VB_UP_STC
     * VB_UP_RIGHT_STC
     * VB_RIGHT_STC
     * VB_DOWN_RIGHT_STC
     * VB_DOWN_STC
     * VB_DOWN_LEFT_STC
     * VB_LEFT_STC
     * VB_UP_LEFT_STC
     * VB_NEUTRAL_STC
     */
    vbsta getBeingPressedStick();

    /**
     * PushedDownXeBbN̔ԍԂB
     * @return ̉ꂩ
     * VB_UP_STC
     * VB_UP_RIGHT_STC
     * VB_RIGHT_STC
     * VB_DOWN_RIGHT_STC
     * VB_DOWN_STC
     * VB_DOWN_LEFT_STC
     * VB_LEFT_STC
     * VB_UP_LEFT_STC
     * VB_NEUTRAL_STC
     */
    vbsta getPushedDownStick();

    vbsta isDoublePushedDownStick(frame prm_frame_push = 5, frame prm_frame_delay = 5);

    vbsta getState();

    /**
     * ͏XV .
     * ʏ펞̓L[́AWCXeBbNA}EX̃foCXɓ͂ɂAXe[gXVB
     * AAvCĐ́Aǂݍ܂ꂽOt@C̃f[^ŁAXe[gXVB
     */
    void update();

    void init();

    void clear();

    virtual ~VirtualButton();
};

}
#endif /*GGAFLIB_VIRTUALBUTTON_H_*/
