#ifndef GGAFLIB_SPLINEKUROKOLEADER_H_
#define GGAFLIB_SPLINEKUROKOLEADER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafLib {

/**
 * XvCȐړs邽߂̃IuWFNg .
 * ߂ɎwoĈړ擱܂B
 * @version 1.00
 * @since 2009/10/27
 * @author Masatoshi Tsuge
 */
class SplineKurokoLeader : public GgafCore::GgafObject {

public:
    enum SplinTraceOption {
        ABSOLUTE_COORD,     //΍Wړ
        RELATIVE_COORD,     //XvCW(0,0,0)AAN^[̌WƂ΍WŌvZ
        RELATIVE_DIRECTION, //XvCW(0,0,0)AAN^[̌WƂ΍WƂAAN^[̌݌i_pKuroko  _angRzMv, _angRyMv)ŃXvCWQ[hϊB
    };

    /** XvCZbg */
    SplineManufacture* _pManufacture;
    /** start()̌o߃t[ */
    frame _leading_frames;
    /** 擱Jnǂ */
    bool _was_started;
    /** ݐ擱ł邩ǂ */
    bool _is_leading;
    /** W𑀍삷ΏۂƂȂAN^[ */
    GgafDxCore::GgafDxGeometricActor* _pActor_target;
    /** RXgN^SplineLine𐶐ꍇtrue/RXgN^SplineLinenꂽꍇfalseBꎞ̂B*/
    bool _is_created_pManufacture;
    /**
     * [r]IvV
     * ABSOLUTE_COORD     : ΍WړB
     * RELATIVE_COORD     : n_WƂAXvCWQ͑ΈړŌvZB
     * RELATIVE_DIRECTION : n_WƂAɌ݂̌i_pKuroko  _angRzMv, _angRyMv)ŃXvCWQ[hϊB
     */
    SplinTraceOption _option;
    /** [r] [vJE^ */
    int _cnt_loop;
    /** [r] ݒ胋[vB-1 Ŗ */
    int _max_loop;

    /** [r]n_XW */
    coord _x_start;
    /** [r]n_YW */
    coord _y_start;
    /** [r]n_ZW */
    coord _z_start;

    coord _offset_x;
    coord _offset_y;
    coord _offset_z;

    int _flip_x;
    int _flip_y;
    int _flip_z;
    /** [r]AN^[݈̌ʒuXvCn_܂ł̋Bstart()_ōXVB */
    int _distance_to_begin;
    /** [r]݌ĂŒ̕⊮_(_܂)̐ */
    int _point_index;
    /** [r]n_WŒ肷BiŒ肵Ȃꍇ͍qÃAN^[̍WɂȂj */
    bool _is_fix_start_pos;

public:
    /**
     * RXgN^ .
     * @param prm_pManufacture
     * @param prm_pKuroko
     */
    SplineKurokoLeader(SplineManufacture* prm_pManufacture,  GgafDxCore::GgafDxKuroko* const prm_pKuroko);

    /**
     * e⊮_ǂݍݎAXAYAZꂼɉZ(sړ)A␳܂ .
     * ftHg adjustCoordOffset(0, 0, 0) ƂȂ܂B<BR>
     * <b>[]</b><BR>
     * ŁAadjustAxisXFlip() adjustAxisYFlip() adjustAxisZFlip() lA
     *  Manufacture XYZ̕␳悶ꂽAԍŌ
     * adjustCoordOffset()  lꍷZ܂B<BR>
     * @param prm_offset_x X␳
     * @param prm_offset_y Y␳
     * @param prm_offset_z Z␳
     */
    virtual void adjustCoordOffset(coord prm_offset_x, coord prm_offset_y, coord prm_offset_z);

    /**
     * XvC̊eW_AX]܂B
     */
    virtual void adjustAxisXFlip() {
        _flip_x = -_flip_x;
    }

    /**
     * XvC̊eW_AY]܂B
     */
    virtual void adjustAxisYFlip() {
        _flip_y = -_flip_y;
    }

    /**
     * XvC̊eW_AZ]܂B
     */
    virtual void adjustAxisZFlip() {
        _flip_z = -_flip_z;
    }

    /**
     * ΏۃAN^[(_pActor_target)̍WAXvC̈ԍŏ̐_WŐݒ肷 .
     * start(SplineKurokoLeader::ABSOLUTE_COORD) ̏ꍇA܂u΍WړXvCv̏ꍇA
     * LȐݒƂȂ肤ł傤B<BR>
     */
    void setAbsoluteBeginCoord();

    /**
     * ォXvCIuWFNgݒB
     * @param prm_pManufacture
     */
    virtual void setManufacture(SplineManufacture* prm_pManufacture);

    /**
     * XvCȐ̕⊮_ړ擱Jn .
     */
    virtual void start(SplinTraceOption prm_option, int prm_max_loop = 1);

    /**
     * XvCȐ̕⊮_ړ擱߂iFAN^[~킯ł͂Ȃj .
     */
    virtual void stop();

    /**
     * ړs\bh .
     * ړs߂ɁAt[̃\bhĂяoKv܂B<BR>
     * start() st[ɎsƂƂ͕svB<BR>
     * start() sŏbehave()́Aw݂̍W|Cg[0]xւ̏ƂȂ܂B<BR>
     */
    virtual void behave();

    /**
     * ߂擱ۂ .
     * @return true:擱 / false:擱IĂ
     */
    inline bool isLeading() {
        return _is_leading;
    }

    /**
     * ߂擱IۂB .
     * @return true:擱IĂ / false:܂JnĂȂA擱
     */
    inline bool isFinished() {
        if (_was_started) {
            return _is_leading ? false : true;
        } else {
            return false;
        }
    }

    /**
     * XvC̕⊮_ƕ⊮_̊Ԃ̋擾B
     * SplineManufacture::adjustAxisRate(double,double,double);<BR>
     * ɂ␳ς݂̕⊮_ԋ擾B<BR>
     * CfbNX=0 start() sɎ擾o悤ɂȂB<BR>
     * <pre>
     *
     *   X:_
     *   o:_Ԃ̕⊮_iXvCȐʉߓ_j
     *
     *        getSegmentDistance(0)
     *            ||
     *            ||    getSegmentDistance(1)   getSegmentDistance(5)   getSegmentDistance(8)
     *            ||         ||                     ||                         ||
     *        <-----------> <--->                <------->                  <------->
     *    @EEEEEE X----o----o----o-----X--------o---------o--------o-------X
     *                    n_
     *                    [0]  [1]  [2]  [3]   [4]      [5]       [6]      [7]     [8]
     *
     *  </pre>
     * @param prm_index CfbNXi0=AN^[Wn_Ԃ̋B1=n_n_+1̕⊮_ԋEEEj
     * @return ̃ZOg̋
     */
    coord getSegmentDistance(int prm_index);

    /**
     * ݂̍W`n_[0]`I_Ԃ̋擾B
     * @return v
     */
    coord getTotalDistance();

    /**
     * XvC̕⊮_(_܂)̐ԂB
     * <pre>
     *
     *   X:_
     *   o:_Ԃ̕⊮_iXvCȐʉߓ_j
     *
     *        getSegmentDistance(0)
     *            ||
     *            ||    getSegmentDistance(1)   getSegmentDistance(5)   getSegmentDistance(8)
     *            ||         ||                     ||                         ||
     *        <-----------> <--->                <------->                  <------->
     *    @EEEEEE X----o----o----o-----X--------o---------o--------o-------X
     *                    n_
     *                    [0]  [1]  [2]  [3]   [4]      [5]       [6]      [7]     [8]
     *
     * </pre>
     *  }̏ꍇ ⊮_CfbNXO`ŴXȂ̂ŁA߂l9ƂȂB
     * @return ⊮_(_܂)̐
     */
    int getPointNum();

    /**
     * ⊮_̍W擾B
     * @param prm_index ⊮_CfbNX(0`) <BR>
     *                  Jn_CfbNXF0 ` ŏI_CfbNXFgetPointNum()-1
     * @param out_x ߂lXW
     * @param out_y ߂lYW
     * @param out_z ߂lZW
     */
    virtual void getPointCoord(int prm_index, coord &out_x, coord&out_y, coord &out_z);

    /**
     * XvC̊JnW̍WɌŒistart()ɉeȂjB
     * ftHg̊JnWŒ肵Ȃꍇ́A<BR>
     * uXvCJnWstart()̍qÃAN^[̍WvƂȂB<BR>
     * zgp@́A{\bhsŊJnWݒ肵A<BR>
     * ۂ̈ړAN^[̍W͕ʂ̏ꏊɐݒ肵āAXvCړJnA<BR>
     * ƃXvCȐOɏXɍ悤Ȍʂo邱ƂłB<BR>
     * @param prm_x
     * @param prm_y
     * @param prm_z
     */
    void fixStartPosition(coord prm_x, coord prm_y, coord prm_z) {
        _is_fix_start_pos = true;
        _x_start = prm_x;
        _y_start = prm_y;
        _z_start = prm_z;
    }

    /**
     * XvC̊JnWŒB
     */
    void unfixStartPosition() {
        _is_fix_start_pos = false;
    }
    virtual ~SplineKurokoLeader();
};

}
#endif /*GGAFLIB_SPLINEKUROKOLEADER_H_*/
