#include "stdafx.h"
#include "CubeMapMeshTestActor.h"

#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

CubeMapMeshTestActor::CubeMapMeshTestActor(const char* prm_name) :
        CubeMapMeshActor(prm_name, "_chk_CubeMapMeshTestModel", nullptr) {
    _class_name = "CubeMapMeshTestActor";
    setCubeMap("Ratislavia_cubemap.dds", 0.1);
    setHitAble(false);
}

void CubeMapMeshTestActor::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.6, 0.1, 1.0);
    _pModel->_pTexBlinker->setPower(0.1);
    _pModel->_pTexBlinker->beat(120, 60, 1, -1);
    _pModel->setSpecular(5.0, 1.0);
}

void CubeMapMeshTestActor::initialize() {
    setHitAble(false);

    position(0,0,0);
    setScaleR(0.2);
    _pKuroko->setRzRyMvAng(0,0);
}

void CubeMapMeshTestActor::onActive() {
}


void CubeMapMeshTestActor::processBehavior() {
}

CubeMapMeshTestActor::~CubeMapMeshTestActor() {
}

