#include "stdafx.h"
#include "EnemyErmioneArm.h"
#include "EnemyErmione.h"

#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoHelperB.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


EnemyErmioneArm::EnemyErmioneArm(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat) :
        DefaultMeshSetActor(prm_name, prm_model, prm_pStat) {
    _class_name = "EnemyErmioneArm";

    aiming_ang_velo_ = 0;
    aiming_movable_limit_ang_ = 0;

    _pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001"); //rj
    useProgress(PROG_BANPEI);
    behave_frames_ = 0;
}


void EnemyErmioneArm::initialize() {
}

void EnemyErmioneArm::onActive() {
    _pStatus->reset();
    _pProg->reset(PROG_INIT);
}

void EnemyErmioneArm::processBehavior() {
    switch (_pProg->get()) {
        case PROG_INIT: {
            _pProg->change(PROG_WAITING);
            break;
        }
        case PROG_WAITING: {
            if (_pProg->isJustChanged()) {
                //{̂FKƂĒǉꂽ́AxprocessSettlementBehavior()sȂ
                //WfȂAāBPt[PROG_WAITINGŃGgGtFss
                UTIL::activateEntryEffectOf(this);
            }
            break;
        }

        case PROG_NOTHING: {
            if (_pProg->isJustChanged() ) {
                behave_frames_ = RND(30, 60);
            }
            if (_pProg->getFrameInProgress() == behave_frames_) {
                _pProg->change(PROG_AIMING);
            }
            break;
        }

        case PROG_AIMING: {
            if (_pProg->isJustChanged() ) {
                if (aiming_movable_limit_ang_ > 0) {
                    //@֕
                    //lF[JWnŗ\߂ǂ̕ɌĂ΁AŏIIɎ@ɌƂɂȂ邩߂
                    //
                    //@ւ̌߂̕ϊOԂŁA
                    //[JWŁuĂ΂̂ł͂Ȃṽ̕xNg(tvx, tvy, tvz) ƂA
                    //uy܂Łv̍s̐ρi_pActor_Base->_matWorldRotMv)  b_mat_xx ƂB
                    //݂̍ŏIW玩@ւ̌̃xNgA(mvx, mvy, mvz) ƂƁA
                    //
                    //                | b_mat_11 b_mat_12 b_mat_13 |
                    //| tvx tvy tvz | | b_mat_21 b_mat_22 b_mat_23 | = | mvx mvy mvz |
                    //                | b_mat_31 b_mat_32 b_mat_33 |
                    //
                    //ƂȂ͂B(tvx, tvy, tvz)ɂĉBts|ċ߂ΗǂB
                    //
                    //                                   | b_mat_11 b_mat_12 b_mat_13 | -1
                    // | tvx tvy tvz | = | mvx mvy mvz | | b_mat_21 b_mat_22 b_mat_23 |
                    //                                   | b_mat_31 b_mat_32 b_mat_33 |
                    //
                    //mvx mvy mvz ߂
                    int mvx,mvy,mvz;
                    if (RND(1, 100) < 90) {
                        //ʏ̎@_xNg
                        GgafDxGeometricActor* pTargetActor = P_MYSHIP;
                        mvx = pTargetActor->_x - _x; //ł _x, _y, _z ͐΍Wł邱Ƃ|Cg
                        mvy = (pTargetActor->_y + PX_C(50)) - _y; //@̂_
                        mvz = pTargetActor->_z - _z;
                    } else {
                        //܁`ɋtڕWɂāAGɓv
                        GgafDxGeometricActor* pTargetActor = P_MYSHIP;
                        mvx = _x - pTargetActor->_x;
                        mvy = _y - pTargetActor->_y;
                        mvz = _z - pTargetActor->_z;
                    }
                    //ts擾
                    D3DXMATRIX* pBaseInvMatRM = _pActor_Base->getInvMatWorldRotMv();
                    //[JWł̃^[QbgƂȂxNgvZ
                    int tvx = mvx*pBaseInvMatRM->_11 + mvy*pBaseInvMatRM->_21 + mvz * pBaseInvMatRM->_31;
                    int tvy = mvx*pBaseInvMatRM->_12 + mvy*pBaseInvMatRM->_22 + mvz * pBaseInvMatRM->_32;
                    int tvz = mvx*pBaseInvMatRM->_13 + mvy*pBaseInvMatRM->_23 + mvz * pBaseInvMatRM->_33;
                    //V[NGXJn
                    angle angRz_Target, angRy_Target;
                    UTIL::convVectorToRzRy(tvx, tvy, tvz, angRz_Target, angRy_Target);
                    //vŽʁAangRz_Target angRy_Target Ɍ΁A@Ɍ

                    //angRz_TargetAangRy_Target ͈͓ɐ
                    if (aiming_movable_limit_ang_ <= angRz_Target && angRz_Target <= D180ANG) {
                        angRz_Target = aiming_movable_limit_ang_;
                    } else if (D180ANG <= angRz_Target && angRz_Target <= D360ANG - aiming_movable_limit_ang_) {
                        angRz_Target = D360ANG - aiming_movable_limit_ang_;
                    }
                    if (aiming_movable_limit_ang_ <= angRy_Target && angRy_Target <= D180ANG) {
                        angRy_Target = aiming_movable_limit_ang_;
                    } else if (D180ANG <= angRy_Target && angRy_Target <= D360ANG - aiming_movable_limit_ang_) {
                        angRy_Target = D360ANG - aiming_movable_limit_ang_;
                    }

    //                _pKuroko->turnRzRyFaceAngTo(
    //                                angRz_Target, angRy_Target,
    //                                aiming_ang_velo_, aiming_ang_velo_*0.04,
    //                                TURN_CLOSE_TO, false);
                    _pKuroko->hlprB()->turnRzRyFaceAngByVdTo(
                            aiming_ang_velo_,
                            angRz_Target, angRy_Target, TURN_CLOSE_TO, false,
                            0.4, 0.6, 0, true);
                }
            }
            if (_pKuroko->isTurningFaceAng()) {
                // ҋ@
            } else {
                _pProg->change(PROG_NOTHING);
            }

//            if (_pKuroko->isTurningMvAng()) {
//                // ҋ@
//            } else {
//                _pProg->change(PROG_NOTHING);
//            }
            break;
        }

        default :
            break;
    }

    //Ӂ
    //EGgafDxKuroko(_pKuroko) behave() ȊO\bh́AɃ[JW̑ƂB
    //  behave()ȊO\bh͎ۂɍWvZĂ킯ł͂Ȃ̂ŁA
    //  changeGeoFinal()AchangeGeoLocal()Ɋ֌WȂAĂяo\B
    //EGgafDxKuroko(_pKuroko) behave() \bh͍WPt[̏ԂɂvZsB
    //  āÂ悤 [JW(changeGeoLocal())ŌĂяoƂB
    //    changeGeoLocal();
    //    _pKuroko->behave();
    //    changeGeoFinal();
    changeGeoLocal();
    _pKuroko->behave();
    changeGeoFinal();
    //pScaler_->behave();
    if (_pActor_Base) {
        setAlpha(((GgafDxDrawableActor*)_pActor_Base)->getAlpha());
    }
}

void EnemyErmioneArm::processJudgement() {
    if (_pActor_Base != nullptr && _pActor_Base->isActiveInTheTree()) {
    } else {
        //y䂪ȂΎ
        sayonara();
    }
}


void EnemyErmioneArm::onInactive() {
    sayonara();
}

void EnemyErmioneArm::onCatchEvent(hashval prm_no, void* prm_pSource) {
    if ( prm_no == EVENT_ERMIONE_SAYONARA) {
        //{̔j
        setHitAble(false);
        UTIL::activateExplosionEffectOf(this);//GtF
        sayonara();
    }
    if ( prm_no == EVENT_ERMIONE_ENTRY_DONE) {
        setHitAble(true);
        _pProg->change(PROG_NOTHING);
    }
}

EnemyErmioneArm::~EnemyErmioneArm() {
}
