#include "stdafx.h"
#include "EnemyOmulus.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

#define MORPHTARGET_HATCH_OPEN 1

EnemyOmulus::EnemyOmulus(const char* prm_name) :
        DefaultMorphMeshActor(prm_name, "1/Omulus", STATUS(EnemyOmulus)) {
    _class_name = "EnemyOmulus";
    pScaler_ = NEW GgafDxScaler(this);
    is_open_hatch_ = false;
    frame_of_open_interval_  = 3*60;
    frame_of_close_interval_ = 20*60;
    frame_of_morph_interval_ = 120;

    pDepo_Fired_ = nullptr;
    pDepoConnection_ = connect_DepositoryManager("Talante");

    _pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");
    useProgress(PROG_BANPEI);
}

void EnemyOmulus::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.9, 0.1, 1.0);
    _pModel->_pTexBlinker->setPower(0.1);
    _pModel->_pTexBlinker->beat(120, 60, 1, -1);
    _pModel->setSpecular(5.0, 1.0);
}

void EnemyOmulus::initialize() {
    setHitAble(true);
    _pKuroko->relateFaceWithMvAng(true);
    _pMorpher->forceWeightRange(MORPHTARGET_HATCH_OPEN, 0.0f, 1.0f);
    _pMorpher->setWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 200000);
    pScaler_->setScale(1000);
    pScaler_->forceRange(1000, 1200);
    pScaler_->beat(30, 5, 5, -1);
    pDepo_Fired_ = pDepoConnection_->peek();
}

void EnemyOmulus::onActive() {
    _pStatus->reset();
    _pMorpher->setWeight(MORPHTARGET_HATCH_OPEN, 0.0f);
    is_open_hatch_ = false;
//    frame_of_moment_nextopen_ = frame_of_close_interval_;
    _pProg->reset(PROG_HATCH_CLOSE);
}

void EnemyOmulus::processBehavior() {
    //{[ɂAN^[̃
    //_x, _y, _z, _rx, _ry, _rz ɂĂQ̍WnZbg؂ւKvȎdlłB
    //ꂼꃍ[JWAŏIi΁jWƌĂԂƂɂ܂B
    //EŏIi΁jW EEE ʂ̃[hWn̎łB
    //E[JW     EEE eAN^[̊_(0,0,0)̑ΓIȍWnӖ܂B
    //                          WvZ͂ōsĉB
    //j
    //  @WvZ͎Ƀ[JWňvZłBGgafDxKuroko Ń[JWn̑sƂƂB
    //    AWؓo^A蔻A^[QbgWȂǁÃIuWFNg烏[hWQƂ铙A
    //    {Ԃ͍ŏIi΁jWnB
    //    processBehavior()Jn ŏIi΁jWn(changeGeoFinal())̏ԂƂȂĂB
    //  AprocessBehavior()ŕKvɉ changeGeoLocal() Ńo[ _x, _y, _z, _rx, _ry, _rz [JWn
    //    ؂ւ邱Ƃ\Bړ̍WvZsB
    //  BA processBehavior() 𔲂ۂɂ͕KŏIW(changeGeoFinal())̏Ԃɖ߂ĂB
    //  CŏIi΁jWƁA[JW݂͌ɓƗA͂ȂA
    //    \̃[hϊs쐬AsςōAŏIIȕ\ʒu肷B

    //changeGeoLocal(); s
    //[JWnɐؑւ܂B
    //E_x, _y, _z     EEE ́A[JWӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_x, _y, _z 
    //                        [JWlɐ؂ւ܂B
    //E_rx, _ry, _rz  EEE ́A[JWł̎]lӖ悤ɂȂ܂B
    //                        changeGeoLocal(); sƎI_rx, _ry, _rz
    //                        [JW]lɐ؂ւ܂B

    //changeGeoFinal(); s
    //ŏIi΁jWnɐ؂ւ܂B
    //E_x, _y, _z    EEE t[ GgafDxGeometricActor::processSettlementBehavior() ŌvZꎩXVĂ܂B
    //                       processBehavior()  changeGeoFinal() sƁAPt[O_x, _y, _zɐ؂ւ鎖ɂȂ܂B
    //                       _x, _y, _z ͎QƐpBlĂӖL܂
    //E_rx, _ry, _rz EEE t[ GgafDxGeometricActor::processSettlementBehavior() ܂I
    //                       changeGeoFinal(); sĂA_rx, _ry, _rz ͈ȑO̍ŏIi΁jWn̒l
    //                       ςȂŕω܂B
    //                       ̃IuWFNgA{[ɂAN^[QƂƂA_rx, _ry, _rz͑SMpł܂B

    //Ӂ
    //EGgafDxKuroko(_pKuroko) behave() ȊO\bh́AɃ[JW̑ƂB
    //  behave()ȊO\bh͎ۂɍWvZĂ킯ł͂Ȃ̂ŁA
    //  changeGeoFinal()AchangeGeoLocal()Ɋ֌WȂAĂяo\B
    //EGgafDxKuroko(_pKuroko) behave() \bh͍WPt[̏ԂɂvZsB
    //  āÂ悤 [JW(changeGeoLocal())ŌĂяoƂB
    //    changeGeoLocal();
    //    _pKuroko->behave();
    //    changeGeoFinal();
    //TODO:݊ƂȂB

    switch (_pProg->get()) {
        case PROG_INIT: {
            _pProg->change(PROG_HATCH_CLOSE);
            break;
        }
        case PROG_HATCH_CLOSE: {
            if (_pProg->isJustChanged()) {
                _pMorpher->morphLinerUntil(MORPHTARGET_HATCH_OPEN,
                                                0.0f, frame_of_morph_interval_);
                _pKuroko->setFaceAngVelo(AXIS_X, -3000);
            }

            //
            if (_pProg->getFrameInProgress() >= frame_of_close_interval_ + frame_of_morph_interval_) {
                _pProg->change(PROG_HATCH_OPEN);
            }
            break;
        }
        case PROG_HATCH_OPEN: {
            if (_pProg->isJustChanged()) {
                _pMorpher->morphLinerUntil(MORPHTARGET_HATCH_OPEN,
                                                1.0f, frame_of_morph_interval_);
                _pKuroko->setFaceAngVelo(AXIS_X, 0);
            }

            //I[vGo
            if (_pMorpher->_weight[MORPHTARGET_HATCH_OPEN] > 0.5) { //[Vȏ܂œBȂ
                if (_pProg->getFrameInProgress() % (frame)(RF_EnemyOmulus_ShotInterval(G_RANK)) == 0) { //oԊu
                    if (pDepo_Fired_) {
                        GgafDxDrawableActor* pActor = (GgafDxDrawableActor*)pDepo_Fired_->dispatch();
                        if (pActor) {
                            //݂̍ŏIIȌARzRyŎ擾遄
                            //xNg̓[hϊs̐ρi_matWorldRotMv)ŕϊA݂̍ŏIIȌɌB
                            //̕xNg(x_org_,y_org_,z_org_)A
                            //[hϊs̉]̐ρi_matWorldRotMv)̐ mat_xxA
                            //ŏIIȕxNg(vX, vY, vZ) Ƃ
                            //
                            //                          | mat_11 mat_12 mat_13 |
                            // | x_org_ y_org_ z_org_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
                            //                          | mat_31 mat_32 mat_33 |
                            //
                            //vX = x_org_*mat_11 + y_org_*mat_21 + z_org_*mat_31
                            //vY = x_org_*mat_12 + y_org_*mat_22 + z_org_*mat_32
                            //vZ = x_org_*mat_13 + y_org_*mat_23 + z_org_*mat_33
                            //
                            //ĂŁAXO̒PʕxNg(1,0,0)̏ꍇ͂ǂȂ邩l
                            //
                            //vX = x_org_*mat_11
                            //vY = x_org_*mat_12
                            //vZ = x_org_*mat_13
                            //
                            //ƂȂB{Avł́Af͑S(1,0,0)OƂĂ邽
                            //ŏIIȕxNǵix_org_*mat_11, x_org_*mat_12, x_org_*mat_13) łB
                            angle Rz, Ry;
                            UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13,
                                                   Rz, Ry); //݂̍ŏIIȌARzRyŎ擾I
                            pActor->_pKuroko->setRzRyMvAng(Rz, Ry); //RzRyMoverɐݒ
                            pActor->positionAs(this);
                            pActor->reset();
                        }
                    }
                }
            }
            if (_pProg->getFrameInProgress() >= frame_of_open_interval_+ frame_of_morph_interval_) {
                _pProg->change(PROG_HATCH_CLOSE);
            }
            break;
        }
        default :
            break;
    }
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));

    if (getActiveFrame() % 10U == 0                   && 1 == 2) {
        //@֕
        //lF[JWnŗ\߂ǂ̕ɌĂ΁AŏIIɎ@ɌƂɂȂ邩߂
        //
        //@ւ̌߂̕ϊOԂł̃^[Qbgʒu(tvx, tvy, tvz) ƂA
        //uy܂Łv̍s̐ρi_pActor_Base->_matWorldRotMv)  b_mat_xx ƂB
        //݂̍ŏIW玩@ւ̌̃xNgA(mvx, mvy, mvz) ƂƁA
        //
        //                | b_mat_11 b_mat_12 b_mat_13 |
        //| tvx tvy tvz | | b_mat_21 b_mat_22 b_mat_23 | = | mvx mvy mvz |
        //                | b_mat_31 b_mat_32 b_mat_33 |
        //
        //ƂȂB[JW(tvx, tvy, tvz) ̕ƁA
        //ŏIIɎ@ɌƂɂȂB
        //ts|(tvx, tvy, tvz) ߂Ηǂ
        //
        //                                   | b_mat_11 b_mat_12 b_mat_13 | -1
        // | tvx tvy tvz | = | mvx mvy mvz | | b_mat_21 b_mat_22 b_mat_23 |
        //                                   | b_mat_31 b_mat_32 b_mat_33 |
        //

        //mvx mvy mvz ߂
        int mvx = P_MYSHIP->_x - _x;
        int mvy = P_MYSHIP->_y - _y;
        int mvz = P_MYSHIP->_z - _z;
        //ts擾
        D3DXMATRIX* pBaseInvMatRM = _pActor_Base->getInvMatWorldRotMv();
        //[JWł̃^[QbgƂȂxNgvZ
        int tvx = mvx*pBaseInvMatRM->_11 + mvy*pBaseInvMatRM->_21 + mvz * pBaseInvMatRM->_31;
        int tvy = mvx*pBaseInvMatRM->_12 + mvy*pBaseInvMatRM->_22 + mvz * pBaseInvMatRM->_32;
        int tvz = mvx*pBaseInvMatRM->_13 + mvy*pBaseInvMatRM->_23 + mvz * pBaseInvMatRM->_33;
        //V[NGXJn
        angle angRz_Target, angRy_Target;
        UTIL::convVectorToRzRy(tvx, tvy, tvz, angRz_Target, angRy_Target);
        _pKuroko->turnRzRyMvAngTo(angRz_Target, angRy_Target,
                                   1000, 0,
                                   TURN_CLOSE_TO, false);
    }

    pScaler_->behave();
    _pMorpher->behave();

    //_pKurokǒvZ̓[Jōs
    changeGeoLocal();
    _pKuroko->behave();
    changeGeoFinal();

}

void EnemyOmulus::processJudgement() {
    if (_pActor_Base != nullptr && _pActor_Base->isActiveInTheTree()) {
//        (*(_pActor_Base->_pFunc_calcRotMvWorldMatrix))(_pActor_Base, _matWorld);
    } else {
        //y䂪ȂΎ
        sayonara();
    }


//    if (isOutOfUniverse()) {
//        sayonara();
//    }
}

void EnemyOmulus::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
    } else {
        //j
        _pSeTx->play3D(SE_DAMAGED);
    }
}

void EnemyOmulus::onInactive() {
    sayonara();
}

EnemyOmulus::~EnemyOmulus() {
    pDepoConnection_->close();
    GGAF_DELETE(pScaler_);
}
