#include "stdafx.h"
#include "EnemyOzartiaShot01.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"


using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyOzartiaShot01::EnemyOzartiaShot01(const char* prm_name) :
        DefaultMeshSetActor(prm_name, "myvic", STATUS(EnemyOzartiaShot01)) {
    _class_name = "EnemyOzartiaShot01";
    pAFader_ = NEW GgafDxAlphaFader(this);
}

void EnemyOzartiaShot01::initialize() {
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB(0, -30000, -30000, 30000, 30000);
    setHitAble(true);
    _pProg->reset(PROG_INIT);
}

void EnemyOzartiaShot01::onActive() {
    _pStatus->reset();
}

void EnemyOzartiaShot01::processBehavior() {
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));
    //{̈ړn̏  --->
    switch (_pProg->get()) {
        case PROG_INIT: {
            setHitAble(false);
            pAFader_->setAlpha(0);
            UTIL::activateEntryEffectOf(this);
            _pProg->changeNext();
            break;
        }
        case PROG_ENTRY: {
            if (_pProg->isJustChanged()) {
                pAFader_->fadeLinerUntil(1.0, 15);
            }
            if (_pProg->getFrameInProgress() == 8) {
                setHitAble(true);
                _pProg->change(PROG_MOVE01);
            }
            break;
        }
        case PROG_MOVE01: {
            if (_pProg->isJustChanged()) {
            }
            if (_pProg->getFrameInProgress() == 60*10) {
                _pProg->change(PROG_LEAVE);
            }
            break;
        }
        case PROG_LEAVE: {
             if (_pProg->isJustChanged()) {
                 UTIL::activateLeaveEffectOf(this);
                 pAFader_->fadeLinerUntil(0.0, 15);
             }
             if (_pProg->getFrameInProgress() == 60) {
                 sayonara();
                 _pProg->changeNothing(); //܂I
             }
             break;
         }
        default :
            break;
    }
    _pKuroko->behave();
}

void EnemyOzartiaShot01::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyOzartiaShot01::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg
    if (UTIL::calcEnemyStamina(this, pOther) <= 0) {
        setHitAble(false);
        //
        UTIL::activateExplosionEffectOf(this);
//        _pSeTx->play3D(ERESSHOT001_SE_EXPLOSION);

        sayonara();
    }
}

void EnemyOzartiaShot01::onInactive() {
    sayonara();
}

EnemyOzartiaShot01::~EnemyOzartiaShot01() {
    GGAF_DELETE(pAFader_);
}
