#include "stdafx.h"
#include "ScoreItem.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

ScoreItem::ScoreItem(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat)
               : Item(prm_name, prm_model, prm_pStat) {
    _class_name = "ScoreItem";
    pAxsMver_ = NEW GgafDxAxesMover(this);
    effectBlendOne(); //ZTechniquew
    setZEnable(true);        //Zobt@͍lL
    setZWriteEnable(false);  //Zobt@͏ݖ
    setAlpha(0.9);

    _pKuroko->setFaceAngVelo(AXIS_X, D_ANG(3));
    _pKuroko->setFaceAngVelo(AXIS_Y, D_ANG(5));
    _pKuroko->setFaceAngVelo(AXIS_Z, D_ANG(7));
    _pKuroko->relateFaceWithMvAng(true);
    kDX_ = kDY_ = kDZ_ = 0;
    useProgress(PROG_BANPEI);
    setHitAble(true, false); //ʊO蔻͖
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 400000);
    _pSeTx->set(0, "WAVE_GET_ITEM_001");
}

void ScoreItem::initialize() {
}

void ScoreItem::onActive() {
    // _x, _y, _z ͔Wɐݒς
    setHitAble(true, false);

    pAxsMver_->forceVxyzMvVeloRange(-30000, 30000);
    pAxsMver_->setZeroVxyzMvVelo();
    pAxsMver_->setZeroVxyzMvAcce();
    pAxsMver_->stopGravitationMvSequence();

    //ݒ
    MyShip* pMyShip = P_MYSHIP;
//    //U΂͈͐`Pӂ̒
//    int scattered_renge    = _pColliChecker->_pCollisionArea->_papColliPart[0]->_dx; //蔻Ɠ
//    //n_A@ւ̕ւ̎U΂͈͐`̈悪ʒu鋗iscattered_distance > (scattered_renge/2) ł邱)
////    int scattered_distance = scattered_renge/2 + 400000;
//    //]āAscattered_distance ĂĂA@͓ȂĂ肬SĉłB

    _pKuroko->forceMvVeloRange(0, 20000);
    float vX, vY, vZ;
    UTIL::getNormalizeVector(
            pMyShip->_x - _x,
            pMyShip->_y - _y,
            pMyShip->_z - _z,
            vX, vY, vZ);
    int d = PX_C(200);
    int r = PX_C(75);
    _pKuroko->setMvAngTwd((coord)(_x + (vX * d) + RND(-r, +r)),
                           (coord)(_y + (vY * d) + RND(-r, +r)),
                           (coord)(_z + (vZ * d) + RND(-r, +r)) );
    _pKuroko->setMvVelo(2000);
    _pKuroko->setMvAcce(100);

    _pProg->reset(PROG_DRIFT);
    _sx = _sy = _sz = 1000;
}

void ScoreItem::processBehavior() {
    //ʏړ
    if (_pProg->get() == PROG_DRIFT) {
        //TractorMagicPROG_ATTACHֈڍs
        if (getTractorMagic()->is_tracting_) {
            effectFlush(6); //tbV
            setHitAble(false);
            _pProg->change(PROG_ATTACH);
        }
        //邢 onHit()  PROG_ATTACH ԕω̂҂
    }

    //@Ɠ蔻肪qbgA@Ɍ
    if (_pProg->get() == PROG_ATTACH) {
        MyShip* pMyShip = P_MYSHIP;
        if (_pProg->isJustChanged()) {
            //@Ɉ͂ň񂹂悤ȓݒ
            pAxsMver_->setVxyzMvVelo(_pKuroko->_vX*_pKuroko->_veloMv,
                                     _pKuroko->_vY*_pKuroko->_veloMv,
                                     _pKuroko->_vZ*_pKuroko->_veloMv);
            pAxsMver_->execGravitationMvSequenceTwd(pMyShip,
                                                    PX_C(20), 200, PX_C(100));
            _pKuroko->stopMv();
        }

        //@ߕӂɓBH
        if (ABS(pMyShip->_x - _x) < 20000 &&
            ABS(pMyShip->_y - _y) < 20000 &&
            ABS(pMyShip->_z - _z) < 20000 ) {

            kDX_ = pMyShip->_x - _x;
            kDY_ = pMyShip->_y - _y;
            kDZ_ = pMyShip->_z - _z;
            _pProg->change(PROG_ABSORB); //zz
        }

    }

    //@ߕӂɓBAzAz̓
    if (_pProg->get() == PROG_ABSORB) {
        MyShip* pMyShip = P_MYSHIP;
        if (_pProg->isJustChanged()) {
            pAxsMver_->setZeroVxyzMvVelo();
            pAxsMver_->setZeroVxyzMvAcce();
            pAxsMver_->stopGravitationMvSequence();
        }
        _x = pMyShip->_x + kDX_;
        _y = pMyShip->_y + kDY_;
        _z = pMyShip->_z + kDZ_;
        _sx -= 100;
        _sy -= 100;
        _sz -= 100;
        if (_sx < 5) {
            _pSeTx->play(0);
            _pProg->changeNothing();
            sayonara(); //I
        }
        G_SCORE += 100;
    }
    _pKuroko->behave();
    pAxsMver_->behave();
}

void ScoreItem::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
//    //ʏړ
//    if (_pProg->get() == PROG_DRIFT) {
//        //onHit() ŏԕω̂҂
//    }
//
//    //@Ɠ蔻肪qbg
//    if (_pProg->get() == PROG_ATTACH) {
//
//    }
//
//    //@ɋzAz̓
//    if (_pProg->get() == PROG_ABSORB) {
//    }
}

void ScoreItem::onInactive() {
}

void ScoreItem::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg


    if (_pProg->get() == PROG_DRIFT && (pOther->getKind() & KIND_MY_BODY))  {
        setHitAble(false);
        _pProg->change(PROG_ATTACH);
    }

}

ScoreItem::~ScoreItem() {
    GGAF_DELETE(pAxsMver_);
}
