#include "stdafx.h"
#include "MagicLvCursor.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/Magic.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoHelperA.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


MagicLvCursor::MagicLvCursor(const char* prm_name, const char* prm_model, MagicMeter* prm_pMagicMeter, Magic* prm_pMagic) :
        DefaultBoardActor(prm_name, prm_model) {
    _class_name = "MagicLvCursor";
    pAFader_ = NEW GgafDxAlphaFader(this);
    pScaler_ = NEW GgafDxScaler(this);
    pMagicMeter_ = prm_pMagicMeter;
    pMagic_ = prm_pMagic;
    magic_index_ = pMagicMeter_->lstMagic_.indexOf(pMagic_);
    if (magic_index_ < 0) {
        throwGgafCriticalException("MagicLvCursor::MagicLvCursor prm_pMagic("<<prm_pMagic->getName()<<")"<<
                                   "MagicMeterɓo^Ă܂B");
    }
    point_lv_ = 0;
    tmp_y_ = _y;
    tmp_alpha_ = _alpha;
    tx_ = 0;
    ty_ = 0;
    setZWriteEnable(false);
}

void MagicLvCursor::initialize() {
    setAlign(ALIGN_CENTER, VALIGN_MIDDLE);
    //MagicMeter̍W܂Ăs
    _x = tx_ = pMagicMeter_->_x + (pMagicMeter_->width_ * magic_index_) + (pMagicMeter_->width_ / 2);
    _y = ty_ = pMagicMeter_->_y - (pMagicMeter_->height_*(point_lv_+1)) + (pMagicMeter_->height_ / 2);
    _pUvFlipper->exec(FLIP_ORDER_LOOP, 1);
    pScaler_->forceRange(1000, 3000);
}

void MagicLvCursor::processBehavior() {


    _pKuroko->behave();
    if (_pKuroko->hlprA()->isJustFinishSlidingMv()) {
        //zʒuɕ␳
        _x = tx_;
        _y = ty_;
    }
    _pUvFlipper->behave();
    pAFader_->behave();
    pScaler_->behave();
}
void MagicLvCursor::processPreDraw() {
    //J[\֘A
    //߂ɔȂij悤ɂ
    //{pAFader_A`掞̂݃[̔l
    float rr = pMagicMeter_->r_roll_[magic_index_];
    float alpha_r = rr * 2 - 1.0f;
    if (alpha_r < 0.0f) {
        alpha_r = 0.0f;
    }
    tmp_alpha_ = getAlpha();//ޔ
    setAlpha(alpha_r*tmp_alpha_*pMagicMeter_->getAlpha());
    //ŁA[YW␳
    tmp_y_ = _y; //ޔ
    _y += (1.0 * pMagicMeter_->height_ * (point_lv_+1) * (1.0 - rr));
    DefaultBoardActor::processPreDraw();

    //YW[Ǐ]ςAMagicLvCursor003::processPreDraw() l̕ύXI
}

void MagicLvCursor::processAfterDraw() {
    DefaultBoardActor::processAfterDraw();
    _y = tmp_y_; //A
    setAlpha(tmp_alpha_); //A

    //YW[Ǐ]ςAMagicLvCursor003::processAfterDraw() l̕ύXI
}

void MagicLvCursor::moveTo(int prm_lv) {
    _pKuroko->hlprA()->stopSlidingMv();
    _pKuroko->stopMv();
    point_lv_ = prm_lv;
    _x = tx_ = pMagicMeter_->_x + (pMagicMeter_->width_ * magic_index_) + (pMagicMeter_->width_ / 2);
    _y = ty_ = pMagicMeter_->_y - (pMagicMeter_->height_*(point_lv_+1)) + (pMagicMeter_->height_ / 2);
}

void MagicLvCursor::moveSmoothTo(int prm_lv, frame prm_target_frames, float prm_p1, float prm_p2) {
    _pKuroko->stopMv();
    //YW̃[iXCh\j̕lYWLVJ[\ړvZsĂB
    //processPreDraw()Ń[␳B
    point_lv_ = prm_lv;
    tx_ = pMagicMeter_->_x + (pMagicMeter_->width_ * magic_index_) + (pMagicMeter_->width_ / 2);
    ty_ = pMagicMeter_->_y - (pMagicMeter_->height_*(point_lv_+1)) + (pMagicMeter_->height_ / 2);
    _pKuroko->setMvAngTwd(tx_, ty_);
    _pKuroko->hlprA()->slideMvByDt(UTIL::getDistance(_x, _y, tx_, ty_), (int)prm_target_frames,
                           prm_p1, prm_p2, 0, true); //[lɂƂ肠ړ
}

void MagicLvCursor::blink() {
    pAFader_->beat(6, 3, 0, 0, 7.5); //sJsJA+0.5͍Ō͕\I
    pScaler_->beat(12, 6, 0, 3);
}

MagicLvCursor::~MagicLvCursor() {
    GGAF_DELETE(pAFader_);
    GGAF_DELETE(pScaler_);
}
