#include "stdafx.h"
#include "MagicLvCursor003.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/Magic.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


MagicLvCursor003::MagicLvCursor003(const char* prm_name, MagicMeter* prm_pMagicMeter, Magic* prm_pMagic) :
        MagicLvCursor(prm_name, "MagicLvCursor003", prm_pMagicMeter, prm_pMagic) {
    _class_name = "MagicLvCursor003";
    pMagicMeter_ = prm_pMagicMeter;
    pMagic_ = prm_pMagic;
    magic_index_ = pMagicMeter_->lstMagic_.indexOf(pMagic_);
    if (magic_index_ < 0) {
        throwGgafCriticalException("MagicLvCursor003::MagicLvCursor003 prm_pMagic("<<prm_pMagic->getName()<<")"<<
                                   "MagicMeterɓo^Ă܂B");
    }
}

void MagicLvCursor003::initialize() {
    MagicLvCursor::initialize();
    _pUvFlipper->setFlipPtnRange(0,3);
    _pUvFlipper->setActivePtn(3);
    _pUvFlipper->exec(NOT_ANIMATED);

    pScaler_->forceRange(1000, 10000);
}

void MagicLvCursor003::processPreDraw() {
    //MagicLvCursor::processPreDraw(); yсAMagicLvCursor::processAfterDraw()
    //ł́AYW[̒Ǐ]ƁA[I[vEN[YɔsȂĂB
    //A{J[\i"CASTING"Ȃǂ̕j[ĂȂ悤ɂ邽߁A
    //I[o[ChA邱ƂɂB
    //YW[Ǐ]͍ŝŁÂ̕ݎsƂɂB
    //MagicLvCursor::processPreDraw(); yсAMagicLvCursor::processAfterDraw() ̏ύXA
    //ύXB
    tmp_y_ = _y; //ޔ
    _y += (1.0 * pMagicMeter_->height_ * (point_lv_+1) * (1.0 - pMagicMeter_->r_roll_[magic_index_]));
    DefaultBoardActor::processPreDraw();
}

void MagicLvCursor003::processAfterDraw() {
    DefaultBoardActor::processAfterDraw();
    _y = tmp_y_; //A
}

void MagicLvCursor003::markOff() {
    _pUvFlipper->stopFlip();
    pAFader_->reset();
    pAFader_->setAlpha(0);
}

void MagicLvCursor003::markOnLevelUpCast(int prm_lv) {
    pAFader_->setAlpha(0);
    pAFader_->fadeLinerUntil(1.0, 20);
    moveTo(prm_lv);
    _pUvFlipper->setFlipPtnRange(0,3);
    _pUvFlipper->setActivePtn(0);
    _pUvFlipper->exec(FLIP_ORDER_LOOP, 1);
    pScaler_->setScale(10000);
    pScaler_->scaleLinerUntil(1000, 20);
    _pKuroko->setFaceAng(AXIS_Z, D180ANG);
    _pKuroko->turnRzFaceAngTo(0, D180ANG/20, 0, TURN_COUNTERCLOCKWISE);
}

void MagicLvCursor003::markOnLevelDownCast(int prm_lv) {
    pAFader_->setAlpha(1.0);
    pAFader_->fadeLinerUntil(0, 20);
    moveTo(prm_lv);
    _pUvFlipper->setFlipPtnRange(8, 11);
    _pUvFlipper->setActivePtn(8);
    _pUvFlipper->exec(FLIP_ORDER_LOOP, 1);
    pScaler_->setScale(1000);
    pScaler_->scaleLinerUntil(10000, 20);
}

void MagicLvCursor003::markOnInvoke(int prm_lv) {
    moveTo(prm_lv);
    _pUvFlipper->setFlipPtnRange(4, 7);
    _pUvFlipper->setActivePtn(4);
    _pUvFlipper->exec(FLIP_ORDER_LOOP, 1);
}

void MagicLvCursor003::markOnEffect(int prm_lv) {
    pAFader_->setAlpha(1.0);
    pAFader_->fadeLinerUntil(0, 20);
    moveTo(prm_lv);
    _pUvFlipper->setFlipPtnRange(8, 11);
    _pUvFlipper->setActivePtn(8);
    _pUvFlipper->exec(FLIP_ORDER_LOOP, 1);
    pScaler_->setScale(1000);
    pScaler_->scaleLinerUntil(10000, 20);
}

MagicLvCursor003::~MagicLvCursor003() {
}
