#include "stdafx.h"
#include "Magic.h"

#include "jp/ggaf/lib/util/PxQuantity.h"
#include "jp/gecchi/VioletVreath/actor/my/MyShip.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


Magic::Magic(const char* prm_name, int* prm_pMP,
             int prm_max_level,
             magic_point prm_cost_base            , double prm_r_every_lv_cost             , double prm_r_cost_lv_diff_base,
             magic_time  prm_time_of_casting_base , double prm_r_every_lv_time_of_casting  , double prm_r_time_of_casting_lv_diff_base,
             magic_time  prm_time_of_invoking_base, double prm_r_every_lv_time_of_invoking , double prm_r_time_of_invoking_lv_diff_base,
             magic_time  prm_time_of_effect_base  , double prm_r_every_lv_time_of_effecting,
             magic_point prm_keep_cost_base       , double prm_r_each_lv_keep_cost) : GgafMainActor(prm_name, nullptr),
pMP_(prm_pMP),
cost_base_(prm_cost_base),
time_of_casting_base_(prm_time_of_casting_base),
time_of_invoking_base_(prm_time_of_invoking_base),
time_of_effect_base_(prm_time_of_effect_base),
keep_cost_base_(prm_keep_cost_base),
r_every_lv_cost_(prm_r_every_lv_cost),
r_every_lv_time_of_casting_(prm_r_every_lv_time_of_casting),
r_every_lv_time_of_invoking_(prm_r_every_lv_time_of_invoking),
r_every_lv_time_of_effecting_(prm_r_every_lv_time_of_effecting),
r_each_lv_keep_cost_(prm_r_each_lv_keep_cost),
r_cost_lv_diff_base_(prm_r_cost_lv_diff_base),
r_time_of_casting_lv_diff_base_(prm_r_time_of_casting_lv_diff_base),
r_time_of_invoking_lv_diff_base_(prm_r_time_of_invoking_lv_diff_base) {

    max_level_  = prm_max_level;
    new_level_  = 0;
    last_level_ = 0;
    level_      = 0;

    level_nextframe_ = 0;
    new_level_nextframe_ = 0;
    last_level_nextframe_ = 0;

    prev_frame_level_ = level_;

    //exʎԋyсARXgArԁAԁAʎԁAێRXg\ߐݒ
    lvinfo_[0].remainingtime_of_effect_ = MAX_MAGIC_TIME;
    lvinfo_[0].cost_             = 0;
    lvinfo_[0].time_of_casting_  = 0;
    lvinfo_[0].time_of_invoking_ = 0;
    lvinfo_[0].time_of_effect_   = 0;
    lvinfo_[0].keep_cost_        = 0;
    lvinfo_[1].remainingtime_of_effect_ = 0;
    lvinfo_[1].cost_             = cost_base_;
    lvinfo_[1].time_of_casting_  = time_of_casting_base_;
    lvinfo_[1].time_of_invoking_ = time_of_invoking_base_;
    lvinfo_[1].time_of_effect_   = time_of_effect_base_;
    lvinfo_[1].keep_cost_        = keep_cost_base_;
    for (int i = 2; i <= MMETER_MAX_LEVEL; i++) {
        lvinfo_[i].remainingtime_of_effect_ = 0;
        lvinfo_[i].cost_             = lvinfo_[i-1].cost_             * r_every_lv_cost_;
        lvinfo_[i].time_of_casting_  = lvinfo_[i-1].time_of_casting_  * r_every_lv_time_of_casting_;
        lvinfo_[i].time_of_invoking_ = lvinfo_[i-1].time_of_invoking_ * r_every_lv_time_of_invoking_;
        lvinfo_[i].time_of_effect_   = lvinfo_[i-1].time_of_effect_   * r_every_lv_time_of_effecting_;
        lvinfo_[i].keep_cost_        = lvinfo_[i-1].keep_cost_        * r_each_lv_keep_cost_;
    }

    //x
    lvdiff_[0].r_cost_lv_diff_             = 0.0; //xOɃRXg͖B
    lvdiff_[0].r_time_of_casting_lv_diff_  = 0.0;
    lvdiff_[0].r_time_of_invoking_lv_diff_ = 0.0;
    lvdiff_[1].r_cost_lv_diff_             = 1.0;  //xPɃ{[iXT͖B
    lvdiff_[1].r_time_of_casting_lv_diff_  = 1.0;
    lvdiff_[1].r_time_of_invoking_lv_diff_ = 1.0;
    lvdiff_[2].r_cost_lv_diff_             = r_cost_lv_diff_base_; //xQŏ߂ĂɂȂB
    lvdiff_[2].r_time_of_casting_lv_diff_  = r_time_of_casting_lv_diff_base_;
    lvdiff_[2].r_time_of_invoking_lv_diff_ = r_time_of_invoking_lv_diff_base_;
    for (int i = 2; i <= MMETER_MAX_LEVEL; i++) { //xƂ肨B
        lvdiff_[i].r_cost_lv_diff_             = lvdiff_[i-1].r_cost_lv_diff_            * r_cost_lv_diff_base_;
        lvdiff_[i].r_time_of_casting_lv_diff_  = lvdiff_[i-1].r_time_of_casting_lv_diff_ * r_time_of_casting_lv_diff_base_;
        lvdiff_[i].r_time_of_invoking_lv_diff_ = lvdiff_[i-1].r_time_of_invoking_lv_diff_* r_time_of_invoking_lv_diff_base_;
    }

    _TRACE_("Magic::Magic "<<getName()<<" ̃xAbv̐l");
    //xAbṽRXgArԁAԂ\ߌvZ
    for (int now_lv = 0; now_lv <= MMETER_MAX_LEVEL; now_lv++) {
        for (int target_lv = now_lv; target_lv <= MMETER_MAX_LEVEL; target_lv++) {
            level_up_cost_[now_lv][target_lv] = (target_lv == now_lv ? 0 : level_up_cost_[now_lv][target_lv-1])
                                                 + (lvinfo_[target_lv].cost_ * lvdiff_[target_lv-now_lv].r_cost_lv_diff_);
            level_up_time_of_casting_[now_lv][target_lv] = (target_lv == now_lv ? 0 : level_up_time_of_casting_[now_lv][target_lv-1])
                                                           + (lvinfo_[target_lv].time_of_casting_ * lvdiff_[target_lv-now_lv].r_time_of_casting_lv_diff_);
            level_up_time_of_invoking_[now_lv][target_lv] = (target_lv == now_lv ? 0 : level_up_time_of_invoking_[now_lv][target_lv-1])
                                                            + (lvinfo_[target_lv].time_of_invoking_ * lvdiff_[target_lv-now_lv].r_time_of_invoking_lv_diff_);
        }
    }
#ifdef MY_DEBUG
    for (int now_lv = 0; now_lv <= MMETER_MAX_LEVEL; now_lv++) {
        for (int target_lv = now_lv; target_lv <= MMETER_MAX_LEVEL; target_lv++) {
             _TRACE_("Magic::Magic["<<getName()<<"] level_up_cost_["<<now_lv<<""<<target_lv<<"]="<<level_up_cost_[now_lv][target_lv]);
        }
    }
    for (int now_lv = 0; now_lv <= MMETER_MAX_LEVEL; now_lv++) {
        for (int target_lv = now_lv; target_lv <= MMETER_MAX_LEVEL; target_lv++) {
             _TRACE_("Magic::Magic["<<getName()<<"] level_up_time_of_casting_["<<now_lv<<""<<target_lv<<"]="<<level_up_time_of_casting_[now_lv][target_lv]);
        }
    }
    for (int now_lv = 0; now_lv <= MMETER_MAX_LEVEL; now_lv++) {
        for (int target_lv = now_lv; target_lv <= MMETER_MAX_LEVEL; target_lv++) {
            _TRACE_("Magic::Magic["<<getName()<<"] level_up_time_of_invoking_["<<now_lv<<""<<target_lv<<"]="<<level_up_time_of_invoking_[now_lv][target_lv]);
        }
    }
#endif

    //x_E͗p̂ŁA
    time_of_next_state_ = 0;
    useProgress(PROG_BANPEI);
    temp_hold_status_ = -1;
    temp_hold_new_level_ = 0;
    last_cast_ = MAGIC_CAST_NOTHING;
    last_invoke_ = MAGIC_INVOKE_NOTHING;
    last_effect_ = MAGIC_EFFECT_NOTHING;

}

void Magic::init() {
}

void Magic::onReset() {
    _TRACE_("Magic::onReset() ["<<getName()<<"] ");
    new_level_  = 0;
    last_level_ = 0;
    level_      = 0;
    prev_frame_level_ = level_;

    level_nextframe_ = 0;
    new_level_nextframe_ = 0;
    last_level_nextframe_ = 0;

    last_cast_ = MAGIC_CAST_NOTHING;
    last_invoke_ = MAGIC_INVOKE_NOTHING;
    last_effect_ = MAGIC_EFFECT_NOTHING;

    _pProg->reset(STATE_NOTHING);
    //exʎԋyсAێRXg\ߐݒ
    lvinfo_[0].remainingtime_of_effect_ = MAX_MAGIC_TIME;
    lvinfo_[1].remainingtime_of_effect_ = 0;
    for (int i = 2; i <= max_level_; i++) {
        lvinfo_[i].remainingtime_of_effect_ = 0;
    }
    time_of_next_state_ = 0;
    temp_hold_status_ = -1;
    temp_hold_new_level_ = 0;
}

void Magic::save(std::stringstream& sts) {
    sts << max_level_  << " " <<
           level_      << " " <<
           new_level_  << " " <<
           last_level_ << " ";
    for (int lv = 0; lv < MMETER_MAX_LEVEL+1; lv++) {
        sts <<  lvinfo_[lv].remainingtime_of_effect_ << " " <<
                lvinfo_[lv].time_of_effect_          << " " <<
                lvinfo_[lv].keep_cost_               << " " <<
                lvinfo_[lv].pno_                     << " ";
    }
}

void Magic::load(std::stringstream& sts) {
    sts >> max_level_
        >> level_
        >> new_level_
        >> last_level_;

    for (int lv = 0; lv < MMETER_MAX_LEVEL+1; lv++) {
        sts >> lvinfo_[lv].remainingtime_of_effect_
            >> lvinfo_[lv].time_of_effect_
            >> lvinfo_[lv].keep_cost_
            >> lvinfo_[lv].pno_;
    }
    effect(level_); //MAGIC_EFFECT_NOTHINGOKƎv
}

int Magic::chkCastAble(int prm_new_level) {
    if (_pProg->get() == STATE_INVOKING) {
        return MAGIC_CAST_NG_INVOKING_NOW; //̂ߎss
    } else if (_pProg->get() == STATE_CASTING) {
        if (prm_new_level == new_level_) {
            //݉rƓxr悤Ƃ
            return MAGIC_CAST_NOTHING; //ȂB
        } else {
            //̃xrɉrĎs
            if (level_ > prm_new_level) {
                return MAGIC_CAST_CANCEL_AND_LEVELDOWN; //rLZx_EOK
            } else if (level_ < prm_new_level) {
                if (level_up_cost_[level_][prm_new_level] <= *pMP_) {
                    return MAGIC_CAST_OK_CANCEL_AND_LEVELUP; //rLZĉrxAbvOK
                } else {
                    return MAGIC_CAST_NG_MP_IS_SHORT; //MPȂ߁AĉrxAbvs
                }
            } else { //level_==prm_new_level
                return MAGIC_CAST_CANCEL; //rLZ
            }
        }
    } else {
        //ҋ@Ԃʎɉrs
        if (level_ > prm_new_level) {
            return MAGIC_CAST_LEVELDOWN; //rx_EOK
        } else if (level_ < prm_new_level) {
            if (level_up_cost_[level_][prm_new_level] <= *pMP_) {
                return MAGIC_CAST_OK_LEVELUP; //rxAbvOK
            } else {
                return MAGIC_CAST_NG_MP_IS_SHORT; //MPȂ߁ArxAbvs
            }
        } else { //level_==prm_new_level
            return MAGIC_CAST_NOTHING; //ȂB
        }
    }
}

int Magic::cast(int prm_new_level) {
    last_cast_ = MAGIC_CAST_NOTHING;
    last_invoke_ = MAGIC_INVOKE_NOTHING;
    last_effect_ = MAGIC_EFFECT_NOTHING;

    int last_cast = chkCastAble(prm_new_level);
    switch (last_cast) {
        case MAGIC_CAST_NG_INVOKING_NOW: {
            //ʔ̂߉rs̂ŁAȂB
            break;
        }
        case MAGIC_CAST_NG_MP_IS_SHORT: {
            //MPȂrs̂ŁAȂB
            break;
        }
        case MAGIC_CAST_NOTHING: {
            //݂̃xƓxr悤ƂĂAȂB
            break;
        }
        case MAGIC_CAST_CANCEL: {
            //̃xrɍĉrsƂĂ
            //ĉr̃xǍ݂ʎxƓxw肵߁A
            //r~(LZ)ɂȂB
            _TRACE_("Magic::cast("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_CAST_CANCEL!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_NOTHING);
            break;
        }
        case MAGIC_CAST_OK_LEVELUP: {
            //݂̌ʎx荂xr悤ƂĂB
            _TRACE_("Magic::cast("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_CAST_OK_LEVELUP!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_CASTING);
            break;
        }
        case MAGIC_CAST_LEVELDOWN: {
            //݂̌ʎxႢxr悤ƂĂB
            _TRACE_("Magic::cast("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_CAST_LEVELDOWN!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_CASTING);
            break;
        }
        case MAGIC_CAST_OK_CANCEL_AND_LEVELUP: {
            //̃xrɍĉrsƂĂ
            //ĉr̃xǍ݂ʎx荂B
            _TRACE_("Magic::cast("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_CAST_OK_CANCEL_AND_LEVELUP!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_RE_CASTING);
            break;
        }
        case MAGIC_CAST_CANCEL_AND_LEVELDOWN: {
            //̃xrɍĉrsƂĂ
            //ĉr̃xǍ݂ʎxႢB
            _TRACE_("Magic::cast("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_CAST_CANCEL_AND_LEVELDOWN!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_RE_CASTING);
            break;
        }
    }
    last_cast_ = last_cast;
    return last_cast_;
}

int Magic::chkInvokeAble(int prm_new_level) {
    if (_pProg->get() == STATE_INVOKING) {
        //̂ߎss
        return MAGIC_INVOKE_NG_INVOKING_NOW;
    } else {
        if (level_ > prm_new_level) {
            return MAGIC_INVOKE_OK_LEVELDOWN;
        } else if (level_ < prm_new_level) {
            if (level_up_cost_[level_][prm_new_level] <= *pMP_) {
                return MAGIC_INVOKE_OK_LEVELUP;
            } else {
                return MAGIC_INVOKE_NG_MP_IS_SHORT;
            }
        } else { //level_==prm_new_level
            return MAGIC_INVOKE_NOTHING;
        }
    }
}

int Magic::chkEffectAble(int prm_level) {
    if (level_ > prm_level) {
        return MAGIC_EFFECT_OK_LEVELDOWN;
    } else if (level_ < prm_level) {
        if (level_up_cost_[level_][prm_level] <= *pMP_) {
            return MAGIC_EFFECT_OK_LEVELUP;
        } else {
            return MAGIC_EFFECT_NG_MP_IS_SHORT;
        }
    } else {
        //level_==prm_new_level
        return MAGIC_EFFECT_NOTHING;
    }
}

int Magic::invoke(int prm_new_level) {
    last_cast_ = MAGIC_CAST_NOTHING;
    last_invoke_ = MAGIC_INVOKE_NOTHING;
    last_effect_ = MAGIC_EFFECT_NOTHING;

    int last_invoke = chkInvokeAble(prm_new_level);
    switch (last_invoke) {
        case MAGIC_INVOKE_NG_INVOKING_NOW: {
            //蓾Ȃ
            throwGgafCriticalException("Magic::invoke("<<prm_new_level<<") "<<getName()<<"  MAGIC_INVOKE_NG_INVOKING_NOW ́Ã^C~Oł蓾Ȃ͂łB");
            break;
        }
        case MAGIC_INVOKE_NG_MP_IS_SHORT: {
            _TRACE_("Magic::invoke("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_INVOKE_NG_MP_IS_SHORT!");
            _pProg->change(STATE_NOTHING);
            break;
        }
        case MAGIC_INVOKE_OK_LEVELUP: {
            _TRACE_("Magic::invoke("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_INVOKE_OK_LEVELUP!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_INVOKING);
            break;
        }
        case MAGIC_INVOKE_OK_LEVELDOWN: {
            _TRACE_("Magic::invoke("<<prm_new_level<<") ["<<getName()<<"] 聨MAGIC_INVOKE_OK_LEVELDOWN!");
            new_level_nextframe_ = prm_new_level;
            _pProg->change(STATE_INVOKING);
            break;
        }
        case MAGIC_INVOKE_NOTHING: {
            //蓾Ȃ
            throwGgafCriticalException("Magic::invoke("<<prm_new_level<<") "<<getName()<<"  MAGIC_INVOKE_NOTHING ́Ã^C~Oł蓾Ȃ͂łB");
            break;
        }
    }
    last_invoke_ = last_invoke;
    return last_invoke_;
}

int Magic::effect(int prm_level) {
    last_cast_ = MAGIC_CAST_NOTHING;
    last_invoke_ = MAGIC_INVOKE_NOTHING;
    last_effect_ = MAGIC_EFFECT_NOTHING;

    int last_effect = chkEffectAble(prm_level);
    switch (last_effect) {
        case MAGIC_EFFECT_NG_MP_IS_SHORT: {
            //throwGgafCriticalException("Magic::effect("<<prm_level<<") "<<getName()<<"  MAGIC_EFFECT_NG_MP_IS_SHORT ́Ã^C~Oł蓾Ȃ͂łB");
            //肤
            _TRACE_("Magic::effect("<<prm_level<<") ["<<getName()<<"] 聨MAGIC_EFFECT_NG_MP_IS_SHORTAchange(STATE_NOTHING)");
            _pProg->change(STATE_NOTHING);
            break;
        }
        case MAGIC_EFFECT_NOTHING: {
            if (prm_level == 0) {
                _TRACE_("Magic::effect("<<prm_level<<") ["<<getName()<<"] 聨MAGIC_EFFECT_NOTHINGAȂɂ܂");
            } else {
                throwGgafCriticalException("Magic::effect("<<prm_level<<") "<<getName()<<"  MAGIC_EFFECT_NOTHING ́Ã^C~Oł蓾Ȃ͂łB");
            }
            break;
        }
        case MAGIC_EFFECT_OK_LEVELUP: {
            _TRACE_("Magic::effect("<<prm_level<<") ["<<getName()<<"] 聨MAGIC_EFFECT_OK_LEVELUPAchange(STATE_EFFECT_START)");
            //xXV
            last_level_nextframe_ = level_;
            level_nextframe_ = prm_level;
            _pProg->change(STATE_EFFECT_START);
            break;
        }
        case MAGIC_EFFECT_OK_LEVELDOWN: {
            _TRACE_("Magic::effect("<<prm_level<<") ["<<getName()<<"] 聨MAGIC_EFFECT_OK_LEVELDOWNAchange(STATE_RE_EFFECT)");
            //xXV
            last_level_nextframe_ = level_;
            level_nextframe_ = prm_level;
            _pProg->change(STATE_RE_EFFECT); // STATE_EFFECT_START ̂
            break;
        }

    }
    last_effect_ = last_effect;
    return last_effect_;
}
void Magic::nextFrame() {
    GgafMainActor::nextFrame();
    prev_frame_level_ = level_;

    level_ = level_nextframe_;
    new_level_ = new_level_nextframe_;
    last_level_ =  last_level_nextframe_;
}
void Magic::processBehavior() {
    progress prog = _pProg->get();
    switch (prog) {
        /////////////////////////////////////// ҋ@
        case STATE_NOTHING: {
            if (_pProg->isJustChanged()) {
                if (_pProg->isJustChangedFrom(STATE_CASTING)) {
                    _TRACE_("Magic::processBehavior() ["<<getName()<<"] rLZII");
                    processCastingCancel(level_); //R[obN
                } else if (_pProg->isJustChangedFrom(STATE_INVOKING)) {
                    _TRACE_("Magic::processBehavior() ["<<getName()<<"] LZII");
                    processInvokingCancel(level_); //R[obN
                }
            }
            break;
        }

        /////////////////////////////////////// rLZĉr
        case STATE_RE_CASTING: {
            _TRACE_("Magic::processBehavior() ["<<getName()<<"] rLZĉrI");
            processCastingCancel(level_); //R[obN
            _pProg->change(STATE_CASTING);
            break;
        }
        /////////////////////////////////////// r
        case STATE_CASTING: {
            if (_pProg->isJustChanged()) { //rJn
                time_of_next_state_ = level_up_time_of_casting_[level_][new_level_]; //rI
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] STATE_CASTING begin new_level_="<<new_level_<<" level_="<<level_<<" time_of_next_state_="<<time_of_next_state_<<"");
                processCastBegin(level_, new_level_);  //R[obN
            }
            //r
            processCastingBehavior(level_, new_level_); //R[obN
            if (level_ > new_level_ || _pProg->getFrameInProgress() >= time_of_next_state_) {
                //x_E͑ŔցA邢͉rIɔ
                int r = invoke(new_level_);
                processCastFinish(level_, new_level_, r);  //R[obN
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] r(STATE_CASTING)Xe[^XII");
            }
            break;
        }

        /////////////////////////////////////// 
        case STATE_INVOKING: {
            if (_pProg->isJustChanged()) { //Jn
                time_of_next_state_ = level_up_time_of_invoking_[level_][new_level_]; //I
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] STATE_INVOKING begin new_level_="<<new_level_<<" level_="<<level_<<" time_of_next_state_="<<time_of_next_state_<<"");
                processInvokeBegin(level_, new_level_);     //R[obN
            }
            //
            processInvokingBehavior(level_, new_level_);  //R[obN
            if (level_ > new_level_ || _pProg->getFrameInProgress() >= time_of_next_state_) {
                //x_E͑ŌʊJnA邢͔IɌʊJn
                int r = effect(new_level_);
                processInvokeFinish(level_, new_level_, r); //R[obN
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] (STATE_INVOKING)Xe[^XII");
            }
            break;
        }

        /////////////////////////////////////// Ax_EĎJn
        case STATE_RE_EFFECT: {
            _pProg->change(STATE_EFFECT_START);
            break;
        }
        /////////////////////////////////////// Jn
        case STATE_EFFECT_START: {
            if (_pProg->isJustChanged()) { //Jn
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] STATE_EFFECT_START begin");

                processEffectBegin(last_level_, level_); //ʎJnR[obN

                //MPvZ
                if (last_level_ < level_) {
                    _TRACE_("Magic::processBehavior() ["<<getName()<<"] xAbvBlast_level_="<<last_level_<<" level_="<<level_);
                    //xAbvꍇ
                    //ʎԐݒBщzꂽԂ̃xʎIc莞Ԃ𖞃^ݒ
                    for (int lv = last_level_+1; lv <= level_; lv++) {
                        lvinfo_[lv].remainingtime_of_effect_ = lvinfo_[lv].time_of_effect_; //Ԃ𖞃^
                    }

                    *pMP_ -= level_up_cost_[last_level_][level_]; //MP
                    _TRACE_("Magic::processBehavior() ["<<getName()<<"] "<<level_up_cost_[last_level_][level_]<<"MP("<<((*pMP_)+level_up_cost_[last_level_][level_])<<""<<(*pMP_)<<")");
                    if (*pMP_ < 0) {
                        *pMP_ = 0;
                    }
                } else if (last_level_ > level_) {
                    _TRACE_("Magic::processBehavior() ["<<getName()<<"] x_EBlast_level_="<<last_level_<<" level_="<<level_);
                    //x_Eꍇ
                    if (keep_cost_base_ <= 0) { //ێRXgȂ@̏ꍇ
                        if (lvinfo_[last_level_].time_of_effect_ > 0) {
                            //MPҌ
                            magic_point rmp = calcReduceMp(last_level_, level_);
                            *pMP_ += rmp;
                            _TRACE_("Magic::processBehavior() ["<<getName()<<"] "<<rmp<<"MPҌ("<<((*pMP_)-rmp)<<""<<(*pMP_)<<")");
                            if (*pMP_ > MY_SHIP_MAX_MP) {
                                *pMP_ = MY_SHIP_MAX_MP;
                            }
                        }
                    }
                    //щzꂽԂ̃x͒~ČʎIc莞ԂZbgݒ
                    for (int lv = last_level_; lv >= level_+1; lv--) {
                        lvinfo_[lv].remainingtime_of_effect_ = 0; //ʎIc莞Ԃ0
                    }
                    //level_̌ʎԂ͑Ȏ
                } else {
                    //last_level_ == level_
                    throwGgafCriticalException("Magic::processBehavior() ["<<getName()<<"] Vxł̔͂蓾Ȃ͂łBlevel_="<<level_<<" last_level_="<<last_level_<<"");
                }

            }

            //͂ɏ͋LqȂƁB
            _pProg->change(STATE_NOTHING);
            break;
        }

        default :
            break;
    }
    ///////////////////////////////////////

    if (temp_hold_status_ != -1) {
        //ꎞޔXe[^XꍇAƂɖ߂
        if (temp_hold_status_ == STATE_CASTING) {
            _TRACE_("Magic::processBehavior() ["<<getName()<<"] Ԗx_Eɉr̂łŎĉrI cast("<<temp_hold_new_level_<<")");
            cast(temp_hold_new_level_); //ĉr
        } else if (temp_hold_status_  == STATE_INVOKING) {
            _TRACE_("Magic::processBehavior() ["<<getName()<<"] Ԗx_Eɉr̂łŎĔI invoke("<<temp_hold_new_level_<<")");
            invoke(temp_hold_new_level_); //Ĕ
        }
        temp_hold_status_ = -1;
    }
    //@ʒEEE
    processEffectingBehavior(last_level_, level_); //R[obN

    do { //break EopA -->
    if (level_ > 0) {
        if (_pProg->isJustChangedTo(STATE_EFFECT_START) && time_of_effect_base_ == 0) {
            //@̂ߏI
            for (int lv = 1; lv <= level_; lv++) { //SxZbgݒ
                 lvinfo_[lv].remainingtime_of_effect_ = 0; //ʎIc莞Ԃ0
            }
            effect(0);
            _TRACE_("Magic::processBehavior() ["<<getName()<<"] @̂߁AȂ莝IBlast_level_="<<last_level_<<" level_="<<level_);
            break;
        }

        //@ȊO
        //ʎ@iRXgvZj
        //ێRXgH
        if (keep_cost_base_ > 0) {
            //ێRXgꍇ
            *pMP_ += -1*lvinfo_[level_].keep_cost_; //ێRXg
            //MP͊H
            if (*pMP_ <= 0) {
                //MP͊ɂ鎝I
                *pMP_ = 0;
                for (int lv = 1; lv <= level_; lv++) { //SxZbgݒ
                     lvinfo_[lv].remainingtime_of_effect_ = 0; //ʎIc莞Ԃ0
                }
                effect(0);
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] MP͊ɂ鎝IB");
                break;
            }
        }

        lvinfo_[level_].remainingtime_of_effect_ --;   //ʎc莞Ԍ
        if (lvinfo_[level_].remainingtime_of_effect_ == 0) { //H
            //ԖŃx_E
             _TRACE_("Magic::processBehavior() ["<<getName()<<"] Ԗ lv="<<level_<<""<<(level_-1)<<"");
            //effect(level_-1); Ȃ̂܂܂A
            //Ԗɂ郌x_ÉAɂ郌x_EƂ͏󋵂قȂA
            //ʃxrA܂͔ꍇ effect ̌ɁAXe[^Xɖ߂KvB
            if (prog == STATE_CASTING) {
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] ʎEEEEA݉rŎԖBeffect() ĉr\");
                temp_hold_status_ = _pProg->get(); //ŁAXe[^Xꎞޔ(ꂵEEE)
                temp_hold_new_level_ = new_level_; //r͔悤ƂĂVxێ
            } else if (prog == STATE_INVOKING) {
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] ʎEEEEAݔŎԖBeffect() 㔭\");
                temp_hold_status_ = _pProg->get(); //ŁAXe[^Xꎞޔ(ꂵEEE)
                temp_hold_new_level_ = new_level_; //r͔悤ƂĂVxێ
            } else {
                //STATE_EFFECT_START
                _TRACE_("Magic::processBehavior() ["<<getName()<<"] ʎEEEEAʂɎԖ (^_^)");
            }
            effect(level_-1);
            _TRACE_("Magic::processBehavior() ["<<getName()<<"] ԖŎIB");
            break;
        }
    }
    }while(false); //<--break EopA܂


    //_TRACE_("Magic::processBehavior() F="<<getBehaveingFrame()<<" after _pProg->get()="<<_pProg->get());

}

magic_point Magic::calcReduceMp(int prm_now_level, int prm_target_down_level) {
    //RXgҌB
    //̌vZł́Ax0 > ő僌xAbv  x0փx_E fsƁA
    //XƂvZB
    //ex̎čʎԂ̊lB
    //_TRACE_("calcReduceMp!!!");
    //_TRACE_("prm_now_level="<<prm_now_level<<" prm_target_down_level="<<prm_target_down_level);
    magic_point mp = 0;
    for (int lv = prm_now_level; lv > prm_target_down_level; lv--) {
        double utilization_rate = lvinfo_[lv].time_of_effect_ == 0 ? 0.0 : (1.0*lvinfo_[lv].remainingtime_of_effect_ / lvinfo_[lv].time_of_effect_); //gp
        mp += (lvinfo_[lv].cost_ * utilization_rate * lvdiff_[max_level_-(prm_now_level-lv)].r_cost_lv_diff_);
        //_TRACE_(lv << ":lvinfo_["<<lv<<"].cost_="<<(lvinfo_[lv].cost_)<<" ");
        //_TRACE_(lv << ":utilization_rate="<<utilization_rate<<" ");
        //_TRACE_(lv << ":lvdiff_[max_level_-(prm_now_level-lv)]=lvdiff_["<<max_level_<<"-("<<prm_now_level<<"-"<<lv<<")]=lvdiff_["<<(max_level_-(prm_now_level-lv))<<"].r_cost_lv_diff_="<<(lvdiff_[max_level_-(prm_now_level-lv)].r_cost_lv_diff_));
        //_TRACE_(lv << ":+="<<(lvinfo_[lv].cost_ * utilization_rate * lvdiff_[max_level_-(prm_now_level-lv)].r_cost_lv_diff_));
        //_TRACE_(lv << ":mp="<<mp);
    }
//_TRACE_("return="<<mp);
    return mp;
}

Magic::~Magic() {
}
