#include "stdafx.h"
#include "MyShip.h"

#include "jp/ggaf/core/actor/ex/GgafActorDepository.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAxesMover.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/util/GgafDxCollisionArea.h"
#include "jp/ggaf/dxcore/util/GgafDxCollisionPart.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/effect/EffectTurbo001.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/DamageDispBar.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/MyMagicEnergyCore.h"
#include "jp/gecchi/VioletVreath/actor/my/MyShot001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyStraightLaserChip001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyTorpedoController.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/Properties.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

int MyShip::wk_dist = 0;
angle MyShip::wk_angRx = 0;

#define S_OPTION 0
coord MyShip::lim_y_top_     =  0;
coord MyShip::lim_y_bottom_  =  0;
coord MyShip::lim_x_front_   =  0;
coord MyShip::lim_x_behaind_ =  0;
coord MyShip::lim_z_left_   =  0;
coord MyShip::lim_z_right_  =  0;

MyShip::MyShip(const char* prm_name) :
        DefaultD3DXMeshActor(prm_name, "VicViper", STATUS(MyShip)) {
//DefaultMeshActor(prm_name, "jiki", STATUS(MyShip)) {
//CubeMapMeshActor(prm_name, "wakka", STATUS(MyShip)) {
//DefaultD3DXAniMeshActor(prm_name, "AnimatedSkelton", STATUS(MyShip)) {
    _class_name = "MyShip";
    pAxsMver_ = NEW GgafDxAxesMover(this);

    //effectBlendOne(); //ZTechniquew

    //ʂ̑傫ɔāAړ͈͂
    //̂FovXɈˑ̂ŔB
    coord harf_width  = PX_C(PROPERTY::GAME_BUFFER_WIDTH)/2;
    coord harf_height = PX_C(PROPERTY::GAME_BUFFER_HEIGHT)/2;

    lim_y_top_     =  harf_height + PX_C(PROPERTY::GAME_BUFFER_HEIGHT*4);  //́A4ʕ
    lim_y_bottom_  = -harf_height - PX_C(PROPERTY::GAME_BUFFER_HEIGHT*4);  //́A4ʕ
    lim_x_front_   =  harf_width  + PX_C(PROPERTY::GAME_BUFFER_WIDTH*2);   //ÓA2ʕ
    lim_x_behaind_ = -harf_width  - PX_C(PROPERTY::GAME_BUFFER_WIDTH*2);   //́A2ʕ
    lim_z_left_   =  harf_width  + PX_C(PROPERTY::GAME_BUFFER_WIDTH*2);   //ÓA2ʕ
    lim_z_right_  = -harf_width  - PX_C(PROPERTY::GAME_BUFFER_WIDTH*2);   //́A2ʕ
    _TRACE_("MyShip::MyShip ͈ X("<<lim_x_behaind_<<" ~ "<<lim_x_front_<<") Y("<<lim_y_bottom_<<" ~ "<<lim_y_top_<<") Z("<<lim_z_right_<<" ~ "<<lim_z_left_<<")");

    /** ړXs[hxɑړXs[h */
    iMoveSpeed_ = 2000;
    //CommonScenenew̏ꍇݒ
    angRxVelo_BeginMZ_ = 1000; //͎O֒ʏZʏړJnX]px̏x
    angRxAcce_MZ_ = 300; //͎O֒ʏZړX]px̏px
    angRxTopVelo_MZ_ = 5000; //͎O֒ʏZړX]px̏px
    angRxStop_MZ_ = 90000; //͎O֒ʏZړX]p̖ڕW~px
    angRxVelo_BeginMZT_ = 20000;//͎OTurboړJnX]px̏x

    iMvBtmVelo_MT_ = 0; //Turboړ̈ړx̍Œᑬx
    veloBeginMT_ = 40000; //TurboړJn̈ړx̏x
    acce_MT_ = -200; //Turboړ̈ړx̉x

//    pOptionCtrler_ = NEW MyOptionController("MY_OPTION_PARENT");
//    addSubLast(pOptionCtrler_);

//    //debug ---->
//    pDepo_TestGuShot_ = NEW GgafActorDepository("Depo_TestGuShot");
//    for (int i = 0; i < 25; i++) { //eXgO[eXgbN
//        pDepo_TestGuShot_->addSubLast(NEW TestGuShot("TestGuShot"));
//    }
//    addSubGroup(pDepo_TestGuShot_);
//    pDepo_TestChokiShot_ = NEW GgafActorDepository("Depo_TestChokiShot");
//    for (int i = 0; i < 25; i++) { //eXg`LeXgbN
//        pDepo_TestChokiShot_->addSubLast(NEW TestChokiShot("TestChokiShot"));
//    }
//    addSubGroup(pDepo_TestChokiShot_);
//    pDepo_TestPaShot_ = NEW GgafActorDepository("Depo_TestPaShot");
//    for (int i = 0; i < 25; i++) { //eXgp[eXgbN
//        pDepo_TestPaShot_->addSubLast(NEW TestPaShot("TestPaShot"));
//    }
//    addSubGroup(pDepo_TestPaShot_);
//    pDepo_TestNomalShot_ = NEW GgafActorDepository("Depo_TestNomalShot");
//    for (int i = 0; i < 25; i++) { //eXgm[}eXgbN
//        pDepo_TestNomalShot_->addSubLast(NEW TestNomalShot("TestNomalShot"));
//    }
//    addSubGroup(pDepo_TestNomalShot_);
//    //<---- debug


    pDepo_MyShots001_ = NEW GgafActorDepository("RotShot001");
    MyShot001* pShot;
    for (int i = 0; i < 25; i++) { //eXgbN
        pShot = NEW MyShot001("MY_MyShot001");
        pShot->inactivate();
        pDepo_MyShots001_->put(pShot);
    }
    addSubGroup(pDepo_MyShots001_);

    pLaserChipDepo_ = NEW LaserChipDepository("MyRotLaser");
    MyStraightLaserChip001* pChip;
    for (int i = 0; i < 60; i++) { //[U[XgbN
        std::string name = "MyStraightLaserChip001("+XTOS(i)+")";
        pChip = NEW MyStraightLaserChip001(name.c_str());
        pChip->setPositionSource(this); //ʒu
        pLaserChipDepo_->put(pChip);
    }
    addSubGroup(pLaserChipDepo_);

    //bNIRg[[
    pLockonCtrler_ = NEW MyLockonController("MySHipLockonController");
    addSubGroup(pLockonCtrler_);

    //tHgRg[[
    pTorpedoCtrler_ = NEW MyTorpedoController("TorpedoController", this, pLockonCtrler_);
    addSubGroup(pTorpedoCtrler_);

    pEffectTurbo001_ = NEW EffectTurbo001("EffectTurbo001");
    addSubGroup(pEffectTurbo001_);
//    pEffectTurbo002_ = NEW EffectTurbo002("EffectTurbo002");
//    addSubGroup(pEffectTurbo002_);

    pMyMagicEnergyCore_ = NEW MyMagicEnergyCore("MyMagicEnergyCore");
    addSubGroup(pMyMagicEnergyCore_);

    //g[Xp
    pRing_MyShipGeoHistory4OptCtrler_ = NEW GgafLinkedListRing<GgafDxGeoElem>();
    pRing_MyShipGeoHistory2_ = NEW GgafLinkedListRing<GgafDxGeoElem>();
//    pRing_MyShipGeoOffsetHistory_ = NEW GgafLinkedListRing<GgafDxGeoElem>();
    for (uint32_t i = 0; i < 300; i++) {
        pRing_MyShipGeoHistory4OptCtrler_->addLast(NEW GgafDxGeoElem(this));
        pRing_MyShipGeoHistory2_->addLast(NEW GgafDxGeoElem(0,0,0));
//        pRing_MyShipGeoOffsetHistory_->addLast(NEW GgafDxGeoElem(this));
    }
    pRing_MyShipGeoHistory4OptCtrler_->indexedValue();
    pRing_MyShipGeoHistory2_->indexedValue();

    //X, Y    ̃XCb`ŁAʂ28o[EEEŁA
    //X, Y, Z ̃XCb`ŁA326o[lB
    //
    //     X   Y   Z
    //    -----------
    //    -1  -1  -1
    //     0   0   0    ̑Ŝ+13iň
    //    +1  +1  +1

    //ꂼ̃XCb`̏Ԃɉ̊֐e[uzB
    ////////////// X  Y  Z
    paFuncMove[TN(-1,-1,-1)] = &MyShip::move_WAY_ZRIGHT_DOWN_BEHIND;   //TN(-1,-1,-1) =  WAY_ZRIGHT_DOWN_BEHIND  = 0
    paFuncMove[TN(-1,-1, 0)] = &MyShip::move_WAY_DOWN_BEHIND;          //TN(-1,-1, 0) =  WAY_DOWN_BEHIND         = 1
    paFuncMove[TN(-1,-1, 1)] = &MyShip::move_WAY_ZLEFT_DOWN_BEHIND;    //TN(-1,-1, 1) =  WAY_ZLEFT_DOWN_BEHIND   = 2
    paFuncMove[TN(-1, 0,-1)] = &MyShip::move_WAY_ZRIGHT_BEHIND;        //TN(-1, 0,-1) =  WAY_ZRIGHT_BEHIND       = 3
    paFuncMove[TN(-1, 0, 0)] = &MyShip::move_WAY_BEHIND;               //TN(-1, 0, 0) =  WAY_BEHIND              = 4
    paFuncMove[TN(-1, 0, 1)] = &MyShip::move_WAY_ZLEFT_BEHIND;         //TN(-1, 0, 1) =  WAY_ZLEFT_BEHIND        = 5
    paFuncMove[TN(-1, 1,-1)] = &MyShip::move_WAY_ZRIGHT_UP_BEHIND;     //TN(-1, 1,-1) =  WAY_ZRIGHT_UP_BEHIND    = 6
    paFuncMove[TN(-1, 1, 0)] = &MyShip::move_WAY_UP_BEHIND;            //TN(-1, 1, 0) =  WAY_UP_BEHIND           = 7
    paFuncMove[TN(-1, 1, 1)] = &MyShip::move_WAY_ZLEFT_UP_BEHIND;      //TN(-1, 1, 1) =  WAY_ZLEFT_UP_BEHIND     = 8
    paFuncMove[TN( 0,-1,-1)] = &MyShip::move_WAY_ZRIGHT_DOWN;          //TN( 0,-1,-1) =  WAY_ZRIGHT_DOWN         = 9
    paFuncMove[TN( 0,-1, 0)] = &MyShip::move_WAY_DOWN;                 //TN( 0,-1, 0) =  WAY_DOWN                = 10
    paFuncMove[TN( 0,-1, 1)] = &MyShip::move_WAY_ZLEFT_DOWN;           //TN( 0,-1, 1) =  WAY_ZLEFT_DOWN          = 11
    paFuncMove[TN( 0, 0,-1)] = &MyShip::move_WAY_ZRIGHT;               //TN( 0, 0,-1) =  WAY_ZRIGHT              = 12
    paFuncMove[TN( 0, 0, 0)] = &MyShip::move_WAY_NONE;                 //TN( 0, 0, 0) =  WAY_NONE                = 13
    paFuncMove[TN( 0, 0, 1)] = &MyShip::move_WAY_ZLEFT;                //TN( 0, 0, 1) =  WAY_ZLEFT               = 14
    paFuncMove[TN( 0, 1,-1)] = &MyShip::move_WAY_ZRIGHT_UP;            //TN( 0, 1,-1) =  WAY_ZRIGHT_UP           = 15
    paFuncMove[TN( 0, 1, 0)] = &MyShip::move_WAY_UP;                   //TN( 0, 1, 0) =  WAY_UP                  = 16
    paFuncMove[TN( 0, 1, 1)] = &MyShip::move_WAY_ZLEFT_UP;             //TN( 0, 1, 1) =  WAY_ZLEFT_UP            = 17
    paFuncMove[TN( 1,-1,-1)] = &MyShip::move_WAY_ZRIGHT_DOWN_FRONT;    //TN( 1,-1,-1) =  WAY_ZRIGHT_DOWN_FRONT   = 18
    paFuncMove[TN( 1,-1, 0)] = &MyShip::move_WAY_DOWN_FRONT;           //TN( 1,-1, 0) =  WAY_DOWN_FRONT          = 19
    paFuncMove[TN( 1,-1, 1)] = &MyShip::move_WAY_ZLEFT_DOWN_FRONT;     //TN( 1,-1, 1) =  WAY_ZLEFT_DOWN_FRONT    = 20
    paFuncMove[TN( 1, 0,-1)] = &MyShip::move_WAY_ZRIGHT_FRONT;         //TN( 1, 0,-1) =  WAY_ZRIGHT_FRONT        = 21
    paFuncMove[TN( 1, 0, 0)] = &MyShip::move_WAY_FRONT;                //TN( 1, 0, 0) =  WAY_FRONT               = 22
    paFuncMove[TN( 1, 0, 1)] = &MyShip::move_WAY_ZLEFT_FRONT;          //TN( 1, 0, 1) =  WAY_ZLEFT_FRONT         = 23
    paFuncMove[TN( 1, 1,-1)] = &MyShip::move_WAY_ZRIGHT_UP_FRONT;      //TN( 1, 1,-1) =  WAY_ZRIGHT_UP_FRONT     = 24
    paFuncMove[TN( 1, 1, 0)] = &MyShip::move_WAY_UP_FRONT;             //TN( 1, 1, 0) =  WAY_UP_FRONT            = 25
    paFuncMove[TN( 1, 1, 1)] = &MyShip::move_WAY_ZLEFT_UP_FRONT;       //TN( 1, 1, 1) =  WAY_ZLEFT_UP_FRONT      = 26

    paFuncTurbo[TN(-1,-1,-1)] = &MyShip::turbo_WAY_ZRIGHT_DOWN_BEHIND;   //TN(-1,-1,-1) =  WAY_ZRIGHT_DOWN_BEHIND  = 0
    paFuncTurbo[TN(-1,-1, 0)] = &MyShip::turbo_WAY_DOWN_BEHIND;          //TN(-1,-1, 0) =  WAY_DOWN_BEHIND         = 1
    paFuncTurbo[TN(-1,-1, 1)] = &MyShip::turbo_WAY_ZLEFT_DOWN_BEHIND;    //TN(-1,-1, 1) =  WAY_ZLEFT_DOWN_BEHIND   = 2
    paFuncTurbo[TN(-1, 0,-1)] = &MyShip::turbo_WAY_ZRIGHT_BEHIND;        //TN(-1, 0,-1) =  WAY_ZRIGHT_BEHIND       = 3
    paFuncTurbo[TN(-1, 0, 0)] = &MyShip::turbo_WAY_BEHIND;               //TN(-1, 0, 0) =  WAY_BEHIND              = 4
    paFuncTurbo[TN(-1, 0, 1)] = &MyShip::turbo_WAY_ZLEFT_BEHIND;         //TN(-1, 0, 1) =  WAY_ZLEFT_BEHIND        = 5
    paFuncTurbo[TN(-1, 1,-1)] = &MyShip::turbo_WAY_ZRIGHT_UP_BEHIND;     //TN(-1, 1,-1) =  WAY_ZRIGHT_UP_BEHIND    = 6
    paFuncTurbo[TN(-1, 1, 0)] = &MyShip::turbo_WAY_UP_BEHIND;            //TN(-1, 1, 0) =  WAY_UP_BEHIND           = 7
    paFuncTurbo[TN(-1, 1, 1)] = &MyShip::turbo_WAY_ZLEFT_UP_BEHIND;      //TN(-1, 1, 1) =  WAY_ZLEFT_UP_BEHIND     = 8
    paFuncTurbo[TN( 0,-1,-1)] = &MyShip::turbo_WAY_ZRIGHT_DOWN;          //TN( 0,-1,-1) =  WAY_ZRIGHT_DOWN         = 9
    paFuncTurbo[TN( 0,-1, 0)] = &MyShip::turbo_WAY_DOWN;                 //TN( 0,-1, 0) =  WAY_DOWN                = 10
    paFuncTurbo[TN( 0,-1, 1)] = &MyShip::turbo_WAY_ZLEFT_DOWN;           //TN( 0,-1, 1) =  WAY_ZLEFT_DOWN          = 11
    paFuncTurbo[TN( 0, 0,-1)] = &MyShip::turbo_WAY_ZRIGHT;               //TN( 0, 0,-1) =  WAY_ZRIGHT              = 12
    paFuncTurbo[TN( 0, 0, 0)] = &MyShip::turbo_WAY_NONE;                 //TN( 0, 0, 0) =  WAY_NONE                = 13
    paFuncTurbo[TN( 0, 0, 1)] = &MyShip::turbo_WAY_ZLEFT;                //TN( 0, 0, 1) =  WAY_ZLEFT               = 14
    paFuncTurbo[TN( 0, 1,-1)] = &MyShip::turbo_WAY_ZRIGHT_UP;            //TN( 0, 1,-1) =  WAY_ZRIGHT_UP           = 15
    paFuncTurbo[TN( 0, 1, 0)] = &MyShip::turbo_WAY_UP;                   //TN( 0, 1, 0) =  WAY_UP                  = 16
    paFuncTurbo[TN( 0, 1, 1)] = &MyShip::turbo_WAY_ZLEFT_UP;             //TN( 0, 1, 1) =  WAY_ZLEFT_UP            = 17
    paFuncTurbo[TN( 1,-1,-1)] = &MyShip::turbo_WAY_ZRIGHT_DOWN_FRONT;    //TN( 1,-1,-1) =  WAY_ZRIGHT_DOWN_FRONT   = 18
    paFuncTurbo[TN( 1,-1, 0)] = &MyShip::turbo_WAY_DOWN_FRONT;           //TN( 1,-1, 0) =  WAY_DOWN_FRONT          = 19
    paFuncTurbo[TN( 1,-1, 1)] = &MyShip::turbo_WAY_ZLEFT_DOWN_FRONT;     //TN( 1,-1, 1) =  WAY_ZLEFT_DOWN_FRONT    = 20
    paFuncTurbo[TN( 1, 0,-1)] = &MyShip::turbo_WAY_ZRIGHT_FRONT;         //TN( 1, 0,-1) =  WAY_ZRIGHT_FRONT        = 21
    paFuncTurbo[TN( 1, 0, 0)] = &MyShip::turbo_WAY_FRONT;                //TN( 1, 0, 0) =  WAY_FRONT               = 22
    paFuncTurbo[TN( 1, 0, 1)] = &MyShip::turbo_WAY_ZLEFT_FRONT;          //TN( 1, 0, 1) =  WAY_ZLEFT_FRONT         = 23
    paFuncTurbo[TN( 1, 1,-1)] = &MyShip::turbo_WAY_ZRIGHT_UP_FRONT;      //TN( 1, 1,-1) =  WAY_ZRIGHT_UP_FRONT     = 24
    paFuncTurbo[TN( 1, 1, 0)] = &MyShip::turbo_WAY_UP_FRONT;             //TN( 1, 1, 0) =  WAY_UP_FRONT            = 25
    paFuncTurbo[TN( 1, 1, 1)] = &MyShip::turbo_WAY_ZLEFT_UP_FRONT;       //TN( 1, 1, 1) =  WAY_ZLEFT_UP_FRONT      = 26

    _pSeTx->set(SE_DAMAGED, "WAVE_MY_DAMAGED_001");
    _pSeTx->set(SE_EXPLOSION, "WAVE_MY_SE_EXPLOSION_001");
    _pSeTx->set(SE_TURBO, "WAVE_MY_TURBO_001");
    _pSeTx->set(SE_FIRE_LASER,   "WAVE_MY_FIRE_LASER_001");
    _pSeTx->set(SE_FIRE_SHOT,    "WAVE_MY_FIRE_SHOT_001");
    _pSeTx->set(SE_FIRE_TORPEDO, "WAVE_MY_FIRE_TORPEDO_001");

    veloTurboTop_ = 30000;
    veloTurboBottom_ = 10000;

    frame_soft_rapidshot_ = 0;
    is_being_soft_rapidshot_ = false;
    just_shot_ = false;
    is_shooting_laser_ = false;
    can_shoot_laser_ = false;
    frame_shot_pressed_ = 0;

    can_control_ = true;
    is_diving_ = false;

    blown_veloX_ = 0;
    blown_veloY_ = 0;
    blown_veloZ_ = 0;
    way_ = WAY_NONE;
    prev_way_ = WAY_NONE;
    stc_ = VB_NEUTRAL_STC;
    is_just_change_way_ = true;

    //MPl
    mp_ = MY_SHIP_START_MP;
    //mp_ςƁAQƂ MpBar ̕\Aĕς

    //Vreath͎l _pStatus STAT_StaminalQƂ悤ɐݒB
//    vreath_.link( &(_pStatus->_paValue[STAT_Stamina]._int_val) );
    //STAT_Stamina΁Avreath_ ωAQƂ VreathBar ̕\Aĕς

    //@[^[ݒu
    pMagicMeter_ = NEW MagicMeter("MagicMeter", &mp_, &(_pStatus->_paValue[STAT_Stamina]._int_val) );
    pMagicMeter_->position(PX_C(100), PX_C(PROPERTY::GAME_BUFFER_HEIGHT) - (pMagicMeter_->height_) - PX_C(16+16+16));
    addSubGroup(pMagicMeter_);

    r_blown_velo_attenuate_ = 0.8;

    invincible_frames_ = 0;

    trace_delay_count_ = 0;
    is_trace_waiting_ = false;
}
void MyShip::onCreateModel() {
    _pModel->setSpecular(5.0, 1.0);
}

void MyShip::initialize() {
    _TRACE_("MyShip::initialize()");

    //ʂɐU蕪
//    getSceneDirector()->addSubGroup(KIND_MY_SHOT_NOMAL, pDepo_MyShots001_->extract());
//    getSceneDirector()->addSubGroup(KIND_MY_SHOT_NOMAL, pDepo_MyWaves001_->extract());
    //getSceneDirector()->addSubGroup(KIND_MY_SHOT_NOMAL, pLaserChipDepo_->extract());

    setHitAble(true);
    _pColliChecker->makeCollision(1);
//    _pColliChecker->setColliSphere(0, -100000, -50000, 20000, 100000);
// _pColliChecker->setColliAAB(0, -100000, -50000, 20000, 10000, 40000, 80000);
      _pColliChecker->setColliAAB_Cube(0, 40000);
//    _pColliChecker->setColliSphere(1, 0,-100000,0, 30000, true, true, true);
//    _pColliChecker->setColliSphere(2, 0,100000,0, 30000, true, true, true);
//    _pColliChecker->setColliSphere(3, 0,0,-100000, 30000, true, true, true);
//    _pColliChecker->setColliSphere(4, 0,0,100000, 30000, true, true, true);

    _pKuroko->setMvVelo(0);

    //setMaterialColor(1.0, 0.5, 0.5);
    setAlpha(1.0);

    pAxsMver_->forceVxyzMvVeloRange(-veloTurboTop_, veloTurboTop_);
    pAxsMver_->setZeroVxyzMvAcce();
    //        _pKuroko->forceMvVeloRange(iMvBtmVelo_MT_, veloBeginMT_);
    //        _pKuroko->addMvVelo(veloBeginMT_);  //xǉ
    //        _pKuroko->setMvAcce(acce_MT_);

    _pKuroko->setFaceAngVelo(AXIS_X, 300);
}


void MyShip::onReset() {
    _TRACE_("MyShip::onReset()");
    frame_soft_rapidshot_ = 0;
    is_being_soft_rapidshot_ = false;
    just_shot_ = false;
    is_shooting_laser_ = false;
    can_shoot_laser_ = false;
    frame_shot_pressed_ = 0;
    _x = _y = _z = 0;
    way_ = WAY_NONE;
    prev_way_ = WAY_NONE;
    way_switch_.reset();

    mp_ = MY_SHIP_START_MP;
    _pStatus->reset();

    setInvincibleFrames(60 * 10); //oꎞ̖G
}

void MyShip::onActive() {
    _TRACE_("MyShip::onActive()");
    //[U[⃍bN^[Qbg⋛Tuɂ邽
    //ʂɌĂяo
    pLockonCtrler_->onActive();
    pTorpedoCtrler_->onActive();
}
void MyShip::onInactive() {
    _TRACE_("MyShip::onInactive()");
    //[U[⃍bN^[Qbg⋛Tuɂ邽
    //ʂɌĂяo
    pLockonCtrler_->onInactive();
    pTorpedoCtrler_->onInactive();
//    pLaserChipDepo_->reset();
}
void MyShip::processBehavior() {
    VirtualButton* pVbPlay = VB_PLAY;
    int pos_camera = P_VAM->pos_camera_;

    //VAMSystem̎
    // (Viewpoint Adaptive Moving System _K^ړVXe)
    stc_ = pVbPlay->getBeingPressedStick();
    if (pos_camera == VAM_POS_RIGHT) {
        //ETChr[(E獶փXN[)
        if (pVbPlay->isPushedDown(VB_UP)) {     // 
            way_switch_.ON_UP(SW_NOP, SW_ADD, SW_NOP);    //
        }
        if (pVbPlay->isPushedDown(VB_RIGHT)) {  // 
            way_switch_.ON_RIGHT(SW_ADD, SW_NOP, SW_NOP); //O
        }
        if (pVbPlay->isPushedDown(VB_LEFT)) {   // 
            way_switch_.ON_LEFT(SW_SUB, SW_NOP, SW_NOP);  //
        }
        if (pVbPlay->isPushedDown(VB_DOWN)) {   // 
            way_switch_.ON_DOWN(SW_NOP, SW_SUB, SW_NOP);  //
        }
    } else if (pos_camera == VAM_POS_LEFT) {
        //TChr[(EփXN[)
        if (pVbPlay->isPushedDown(VB_UP)) {     // 
            way_switch_.ON_UP(SW_NOP, SW_ADD, SW_NOP);    //
        }
        if (pVbPlay->isPushedDown(VB_RIGHT)) {  // 
            way_switch_.ON_RIGHT(SW_SUB, SW_NOP, SW_NOP); //
        }
        if (pVbPlay->isPushedDown(VB_LEFT)) {   // 
            way_switch_.ON_LEFT(SW_ADD, SW_NOP, SW_NOP);  //O
        }
        if (pVbPlay->isPushedDown(VB_DOWN)) {   // 
            way_switch_.ON_DOWN(SW_NOP, SW_SUB, SW_NOP);  //
        }
    } else if (pos_camera == VAM_POS_TOP) {
        //gbvr[(ォ牺փXN[)
        if (pVbPlay->isPushedDown(VB_UP)) {     // 
            way_switch_.ON_UP(SW_ADD, SW_NOP, SW_NOP);    //O
        }
        if (pVbPlay->isPushedDown(VB_RIGHT)) {  // 
            way_switch_.ON_RIGHT(SW_NOP, SW_NOP, SW_SUB); //E
        }
        if (pVbPlay->isPushedDown(VB_LEFT)) {   // 
            way_switch_.ON_LEFT(SW_NOP, SW_NOP, SW_ADD);  //
        }
        if (pVbPlay->isPushedDown(VB_DOWN)) {   // 
            way_switch_.ON_DOWN(SW_SUB, SW_NOP, SW_NOP);  //
        }
    } else if (pos_camera == VAM_POS_BOTTOM) {
        //{gr[(փXN[)
        if (pVbPlay->isPushedDown(VB_UP)) {     // 
            way_switch_.ON_UP(SW_SUB, SW_NOP, SW_NOP);    //
        }
        if (pVbPlay->isPushedDown(VB_RIGHT)) {  // 
            way_switch_.ON_RIGHT(SW_NOP, SW_NOP, SW_SUB); //E
        }
        if (pVbPlay->isPushedDown(VB_LEFT)) {   // 
            way_switch_.ON_LEFT(SW_NOP, SW_NOP, SW_ADD);  //
        }
        if (pVbPlay->isPushedDown(VB_DOWN)) {   // 
            way_switch_.ON_DOWN(SW_ADD, SW_NOP, SW_NOP);  //O
        }
    } else if (pos_camera > VAM_POS_TO_BEHIND) {
        //wr[iOɃXN[j
        if (pVbPlay->isPushedDown(VB_UP)) {     // 
            way_switch_.ON_UP(SW_NOP, SW_ADD, SW_NOP);    //
        }
        if (pVbPlay->isPushedDown(VB_RIGHT)) {  // 
            way_switch_.ON_RIGHT(SW_NOP, SW_NOP, SW_SUB); //E
        }
        if (pVbPlay->isPushedDown(VB_LEFT)) {   // 
            way_switch_.ON_LEFT(SW_NOP, SW_NOP, SW_ADD);  //
        }
        if (pVbPlay->isPushedDown(VB_DOWN)) {   // 
            way_switch_.ON_DOWN(SW_NOP, SW_SUB, SW_NOP);  //
        }
    }
    if (pVbPlay->isReleasedUp(VB_UP)) {
        way_switch_.OFF_UP();    //  𗣂
    }
    if (pVbPlay->isReleasedUp(VB_RIGHT)) {
        way_switch_.OFF_RIGHT(); //  𗣂
    }
    if (pVbPlay->isReleasedUp(VB_LEFT)) {
        way_switch_.OFF_LEFT();  //  𗣂
    }
    if (pVbPlay->isReleasedUp(VB_DOWN)) {
        way_switch_.OFF_DOWN();  //  𗣂
    }

    //way_switch_XCb`ĂȂƁApVbPlay(isPushedDown,isReleasedUp) 肪
    //ƍ
    //Ȃ̂łreturn
    //싑
    if (!can_control_) {
        return;
    }

    MoveWay prev_way = way_;
    way_ = (MoveWay)(way_switch_.getIndex()); //Llꂽl
    if (prev_way != way_) {
        is_just_change_way_ = true;
    } else {
        is_just_change_way_ = false;
    }

    if (_pStatus->get(STAT_Stamina) < 0) {
        //؂
    } else {
        if (pVbPlay->isBeingPressed(VB_OPTION)) {
            int tmp = iMoveSpeed_;
            iMoveSpeed_ /= 8; //IvV쒆ړ͒x
            (this->*paFuncMove[way_])();   //lɉړ\bhĂяo
            iMoveSpeed_ = tmp;
        } else {
            (this->*paFuncMove[way_])();   //lɉړ\bhĂяo
        }

        if (pVbPlay->isPushedDown(VB_TURBO)) {
            UTIL::activateProperEffect01Of(this); //^[{JñGtFNg
            (this->*paFuncTurbo[way_])(); //lɉ^[{Jn\bhĂяo
            _pSeTx->play3D(SE_TURBO);
        } else {
            //Not^[{Jn
            if (pVbPlay->isBeingPressed(VB_TURBO)) {
                //^[{{^邱ƂŁAx₩ɂȂA
                //ړL΂
                pAxsMver_->_veloVxMv *= 0.96;
                pAxsMver_->_veloVyMv *= 0.96;
                pAxsMver_->_veloVzMv *= 0.96;
            } else {
                //^[{𗣂ꍇAxB
                pAxsMver_->_veloVxMv *= 0.75;
                pAxsMver_->_veloVyMv *= 0.75;
                pAxsMver_->_veloVzMv *= 0.75;
            }
        }
    }

    //Xs悭ĂȂΑx߂
    angvelo MZ = angRxTopVelo_MZ_-3000; //3000͒ʏ񎞂ɑx߂angRxTopVelo_MZ_𒴂Ȃ悤ɂ邽߁AOŌƌӖiTODO:vjB
    if (_pKuroko->_angveloFace[AXIS_X] >= MZ) {
        _pKuroko->_angveloFace[AXIS_X] *= 0.93;
        //_pKuroko->setFaceAngAcce(AXIS_X, -1*angRxAcce_MZ_*2);
    } else if (_pKuroko->_angveloFace[AXIS_X] <= -MZ) {
        _pKuroko->_angveloFace[AXIS_X] *= 0.93;
        //_pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_*2);
    }

    //ZɈړłȂꍇA@̂𐅕ɂiA悭ĂȂꍇɌBsetStopTargetFaceAng̑4px邢ꍇ󂯓j
    if (way_switch_.way_.Z == 0) {
        angle dist = _pKuroko->getFaceAngDistance(AXIS_X, 0, TURN_CLOSE_TO);
        if (0 <= dist && dist < D180ANG) {
            _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_);
        } else if (-1*D180ANG < dist && dist < 0) {
            _pKuroko->setFaceAngAcce(AXIS_X, -1*angRxAcce_MZ_);
        }
        _pKuroko->setMvAcce(0);
        _pKuroko->setStopTargetFaceAng(AXIS_X, 0, TURN_BOTH, angRxTopVelo_MZ_);
    }

    ////////////////////////////////////////////////////

    //Wɔf
    _pKuroko->behave();
    pAxsMver_->behave();
    _pSeTx->behave();

    if (invincible_frames_ > 0) {
        setHitAble(false);
        invincible_frames_ --;
        if (getActiveFrame() % 2 == 0) {
            setAlpha(0.6);
        } else {
            setAlpha(0);
        }
        if (invincible_frames_ == 0) {
            setHitAble(true);
            setAlpha(1.0);
        }
    } else {

    }
    //
    if (ABS(blown_veloX_) < PX_C(1)) {
        blown_veloX_ = 0;
    } else {
        _x += blown_veloX_;
        blown_veloX_ *= r_blown_velo_attenuate_;
    }
    if (ABS(blown_veloY_) < PX_C(1)) {
        blown_veloY_ = 0;
    } else {
        _y += blown_veloY_;
        blown_veloY_ *= r_blown_velo_attenuate_;
    }
    if (ABS(blown_veloZ_) < PX_C(1)) {
        blown_veloZ_ = 0;
    } else {
        _z += blown_veloZ_;
        blown_veloZ_ *= r_blown_velo_attenuate_;
    }


    if (is_diving_) {
        //˓[V́Aړ͈͐䖳
    } else {
        //ʏړ͈͐
        if (_y > MyShip::lim_y_top_) {
            _y = MyShip::lim_y_top_;
        } else if (_y < MyShip::lim_y_bottom_ ) {
            _y = MyShip::lim_y_bottom_;
        }

        if (_x > MyShip::lim_x_front_) {
            _x = MyShip::lim_x_front_;
        } else if (_x < MyShip::lim_x_behaind_) {
            _x = MyShip::lim_x_behaind_;
        }

        if (_z > MyShip::lim_z_left_) {
            _z = MyShip::lim_z_left_;
        } else if (_z < MyShip::lim_z_right_) {
            _z = MyShip::lim_z_right_;
        }
    }


    //IvV̂߂ɍWۑ
    pRing_MyShipGeoHistory2_->next()->set(this);
    if (pVbPlay->isBeingPressed(VB_OPTION)) {
        GgafDxGeoElem* pGeoMyShipPrev = pRing_MyShipGeoHistory2_->getPrev();
        //(_x_local, _y_local, _z_local) ́Aʒu(0,0,0) A
        //VB_OPTIONĂԂ݈̂ړWێB
        _x_local += (_x - pGeoMyShipPrev->x); //ړ
        _y_local += (_y - pGeoMyShipPrev->y);
        _z_local += (_z - pGeoMyShipPrev->z);
    } else {
        //(_x_local, _y_local, _z_local) VB_OPTION𗣂̏ʒu(0,0,0) ̑W͂ĂB
        //āApRing_MyShipGeoHistory4OptCtrler_́A
        //@̐΍WAVB_OPTION ꍇ̑WOړWi΍WjƂȂB
        //̗̍W(_x_local, _y_local, _z_local) (_x_local, _y_local, _z_local)W𑫂΁A@̍WƓl
        GgafDxGeoElem* pGeo = pRing_MyShipGeoHistory4OptCtrler_->getCurrent();
        if (pGeo->x == _x - _x_local && pGeo->y == _y - _y_local && pGeo->z == _z - _z_local) {
            //ړĂȂꍇ
            trace_delay_count_++;
            if (trace_delay_count_ > TRACE_DELAY_WAIT_FRAME) { //1bԃg[XȏԂێł悤ɂB
                pRing_MyShipGeoHistory4OptCtrler_->next()->set(_x - _x_local,
                                                               _y - _y_local,
                                                               _z - _z_local );
                is_trace_waiting_ = false;
            } else {
                is_trace_waiting_ = true;
            }
        } else {
            trace_delay_count_ = 0;
            pRing_MyShipGeoHistory4OptCtrler_->next()->set(_x - _x_local,
                                                           _y - _y_local,
                                                           _z - _z_local );
            is_trace_waiting_ = false;
        }
    }

    //t[̌ċz̏
    _pStatus->minus(STAT_Stamina, MY_SHIP_VREATH_COST);
}

void MyShip::processJudgement() {
    if (!can_control_) {
        return;
    }
    VirtualButton* pVbPlay = VB_PLAY;



    //debug ---->
//    if (GgafDxInput::isPushedDownKey(DIK_W)) {
//        TestGuShot* pShot = (TestGuShot*)pDepo_TestGuShot_->dispatch();
//        if (pShot) {
//            pShot->positionAs(this);
//        }
//    }
//    if (GgafDxInput::isPushedDownKey(DIK_E)) {
//        TestChokiShot* pShot = (TestChokiShot*)pDepo_TestChokiShot_->dispatch();
//        if (pShot) {
//            pShot->positionAs(this);
//        }
//    }
//    if (GgafDxInput::isPushedDownKey(DIK_R)) {
//        TestPaShot* pShot = (TestPaShot*)pDepo_TestPaShot_->dispatch();
//        if (pShot) {
//            pShot->positionAs(this);
//        }
//    }
//    if (GgafDxInput::isPushedDownKey(DIK_T)) {
//        TestNomalShot* pShot = (TestNomalShot*)pDepo_TestNomalShot_->dispatch();
//        if (pShot) {
//            pShot->positionAs(this);
//        }
//    }
    //<---- debug


    //debug ---->
//#ifdef MY_DEBUG
//    if (GgafDxInput::isPushedDownKey(DIK_W)) {
//        MyStraightLaserChip001::chengeTex(0);
//    }
//    if (GgafDxInput::isPushedDownKey(DIK_E)) {
//        MyStraightLaserChip001::chengeTex(1);
//    }
//    if (GgafDxInput::isPushedDownKey(DIK_R)) {
//        MyStraightLaserChip001::chengeTex(2);
//    }
//#endif
    //<---- debug


    //@ŃeXg
//    if (pVbPlay->isBeingPressed(VB_BUTTON8)) {
//        _TRACE_("@ŃeXg");
//        throwEventUpperTree(EVENT_MY_SHIP_WAS_DESTROYED_BEGIN);
//    }



    //Vbg֘A
    is_shooting_laser_ = false;
    if (pVbPlay->isBeingPressed(VB_SHOT1)) {
        frame_shot_pressed_ ++;
        if (can_shoot_laser_) {
            if (frame_shot_pressed_ > 30) { //30t[ςȂŃ[U[
                is_shooting_laser_ = true;
            }
        }
    } else {
        frame_shot_pressed_ = 0;
        pLockonCtrler_->releaseAllLockon(); //bNI
    }

    //[U[
    if (is_shooting_laser_) {
        if (pVbPlay->isBeingPressed(VB_SHOT1)) {
            LaserChip* pLaserChip = pLaserChipDepo_->dispatch();
            if (pLaserChip) {
                if (pLaserChip->_pChip_front == nullptr) {
                    _pSeTx->play3D(SE_FIRE_LASER);
                }
            }
        } else {

        }
    }

    //\tgA
    //1vbV4Fɍő3
    if (pVbPlay->isPushedDown(VB_SHOT1) && !pVbPlay->isBeingPressed(VB_POWERUP)) {
        is_being_soft_rapidshot_ = true;
        if (frame_soft_rapidshot_ >= SOFT_RAPIDSHOT_INTERVAL) {
            //SOFT_RAPIDSHOT_INTERVAL t[xꍇ
            //A˂ƘA˂̂Ȃڂ悤ɂ
            frame_soft_rapidshot_ = frame_soft_rapidshot_ % SOFT_RAPIDSHOT_INTERVAL;
        } else {
            //SOFT_RAPIDSHOT_INTERVAL t[葬A˂̏ꍇ
            //󂯓ċIɔ˂ł(蓮A˂̂قA˂ł悤ɂB)
            frame_soft_rapidshot_ = 0;
        }
    }
    just_shot_ = false;
    if (is_being_soft_rapidshot_) {
        if (frame_soft_rapidshot_ % SOFT_RAPIDSHOT_INTERVAL == 0) {
            just_shot_ = true;//Vbg܂tO
            MyShot001* pShot = (MyShot001*)pDepo_MyShots001_->dispatch();
            if (pShot) {
                _pSeTx->play3D(SE_FIRE_SHOT);
                pShot->positionAs(this);
            }
            if (frame_soft_rapidshot_ >= SOFT_RAPIDSHOT_INTERVAL*(SOFT_RAPIDSHOT_NUM-1)) {
                //SOFT_RAPIDSHOT_NUM łI\tgAˏI
                is_being_soft_rapidshot_ = false;
            }
        }
    }
    if (is_being_soft_rapidshot_) {
        frame_soft_rapidshot_++;
    }

    //q
    if (pVbPlay->isPushedDown(VB_SHOT2)) {
        if (this->pTorpedoCtrler_->fire()) {
            _pSeTx->play3D(MyShip::SE_FIRE_TORPEDO);
        }
    }

//    if (pVbPlay->isBeingPressed(VB_SHOT2)) {
//        MyOptionController** papOptCtrler = P_MYSHIP_SCENE->papOptionCtrler_;
//        for (int i = 0; i < MyOptionController::now_option_num_; i++) {
//            if (papOptCtrler[i]->pOption_->pTorpedoCtrler_->fire()) {
//                papOptCtrler[i]->pOption_->_pSeTx->play3D(MyOption::SE_FIRE_TORPEDO);
//            }
//        }
//
////        bool can_fire = true;
////        for (int i = 0; i < MyOptionController::now_option_num_; i++) {
////            if (papOptCtrler[i]->pOption_->pTorpedoCtrler_->in_firing_) {
////                can_fire = false;
////                break;
////            }
////        }
////        if (can_fire) {
////            for (int i = 0; i < MyOptionController::now_option_num_; i++) {
////                if (i == 0) {
////                    _pSeTx->play3D(3);
////                }
////                papOptCtrler[i]->pOption_->pTorpedoCtrler_->fire();
////            }
////        }
//    }

}

void MyShip::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg
    int vreath = _pStatus->get(STAT_Stamina);
    if (UTIL::calcMyStamina(this, pOther) <= 0) {
        //@J
        setHitAble(false);
        _pSeTx->play3D(SE_EXPLOSION);
        throwEventUpperTree(EVENT_MY_SHIP_WAS_DESTROYED_BEGIN);
    }
    int damage = vreath - _pStatus->get(STAT_Stamina);
    if (damage > 0) {
        pMagicMeter_->pDamageDispBar_->addDamage(damage > vreath ? vreath : damage);
    }

    //ǂ̏ꍇʂȏ
    if (pOther->getKind() & KIND_CHIKEI) {
        //ѕlB
        //݂̈ړ̋tiшЗ͂͂Q{Ɂj
        GgafDxGeoElem* pGeoMyShipPrev = pRing_MyShipGeoHistory2_->getPrev();
        float vx1,vy1,vz1;
        coord dX1 = -(_x - pGeoMyShipPrev->x);
        coord dY1 = -(_y - pGeoMyShipPrev->y);
        coord dZ1 = -(_z - pGeoMyShipPrev->z);
        if (dX1 == 0 && dY1 == 0 && dZ1 == 0) {
            vx1 = vy1 = vz1 = 0;
        } else {
            UTIL::getNormalizeVector(dX1, dY1, dZ1,
                                     vx1, vy1, vz1 );
        }
        float vx2, vy2, vz2;
        coord dX2,dY2,dZ2;
        if ( pOther->instanceOf(Obj_WallPartsActor)) {
            if ((pOther->_pChecker->_pCollisionArea->_papColliPart[0]->_shape_kind) & COLLI_AAPRISM) {
                //vY
                ColliAAPrism* pPrism = (ColliAAPrism*)(pOther->_pChecker->_pCollisionArea->_papColliPart[0]);
                int pos_prism = pPrism->_pos_prism;
                if (pos_prism & POS_PRISM_XY) {
                    if (pos_prism & POS_PRISM_pp) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        _
                        // x-     _焠   x+
                        //            _
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else if (pos_prism & POS_PRISM_np) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        ^
                        // x-   ^     x+
                        //        ^    
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else if (pos_prism & POS_PRISM_pn) {
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //            ^
                        // x-     ^   x+
                        //        ^焠
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    } else { // ̂ POS_PRISM_nn
                        //             y+
                        // (_x1,_y2)      (_x2,_y2)
                        //        
                        //        _    
                        // x-   _     x+
                        //        _
                        //        
                        // (_x1,_y1)      (_x2,_y1)
                        //             y-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z               ));
                    }

                } else if (pos_prism & POS_PRISM_YZ) {

                    if (pos_prism & POS_PRISM_pp) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        _
                        // y-     _焠   y+
                        //            _
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_prism & POS_PRISM_np) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        ^
                        // y-   ^     y+
                        //        ^    
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_prism & POS_PRISM_pn) {
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //            ^
                        // y-     ^   y+
                        //        ^焠
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y + pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    } else { // ̂ POS_PRISM_nn
                        //             z+
                        // (_y1,_z2)      (_y2,_z2)
                        //        
                        //        _    
                        // y-   _     y+
                        //        _
                        //        
                        // (_y1,_z1)      (_y2,_z1)
                        //             z-
                        dX2 = (_x - (pOther->_x               ));
                        dY2 = (_y - (pOther->_y - pPrism->_hdy));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    }

                } else if (pos_prism & POS_PRISM_ZX) {
                    if (pos_prism & POS_PRISM_pp) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        _
                        // z-     _焠   z+
                        //            _
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else if (pos_prism & POS_PRISM_np) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        ^
                        // z-   ^     z+
                        //        ^    
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x + pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    } else if (pos_prism & POS_PRISM_pn) {
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //            ^
                        // z-     ^   z+
                        //        ^焠
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y               ));
                        dZ2 = (_z - (pOther->_z + pPrism->_hdz));
                    } else { // ̂ POS_PRISM_nn
                        //             x+
                        // (_z1,_x2)      (_z2,_x2)
                        //        
                        //        _    
                        // z-   _     z+
                        //        _
                        //        
                        // (_z1,_x1)      (_z2,_x1)
                        //             x-
                        dX2 = (_x - (pOther->_x - pPrism->_hdx));
                        dY2 = (_y - (pOther->_y                ));
                        dZ2 = (_z - (pOther->_z - pPrism->_hdz));
                    }
                } else {

                }
            } else {
                //vYȊO̕
                dX2 = (_x - pOther->_x);
                dY2 = (_y - pOther->_y);
                dZ2 = (_z - pOther->_z);
            }
        } else {
            GgafDxCollisionArea* pCollisionArea = pOther->_pChecker->_pCollisionArea;
            if (pCollisionArea->_hit_colli_part_index >= 0) {
                GgafDxCollisionPart* pPart = pCollisionArea->_papColliPart[pCollisionArea->_hit_colli_part_index];
                dX2 = (_x - (pOther->_x + pPart->_cx));
                dY2 = (_y - (pOther->_y + pPart->_cy));
                dZ2 = (_z - (pOther->_z + pPart->_cz));
            } else {
                dX2 = (_x - pOther->_x);
                dY2 = (_y - pOther->_y);
                dZ2 = (_z - pOther->_z);
            }
        }

        if (dX2 == 0 && dY2 == 0 && dZ2 == 0) {
            vx2 = vy2 = vz2 = 0;
        } else {
            UTIL::getNormalizeVector(dX2, dY2, dZ2,
                                     vx2, vy2, vz2 );
        }

        float vx3, vy3, vz3;
        UTIL::getNormalizeVector(
                    vx1+vx2, vy1+vy2, vz1+vz2,
                    vx3, vy3, vz3);
        setBlownVelo(vx3*PX_C(40), vy3*PX_C(40), vz3*PX_C(40), 0.8);
        setInvincibleFrames(120);
    }
    if (pOther->getKind() & KIND_ITEM)  {
    } else {
        UTIL::activateExplosionEffectOf(this);
        _pSeTx->play3D(SE_DAMAGED);
    }
}

void MyShip::doNotingMoveInput() {

}

void MyShip::setMoveSpeedLv(int lv) {
        //lv_MoveSpeed_ = lv;
        iMoveSpeed_ = PX_C(lv);
    }

void MyShip::onCatchEvent(hashval prm_no, void* prm_pSource) {
}

void MyShip::setBlownVelo(velo prm_blown_veloX, velo prm_blown_veloY, velo prm_blown_veloZ, double prm_r_blown_velo_attenuate) {
    blown_veloX_ += prm_blown_veloX;
    blown_veloY_ += prm_blown_veloY;
    blown_veloZ_ += prm_blown_veloZ;
    r_blown_velo_attenuate_ = prm_r_blown_velo_attenuate;
}

void MyShip::setInvincibleFrames(int prm_frames) {
    setHitAble(false);
    invincible_frames_ = prm_frames;
}


void MyShip::move_WAY_NONE() {
}

void MyShip::move_WAY_UP() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D90ANG, 0);
    }
    _y += iMoveSpeed_;
}

void MyShip::move_WAY_UP_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, 0);
    }
    _y += iMoveSpeed_ * NANAME2D_RATE;
    _x += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_UP_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D135ANG, 0);
    }
    _y += iMoveSpeed_ * NANAME2D_RATE;
    _x -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(0, 0);
    }
    _x += iMoveSpeed_;
}

void MyShip::move_WAY_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D180ANG, 0);
    }
    _x -= iMoveSpeed_;
}

void MyShip::move_WAY_DOWN() {
    _pKuroko->setRzRyMvAng(D270ANG, 0);
    _y -= iMoveSpeed_;
}

void MyShip::move_WAY_DOWN_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D255ANG, 0);
    }
    _y -= iMoveSpeed_ * NANAME2D_RATE;
    _x -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_DOWN_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, 0);
    }
    _y -= iMoveSpeed_ * NANAME2D_RATE;
    _x += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZLEFT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(0, D270ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_, TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _z += iMoveSpeed_;
}

void MyShip::move_WAY_ZLEFT_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(0, D315ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, (angRxAcce_MZ_/2)); //v
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ - (angRxStop_MZ_/2), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _z += iMoveSpeed_ * NANAME2D_RATE;
    _x += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZLEFT_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D180ANG, D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, (angRxAcce_MZ_/2));
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ + (angRxStop_MZ_/2), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _z += iMoveSpeed_ * NANAME2D_RATE;
    _x -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZRIGHT_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D180ANG, D135ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/2));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ - (angRxStop_MZ_/2)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _z -= iMoveSpeed_ * NANAME2D_RATE;
    _x += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZRIGHT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(0, D90ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*angRxAcce_MZ_);
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*angRxStop_MZ_, TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _z -= iMoveSpeed_;
}

void MyShip::move_WAY_ZRIGHT_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(0, D135ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/2));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ + (angRxStop_MZ_/2)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _z -= iMoveSpeed_ * NANAME2D_RATE;
    _x -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZLEFT_UP() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D270ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/2);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ - (angRxStop_MZ_/2), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _z += iMoveSpeed_ * NANAME2D_RATE;
    _y += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZLEFT_DOWN() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D270ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/2);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ + (angRxStop_MZ_/2), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);

    }
    _z += iMoveSpeed_ * NANAME2D_RATE;
    _y -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZRIGHT_UP() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D90ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/2));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ - (angRxStop_MZ_/2)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _z -= iMoveSpeed_ * NANAME2D_RATE;
    _y += iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZRIGHT_DOWN() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D90ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/2));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ + (angRxStop_MZ_/2)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _z -= iMoveSpeed_ * NANAME2D_RATE;
    _y -= iMoveSpeed_ * NANAME2D_RATE;
}

void MyShip::move_WAY_ZLEFT_UP_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D270ANG+D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/3);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ - (angRxStop_MZ_/3), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _x += iMoveSpeed_ * NANAME3D_RATE;
    _y += iMoveSpeed_ * NANAME3D_RATE;
    _z += iMoveSpeed_ * NANAME3D_RATE;
}

void MyShip::move_WAY_ZLEFT_UP_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D270ANG-D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/3);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ - (angRxStop_MZ_/3), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);
    }
    _x -= iMoveSpeed_ * NANAME3D_RATE;
    _y += iMoveSpeed_ * NANAME3D_RATE;
    _z += iMoveSpeed_ * NANAME3D_RATE;
}

void MyShip::move_WAY_ZLEFT_DOWN_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D270ANG+D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/3);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ + (angRxStop_MZ_/3), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);

    }
    _x += iMoveSpeed_ * NANAME3D_RATE;
    _y -= iMoveSpeed_ * NANAME3D_RATE;
    _z += iMoveSpeed_ * NANAME3D_RATE;
}


void MyShip::move_WAY_ZLEFT_DOWN_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D270ANG-D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, angRxAcce_MZ_/3);
        _pKuroko->setStopTargetFaceAng(AXIS_X, angRxStop_MZ_ + (angRxStop_MZ_/3), TURN_COUNTERCLOCKWISE, angRxTopVelo_MZ_);

    }
    _x -= iMoveSpeed_ * NANAME3D_RATE;
    _y -= iMoveSpeed_ * NANAME3D_RATE;
    _z += iMoveSpeed_ * NANAME3D_RATE;
}


void MyShip::move_WAY_ZRIGHT_UP_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D90ANG-D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/3));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ - (angRxStop_MZ_/3)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _x += iMoveSpeed_ * NANAME3D_RATE;
    _y += iMoveSpeed_ * NANAME3D_RATE;
    _z -= iMoveSpeed_ * NANAME3D_RATE;
}

void MyShip::move_WAY_ZRIGHT_UP_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D45ANG, D90ANG+D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/3));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ - (angRxStop_MZ_/3)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _x -= iMoveSpeed_ * NANAME3D_RATE;
    _y += iMoveSpeed_ * NANAME3D_RATE;
    _z -= iMoveSpeed_ * NANAME3D_RATE;
}

void MyShip::move_WAY_ZRIGHT_DOWN_FRONT() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D90ANG-D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/3));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ + (angRxStop_MZ_/3)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _x += iMoveSpeed_ * NANAME3D_RATE;
    _z -= iMoveSpeed_ * NANAME3D_RATE;
    _y -= iMoveSpeed_ * NANAME3D_RATE;
}

void MyShip::move_WAY_ZRIGHT_DOWN_BEHIND() {
    if (is_just_change_way_) {
        _pKuroko->setRzRyMvAng(D315ANG, D90ANG+D45ANG);
        //
        _pKuroko->setFaceAngAcce(AXIS_X, -1*(angRxAcce_MZ_/3));
        _pKuroko->setStopTargetFaceAng(AXIS_X, -1*(angRxStop_MZ_ + (angRxStop_MZ_/3)), TURN_CLOCKWISE, angRxTopVelo_MZ_);
    }
    _x -= iMoveSpeed_ * NANAME3D_RATE;
    _z -= iMoveSpeed_ * NANAME3D_RATE;
    _y -= iMoveSpeed_ * NANAME3D_RATE;
}


/////////////////TURBO_BEGIN

void MyShip::turbo_WAY_NONE() {
}


void MyShip::turbo_WAY_UP() {
    _pKuroko->setRzRyMvAng(D90ANG, 0);
    pAxsMver_->addVyMvVelo(veloBeginMT_);
}

void MyShip::turbo_WAY_UP_FRONT() {
    _pKuroko->setRzRyMvAng(D45ANG, 0);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME2D_RATE);
}

void MyShip::turbo_WAY_UP_BEHIND() {
    _pKuroko->setRzRyMvAng(D135ANG, 0);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME2D_RATE);
}

void MyShip::turbo_WAY_FRONT() {
    _pKuroko->setRzRyMvAng(0, 0);
    pAxsMver_->addVxMvVelo(veloBeginMT_);
}

void MyShip::turbo_WAY_BEHIND() {
    _pKuroko->setRzRyMvAng(D180ANG, 0);
    pAxsMver_->addVxMvVelo(-veloBeginMT_);
}

void MyShip::turbo_WAY_DOWN() {
    _pKuroko->setRzRyMvAng(D270ANG, 0);
    pAxsMver_->addVyMvVelo(-veloBeginMT_);
}

void MyShip::turbo_WAY_DOWN_BEHIND() {
    _pKuroko->setRzRyMvAng(D255ANG, 0);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME2D_RATE);
}

void MyShip::turbo_WAY_DOWN_FRONT() {
    _pKuroko->setRzRyMvAng(D315ANG, 0);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME2D_RATE);
}

void MyShip::turbo_WAY_ZLEFT() {
    pAxsMver_->addVzMvVelo(veloBeginMT_);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_FRONT() {
    _pKuroko->setRzRyMvAng(0, D270ANG);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_BEHIND() {
    _pKuroko->setRzRyMvAng(D180ANG, D45ANG);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_FRONT() {
    _pKuroko->setRzRyMvAng(D180ANG, D135ANG);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT() {
    _pKuroko->setRzRyMvAng(0, D90ANG);
    pAxsMver_->addVzMvVelo(-veloBeginMT_);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_BEHIND() {
    _pKuroko->setRzRyMvAng(0, D135ANG);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_UP() {
    _pKuroko->setRzRyMvAng(D45ANG, D270ANG);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_DOWN() {
    _pKuroko->setRzRyMvAng(D315ANG, D270ANG);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_UP() {
    _pKuroko->setRzRyMvAng(D45ANG, D90ANG);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_DOWN() {
    _pKuroko->setRzRyMvAng(D315ANG, D90ANG);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME2D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME2D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_UP_FRONT() {
    _pKuroko->setRzRyMvAng(D45ANG, D270ANG+D45ANG);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_UP_BEHIND() {
    _pKuroko->setRzRyMvAng(D45ANG, D270ANG-D45ANG);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_DOWN_FRONT() {
    _pKuroko->setRzRyMvAng(D315ANG, D270ANG+D45ANG);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZLEFT_DOWN_BEHIND() {
    _pKuroko->setRzRyMvAng(D315ANG, D270ANG-D45ANG);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_UP_FRONT() {
    _pKuroko->setRzRyMvAng(D45ANG, D90ANG-D45ANG);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_UP_BEHIND() {
    _pKuroko->setRzRyMvAng(D45ANG, D90ANG+D45ANG);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_DOWN_FRONT() {
    _pKuroko->setRzRyMvAng(D315ANG, D90ANG-D45ANG);
    pAxsMver_->addVxMvVelo(veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

void MyShip::turbo_WAY_ZRIGHT_DOWN_BEHIND() {
    _pKuroko->setRzRyMvAng(D315ANG, D90ANG+D45ANG);
    pAxsMver_->addVxMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVzMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    pAxsMver_->addVyMvVelo(-veloBeginMT_ * NANAME3D_RATE);
    //
    _pKuroko->setFaceAngVelo(AXIS_X, -angRxVelo_BeginMZT_*NANAME3D_RATE); //悭]Jn
}

MyShip::~MyShip() {
    GGAF_DELETE(pAxsMver_);
    GGAF_DELETE(pRing_MyShipGeoHistory4OptCtrler_);
    GGAF_DELETE(pRing_MyShipGeoHistory2_);
}

