#include "stdafx.h"
#include "EffectMyOption.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/gecchi/VioletVreath/actor/my/option/MyOption.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


EffectMyOption::EffectMyOption(const char* prm_name, MyOption* prm_pOption) :
        DefaultMeshSetActor(prm_name, "8/EffectMyOption", nullptr) {
    effectBlendOne(); //ZTechniquew
    pScaler_ = NEW GgafDxScaler(this);
    pOption_ = prm_pOption;
    setZEnable(true);        //Zobt@͍lĕ`
    setZWriteEnable(false);  //Zobt@͏ݖ
    setHitAble(false);
//    setScaleR(0.1);
    useProgress(10);
}

void EffectMyOption::onCreateModel() {
    _pModel->setSpecular(5.0, 1.0);
}

void EffectMyOption::initialize() {
    _pKuroko->setFaceAngVelo(AXIS_X, D_ANG(5));
    _pKuroko->setFaceAngVelo(AXIS_Y, D_ANG(3));
    _pKuroko->setFaceAngVelo(AXIS_Z, D_ANG(1));
    pScaler_->setScale(R_SC(1));
    pScaler_->forceRange(R_SC(1), R_SC(4.0));
//    pScaler_->beat(AXIS_X, 30, 10, 1, -1);
//    pScaler_->beat(AXIS_Y, 30, 15, 1, -1);
//    pScaler_->beat(AXIS_Z, 30, 20, 1, -1);

}

void EffectMyOption::onReset() {
//    _pProg->reset(1);
}

void EffectMyOption::onActive() {

}

void EffectMyOption::processBehavior() {
//    if (_pProg->get() == 1) {
//        pScaler_->beat(30,8,2,-1);
//        _pProg->change(2);
//    }
    positionAs(pOption_);
    _pKuroko->behave();
    pScaler_->behave();
}

void EffectMyOption::processJudgement() {
}

void EffectMyOption::processPreDraw() {
    setSpecialDrawDepth(pOption_->_now_drawdepth-1);//eIvVɕ`悷邽
    DefaultMeshSetActor::processPreDraw();
}


void EffectMyOption::onHit(GgafActor* prm_pOtherActor) {
}

EffectMyOption::~EffectMyOption() {
    GGAF_DELETE(pScaler_);
}

