#ifndef UNIVERSE_H_
#define UNIVERSE_H_
#include "jp/ggaf/lib/scene/DefaultUniverse.h"

#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/actor/Camera.h"
#include "jp/gecchi/VioletVreath/manager/CameraWorkerManager.h"
#include "jp/gecchi/VioletVreath/manager/CameraWorkerConnection.h"

#ifdef P_GOD
    #undef P_UNIVERSE
    #define P_UNIVERSE ((VioletVreath::Universe*)(P_GOD->_pUniverse))
    #undef P_CAM
    #define P_CAM ((VioletVreath::Camera*)(P_UNIVERSE->_pCamera))
#else
    #undef P_UNIVERSE
    #undef P_CAM
#endif

/**
 * ̐ێ CameraWorkerManager ɐڑARlNV擾B
 * XFʕiCameraWorkerManager::processCreateResource(char* prm_idstr, void* prm_pConnector)  prm_idstr ɓn)
 * ܂ACameraWorkerManager::processCreateResource(char* prm_idstr, void* prm_pConnector)  prm_p ɂ nullptr ZbgĂB
 */
#define connect_CameraWorkerManager(X) ((VioletVreath::CameraWorkerConnection*)P_UNIVERSE->pCamWorkerManager_->connect((X), this))


namespace VioletVreath {

/**
 * ̓IȂ̐ .
 * {NX́A̐̐U镑܂B<BR>
 * ɐE(World)foJ(Camera)ÃJ
 * ܂Ȑ䃁\bh܂B<BR>
 * @version 1.00
 * @since 2009/04/24
 * @author Masatoshi Tsuge
 */
class Universe : public GgafLib::DefaultUniverse {

    class CameraWorkerConnectionStack {
    public:
        CameraWorkerConnection* apCamWorkerConnection_[30];
        uint32_t p_;
        CameraWorkerConnectionStack();
        CameraWorkerConnection* getLast();
        void push(CameraWorkerConnection* prm_pCamWorkerCon);
        CameraWorkerConnection* pop();
        void clear();
        void dump();
        ~CameraWorkerConnectionStack();
    };


public:
    /** [r]݂̃J} */
    CameraWorker* pActiveCamWorker_;
    /** [r]J}̃}l[W[ */
    CameraWorkerManager* pCamWorkerManager_;
    /** [r]J}̃X^bN */
    CameraWorkerConnectionStack stack_CamWorkerConnection_;
    /** [r]E */
    World* pWorld_;

public:
    Universe(const char* prm_name, Camera* prm_pCamera);

    void initialize() override;

    void processBehavior() override;

    void processJudgement() override;

    /**
     * ݂̃J}Ԃ .
     * Ԃ́AftHgJ}(DefaultCamWorker)l܂B
     * @return ݂̃J}
     */
    CameraWorker* getActiveCamWorker() {
        return pActiveCamWorker_;
    }

    /**
     * J}ꎞIɐ؂ւ .
     * VJ}PlǉAɃJ̎哱؂ւ܂B
     * ȌAundoCameraWork() s܂ł̂܂܂łB
     * @param prm_pID VJ}IDiID CameraWorkerManager ɎOo^vj
     * @return VJ}
     */
    CameraWorker* switchCameraWork(const char* prm_pID);

    /**
     * ݂̃J}rAÕJ}ɖ߂B .
     * O switchCameraWork() PȏsĂKv܂B
     * @return XA߂̃J}
     */
    CameraWorker* undoCameraWork();

    /**
     * J}ZbgB
     *  switchCameraWork() sĂ悤ƁAftHgJ}(DefaultCamWorker)
     * Pl̏Ԃɖ߂܂B
     */
    void resetCamWorker();

    virtual ~Universe();
};

}
#endif /*UNIVERSE_H_*/
