#ifndef GGAFCORE_GGAFPROPERTIES_H_
#define GGAFCORE_GGAFPROPERTIES_H_
#include "GgafCommonHeader.h"

#include "jp/ggaf/core/util/GgafUtil.h"
#include "jp/ggaf/core/util/GgafRgb.h"
#ifndef _MSC_VER
    #include <atomic>
#endif

#ifdef PROPERTY
    #undef PROPERTY
#endif
#define PROPERTY GgafCore::GgafProperties

namespace GgafCore {

/**
 * vpeBNX .
 * Ot@C烍[hAAv̊ϐƂĕێ܂B
 * @version 1.00
 * @since 2008/07/22
 * @author Masatoshi Tsuge
 */
class GgafProperties {


public:
    /** [r/w] ōt[XLbvB܂ǂȂɏdŒ`悷t[ԊuB*/
    static uint32_t MAX_SKIP_FRAME;
    /** [r/w] 60fps40fps̏osǂ̋EB1t[`񐔂Őݒ */
    static int DRAWNUM_TO_SLOWDOWN1;
    /** [r/w] 40fps30fps̏osǂ̋EB1t[`񐔂Őݒ */
    static int DRAWNUM_TO_SLOWDOWN2;
    /** [r/w] S~|(CX^X)sƂoFPS */
    static float FPS_TO_CLEAN_GARBAGE_BOX;
    /** [r] AvP[Ṽ\[XfBNg */
    static std::string DIR_RESOURCE;
    /** [r] AvP[ṼXLtH_(\[XfBNgz) */
    static std::string DIRNAME_RESOURCE_SKIN;
    /** [r] AvP[ṼXLtH_̃ftHgXL(\[XfBNg̃XLtH_z) */
    static std::string DIRNAME_RESOURCE_SKIN_DEFAULT;
    /** [r] AvP[ṼXLtH_̃[U[XL(\[XfBNg̃XLtH_z) */
    static std::string DIRNAME_RESOURCE_SKIN_USER;

    ////// ȉ́ALvpeB琶ǂݏopvpeB ////////

    /** [r] AvP[ṼXLfBNg */
    static std::string DIR_SKIN;
    /** [r] AvP[ṼftHgXLfBNg(0:default/1:[U[/2:Jg) */
    static std::string DIR_SKIN_KIND[3];




    /** [r] ێvpeBMAP */
    static GgafStrMap _mapProperties;
#ifdef _MSC_VER
    //TODO:VC++2005ȍ~(x86)  volatile ́AoAʂiƎvjB
    //gcc(x86)́AAg~bNۏ؂͖ std::atomic gBVC++ atomic ܂ł͂Ƃ肠EEEB
    static volatile bool _is_lock;
#else
    static volatile std::atomic<bool> _is_lock;
#endif

public:
    /**
     * OvpeBt@C疢[hȂ烍[hĕێvpeBMAP֐ݒAoϐɔf .
     * @param prm_properties_filename vpeBt@C
     */
    static void load(std::string prm_properties_filename);

    /**
     * ێvpeBMAPAOvpeBt@C֕ۑ .
     * @param prm_properties_filename vpeBt@C
     */
    static void save(std::string prm_properties_filename);

    /**
     * ێvpeBMAPɃL[݂邩ׂ .
     * @param prm_key L[
     * @return true:L[ / false:݂Ȃ
     */
    static bool isExistKey(std::string prm_key);

    /**
     * L[ɑ΂vpeBl string Ŏ擾 .
     * @param prm_key L[
     * @return vpeBl(string)
     */
    static std::string getStr(std::string prm_key);

    /**
     * L[ɑ΂vpeBlboolŎ擾 .
     * true, on, yes ̏̕ꍇ true Ƃ݂ȂAȊO falseB
     * @param prm_key L[
     * @return vpeBl(bool)
     */
    static bool getBool(std::string prm_key);

    /**
     * L[ɑ΂vpeBl float Ŏ擾 .
     *  atof() gpB
     * @param prm_key L[
     * @return vpeBl(float)
     */
    static float getFloat(std::string prm_key);

    /**
     * L[ɑ΂vpeBl int Ŏ擾 .
     *  atoi() gpB
     * @param prm_key L[
     * @return vpeBl(int)
     */
    static int getInt(std::string prm_key);

    /**
     * L[ɑ΂vpeBl uint32_t Ŏ擾 .
     *  _atoi64() āAuint32_tɃLXg
     * @param prm_key L[
     * @return vpeBl(uint32_t)
     */
    static uint32_t getUInt(std::string prm_key);

    /**
     * L[ɑ΂vpeBl double Ŏ擾 .
     * @param prm_key L[
     * @return vpeBl(double)
     */
    static double getDouble(std::string prm_key);

    /**
     * L[ɑ΂vpeBl GgafRgb Ŏ擾 .
     * GgafRgb ́A"#FFFFFF"i#ȗj`̕񂩂ARlAGlABlɕϊĕێ܂B
     * @param prm_key L[
     * @return vpeBl(GgafRgb)
     */
    static GgafRgb getRGB(std::string prm_key);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, int prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, uint32_t prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, std::string prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, float prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, double prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, bool prm_value);

    /**
     * ێvpeBMAPɒlݒB
     * ݒ肵Ăoɂ͂܂f܂B
     * @param prm_key
     * @param prm_value
     */
    static void setValue(std::string prm_key, GgafRgb prm_value);

};

}
#endif /*GGAFCORE_GGAFPROPERTIES_H_*/

