#ifndef GGAFCORE_GGAFRESOURCEMANAGER_H_
#define GGAFCORE_GGAFRESOURCEMANAGER_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/core/util/GgafUtil.h"
#include "jp/ggaf/core/util/GgafResourceConnection.hpp"

#include "windows.h"
namespace GgafCore {

/**
 * ǗNXB .
 * ǗNX́AbsOwڑIuWFNg(GgafResourceConnection)xǗ܂B<BR>
 * (Resource)𖳑ʂɐs킸AQƂĎg܂킵B new ̂ǂӎȂB<BR>
 * ȂƂɎgNXłB<BR>
 * GgafResourceManager : Resource : GgafResourceConnection  = 1 : N : N <BR>
 * ̊֌WŁAŃZbgłB<BR>
 * ǗNX͎ȋ@\́AڑNX̃CX^Xĩ|C^jɃXgŕێA擾vꍇA
 * ێĂ΂ԂAێĂȂΐāAXgɒǉセԂ܂B
 * ӁFXbhZ[t̕ۏ؂͓ɂQXbh܂ŁBRXbhȏ͐삵܂B
 * (GdxfwActorManagerėp)
 * @tparam T ̌^ǐ^ɕRtڑIuWFNg擾łj
 * @version 1.00
 * @since 2007/11/16
 * @author Masatoshi Tsuge
 */
template<class T>
class GgafResourceManager : public GgafObject {
    friend class GgafResourceConnection<T>;

private:
    /**
     * GgafResourceConnectionIuWFNgXgɒǉB<BR>
     * @param prm_pNew ǉGgafResourceConnectionIuWFNg̃|C^
     */
    virtual void add(GgafResourceConnection<T>* prm_pNew);

    /**
     * GgafResourceConnectionIuWFNgXg猟B<BR>
     * @param prm_idstr ʖ
     * @return  ]GgafResourceConnectionIuWFNg̃|C^BXgɑ݂Ȃꍇ nullptr
     */
    virtual GgafResourceConnection<T>* find(const char* prm_idstr);

    /**
     * ̂𐶐 .
     * connect() AꍇĂяo܂B
     * processCreateResource(const char*, void*) R[܂B
     * @param prm_idstr connect() œnꂽʖ
     * @param prm_p connect() œnꂽRp[^
     */
    T* createResource(const char* prm_idstr, void* prm_p);

    /**
     * ڑIuWFNg𐶐.
     * @param prm_idstr ʖ
     * @param prm_pResource ڑIuWFNgValueB܂莑CX^XB
     * @return ڑIuWFNg
     */
    GgafResourceConnection<T>* createResourceConnection(const char* prm_idstr, T* prm_pResource);

protected:
    /** connecttrue̔rtO */
    static volatile bool _is_connecting_resource;
    /** connect邽߂ɑ҂ĂtO */
    static volatile bool _is_waiting_to_connect;
    /** [r]}l[W */
    char* _manager_name;
    /** [r]GgafResourceConnectionIuWFNg̃Xg̐擪̃|C^BI[nullptr */
    GgafResourceConnection<T>* _pConn_first;

protected:
    /**
     * ڑIuWFNg̐ʂŎ܂B.
     * ̃\bh createResourceConnection ĂяoA{ev[gp҂Kv܂B<BR>
     * prm_idstr  ڑIuWFNg𐶐郍WbNĂB<BR>
     * قƂǂ́AGgafResourceConnection NX new āAԂOKBBR>
     * @param prm_idstr  ̎ʖnꂽAǂڑIuWFNg𐶐邩H Ƃʖ
     * @param prm_pResource |C^
     * @return GgafResourceConnection ڑIuWFNg̃CX^XiGgafResourceConnection NX̃CX^Xj
     */
    virtual GgafResourceConnection<T>* processCreateConnection(const char* prm_idstr, T* prm_pResource) = 0;

    /**
     * ۂ̎̂𐶐ʂŎ܂B.
     * ̃\bh createResource ĂяoA{ev[gp҂Kv܂B<BR>
     * prm_idstr  𐶐郍WbNĂB<BR>
     * @param prm_idstr ̎ʖnꂽAǂ𐶐(new)邩H Ƃʖ
     * @param prm_p Rp[^
     * @return CX^X̃|C^
     */
    virtual T* processCreateResource(const char* prm_idstr, void* prm_pConnector) = 0;

//    int GgafResourceManager<T>::getConnectionNum();

public:
    /**
     * RXgN^
     */
    GgafResourceManager(const char* prm_manager_name);

    /**
     * fXgN^BێXg܂B .
     * SĂ̕ێXg GgafResourceConnectionɑ΂AGgafResourceConnectionrelease()PxsA<BR>
     * GgafResourceConnection̐ڑJE^0Ȃ΁Adelete ܂B<BR>
     * GgafResourceConnection̐ڑJE^0łȂ΁Agp҂̃WbNŉR̋ꂪ̂
     * ꌾ delete ܂B<BR>
     */
    virtual ~GgafResourceManager();

    /**
     * ڑ(GgafResourceConnection)IuWFNg擾B<BR>
     * ێXgɑ݂΂ԂA݂Ȃ new ܂B<BR>
     * ێXg擾ꍇAڑJE^܂B<BR>
     * new ꍇAڑJE^1łB<BR>
     * @param prm_idstr ʖ
     * @param prm_connector 炩̈BȂꍇ́AڑthisnĉB
     * @return ʖɕRtڑ(GgafResourceConnection)
     */
    virtual GgafResourceConnection<T>* connect(const char* prm_idstr, void* prm_connector);

    /**
     * }lW[ێ郊Xgo͂܂BifobOpj .
     */
    virtual void dump();
};

// ---------------------------------------------------------------------//


template<class T>
volatile bool GgafResourceManager<T>::_is_connecting_resource = false;

template<class T>
volatile bool GgafResourceManager<T>::_is_waiting_to_connect = false;

template<class T>
GgafResourceManager<T>::GgafResourceManager(const char* prm_manager_name) : GgafObject() {
    _TRACE3_("GgafResourceManager<T>::GgafResourceManager(" << prm_manager_name << ")");

    int len = strlen(prm_manager_name);
    _manager_name = NEW char[len+1];
    strcpy(_manager_name, prm_manager_name);

    _pConn_first = nullptr;
    _is_connecting_resource = false;
    _is_waiting_to_connect = false;
}

template<class T>
GgafResourceConnection<T>* GgafResourceManager<T>::find(const char* prm_idstr) {
    GgafResourceConnection<T>* pCurrent = _pConn_first;

    while (pCurrent) {
        //_TRACE_("pCurrent->_idstr -> "<<(pCurrent->_idstr)<<" prm_idstr="<<prm_idstr);
        if (strcmp(pCurrent->_idstr, prm_idstr) == 0) {
            return pCurrent;
        }
        pCurrent = pCurrent->_pNext;
    }
    return nullptr;
}

template<class T>
void GgafResourceManager<T>::add(GgafResourceConnection<T>* prm_pResource_new) {
    if (_pConn_first == nullptr) {
        _pConn_first = prm_pResource_new;
        return;
    } else {
        GgafResourceConnection<T>* pCurrent = _pConn_first;
        while (pCurrent->_pNext) {
            pCurrent = pCurrent->_pNext;
        }
        pCurrent->_pNext = prm_pResource_new;
        return;
    }
}

template<class T>
GgafResourceConnection<T>* GgafResourceManager<T>::connect(const char* prm_idstr, void* prm_connector) {
    if (prm_idstr == nullptr) {
        _TRACE3_("x GgafResourceManager<T>::connect(nullptr) [" << _manager_name << "]");
    }
    if (_is_waiting_to_connect || _is_connecting_resource) {
        _TRACE_("GgafResourceManager<T>::connect() "<<_manager_name<<"́ARlNgłBҋ@܂EE ҋ@("<<prm_idstr<<")");
    }
    for(int i = 0; _is_waiting_to_connect || _is_connecting_resource; i++) {
        Sleep(10);
        if (i > 10*100*60) {
            //10ȏ㖳
            _TRACE_("GgafResourceManager<T>::connect() "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"  connect()悤ƂāÃRlNg10ҋ@EEE");
            throwGgafCriticalException("GgafResourceManager<T>::connect()  "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"  connect()悤ƂāÃRlNg10ҋ@Bconnect() ɁAconnect()Ă邩Ax܂B(1)");
        }
    }
    _is_waiting_to_connect = false;
    _is_connecting_resource = true;

    //TODO:ȈՓIȔrBقڊSł͂ȂB
    GgafResourceConnection<T>* pObj = nullptr;
    for(int i = 0; GgafResourceConnection<T>::_is_closing_resource; i++) {
        _is_waiting_to_connect = true;
        Sleep(10);
        if (i > 10*100*60) {
            //Pȏ㖳
            _TRACE_("GgafResourceManager<T>::connect()  "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"  connect()悤ƂāÃN[Y10ҋ@EEE");
            throwGgafCriticalException("GgafResourceManager<T>::connect()  "<<_manager_name<<"ցAprm_idstr="<<prm_idstr<<"   connect()悤ƂāÃN[Y10ҋ@Bconnect() ɁAconnect()Ă邩Ax܂B(2)");
        }
    }
    //TODO:
    //close()ɁAʃXbhconnect()ƁB
    //VrAȃ^C~OŃj󂷂鋰ꂪcĂAXXvƎv̂ǂIB
    //int (v~eBu) ̃Ag~bN𗘗pĔrłƈՂɍlĂA
    //XbhZ[tSΉ悤ƂƁAȂ߂ǂƂB׋ɂȂB
    //ԂSĂ connect() Ăяo connect() s̏`ׂB
    //templateɂ͎̂ŝGivoid*ɂׂjB
    //gގ͋C悤ARR͎Ԃ̂Ƃɂ낤B̂GGG
    //_TRACE_(" connect to " << _manager_name<<" for "<<prm_idstr<<"...");
    pObj = find(prm_idstr);
    if (pObj == nullptr) {
        //ȂΐBڑJE^P
        T* pResource = createResource(prm_idstr, prm_connector);
        pObj = createResourceConnection(prm_idstr, pResource);
        pObj->_num_connection = 1;
        pObj->_p_first_connector = prm_connector;
        add(pObj);
        _TRACE3_("GgafResourceManager<T>::connect [" << _manager_name << "]" << prm_idstr << "͖̂ŁAVK쐬ĕێɌ");
        _is_connecting_resource = false;
        return pObj;
    } else {
        //ς݂Ȃ炻ԂBڑJE^{P
        pObj->_num_connection++;
        _TRACE3_("GgafResourceManager<T>::connect [" << _manager_name << "]" << prm_idstr << "͂̂ŐڑJEg{P." << pObj->_num_connection);
        _is_connecting_resource = false;
        return pObj;
    }
}

template<class T>
T* GgafResourceManager<T>::createResource(const char* prm_idstr, void* prm_p) {
    _TRACE3_("GgafResourceManager<T>::createResource [" << _manager_name << "]" << prm_idstr << "𐶐܂傤");
    T* p = processCreateResource(prm_idstr, prm_p);
    return p;
}

template<class T>
GgafResourceConnection<T>* GgafResourceManager<T>::createResourceConnection(const char* prm_idstr, T* prm_pResource) {
    _TRACE3_("GgafResourceManager<T>::createResourceConnection [" << _manager_name << "]" << prm_idstr << "𐶐܂傤");
    GgafResourceConnection<T>* p = processCreateConnection(prm_idstr, prm_pResource);
    p->_pManager = this; //}l[Wo^
    return p;
}

template<class T>
void GgafResourceManager<T>::dump() {
    GgafResourceConnection<T>* pCurrent = _pConn_first;
    if (_pConn_first == nullptr) {
        _TRACE_("GgafResourceManager::dump[" << _manager_name << "] ێXgɂ͂Ȃɂ܂B");
    } else {
        GgafResourceConnection<T>* pCurrent_next;
        while (pCurrent) {
            _TRACE_("GgafResourceManager::dump[" << _manager_name << "] [" << pCurrent->_idstr << "" << pCurrent->_num_connection << "Connection]");
            pCurrent_next = pCurrent->_pNext;
            if (pCurrent_next == nullptr) {
                pCurrent = nullptr;
                break;
            } else {
                pCurrent = pCurrent_next;
            }
        }
    }
}

//template<class T>
//int* GgafResourceManager<T>::getConnectionNum() {
//    GgafResourceConnection<T>* pCurrent = _pConn_first;
//    int n = 0;
//    while (pCurrent) {
//        n++;
//        pCurrent = pCurrent->_pNext;
//    }
//    return n;
//}


template<class T>
GgafResourceManager<T>::~GgafResourceManager() {
#ifdef MY_DEBUG
    _TRACE_("GgafResourceManager<T>::~GgafResourceManager() ["<<_manager_name<<"] begin --->");
    dump();
#endif
    GgafResourceConnection<T>* pCurrent = _pConn_first;
    if (_pConn_first == nullptr) {
        _TRACE3_("RlNVXg͋łB["<<_manager_name<<"]͐ɊJł傤B");
    } else {
        GgafResourceConnection<T>* pCurrent_next;
        while (pCurrent) {
            int rnum = pCurrent->_num_connection;
            _TRACE_("x["<<_manager_name<<"]ɁARlNV[" << pCurrent->_idstr << "" << rnum
                    << "Connection]cĂ̂ō폜o܂Bclose()RvłBʂ" << rnum << " close() ݂܂B");
//            T* r = pCurrent->peek();
            pCurrent_next = pCurrent->_pNext;
//            if (r) {
//                pCurrent->processReleaseResource(r); //\[X̉
//            }
            for (int i = 0; i < rnum; i++) {
                _TRACE_("x["<<i<<"] close() 炵܂BpCurrent="<<(pCurrent->_idstr)<<"("<<pCurrent<<")");
                pCurrent->close(); //E܂ŉ
                _TRACE_("x["<<i<<"] close() ܂B");
            }
            if (pCurrent_next == nullptr) {
                //Ō̈
                break;
            } else {
                pCurrent = pCurrent_next;
            }
        }
    }
#ifdef MY_DEBUG
    _TRACE_("GgafResourceManager<T>::~GgafResourceManager() ["<<_manager_name<<"] end   <---");
#endif
    GGAF_DELETEARR_NULLABLE(_manager_name);
}

}
#endif /*GGAFCORE_GGAFRESOURCEMANAGER_H_*/
