#include "stdafx.h"
#include "EnemyEsperiaLaserChip001.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyEsperiaLaserChip001::EnemyEsperiaLaserChip001(const char* prm_name) :
        HomingLaserChip(prm_name, "EsperiaLaserChip001", STATUS(EnemyEsperiaLaserChip001)) {
    _class_name = "EnemyEsperiaLaserChip001";
    tX1_ = tY1_ = tZ1_ = 0;
    tX2_ = tY2_ = tZ2_ = 0;
    begin_Y_ = 0;
    turn_dY_ = 0;
    _pSeTx->set(SE_FIRE , "WAVE_ENEMY_FIRE_LASER_001");
}

void EnemyEsperiaLaserChip001::initialize() {
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 20000);
    setHitAble(true, false);
    setScaleR(5.0);
    _pKurokoA->relateMvFaceAng(true);
    useProgress(PROG_NOTHING);
}

void EnemyEsperiaLaserChip001::onActive() {
    HomingLaserChip::onActive();
    //Xe[^XZbg
    _pStatus->reset();
    begin_Y_ = _Y;
    _pKurokoA->stopTurnMvAngSequence();
    _pKurokoA->setRzRyMvAngVelo(0);
    if (_pChip_front == nullptr) {
        _pKurokoA->setMvAngTwd(tX1_, tY1_, tZ1_);
        _pProg->reset(PROG_MOVE_UP);
    } else {
        _pProg->reset(PROG_NOTHING);
    }
    setAlpha(0.99);
    //̃o[ EnemyEsperia {̑ݒς݂O
    //turn_dY_;
    //tX1_, tY1_, tZ1_;
    //tX2_, tY2_, tZ2_;
}

void EnemyEsperiaLaserChip001::executeHitChk_MeAnd(GgafActor* prm_pOtherActor) {
    if (((GgafMainActor*)prm_pOtherActor)->getKind() & KIND_CHIKEI) {
        if (_chip_kind != 2 || _can_chikei_hit) {
            GgafDxDrawableActor::executeHitChk_MeAnd(prm_pOtherActor);
        } else {
            return;
        }
    } else {
        GgafDxDrawableActor::executeHitChk_MeAnd(prm_pOtherActor);
    }
}

void EnemyEsperiaLaserChip001::processBehaviorHeadChip() {
    MyShip* pMyShip = P_MYSHIP;
    switch (_pProg->get()) {
        case PROG_MOVE_UP: {
            //[U[㏸
            if (!_pKurokoA->isTurningMvAng()) {

                //␳
                _pKurokoA->turnMvAngTwd(tX1_, tY1_, tZ1_,
                                        D_ANG(5), 0,
                                        TURN_CLOSE_TO, true);
            }

            if (_Y > begin_Y_+turn_dY_ || _pProg->getFrameInProgress() > 300) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_TURN1: {
            //@菭̍Wŋ
            if (_pProg->isJustChanged()) {
                _pKurokoA->setMvVelo(_pKurokoA->_veloMv/3); //܎X[_E
                _pKurokoA->turnMvAngTwd(tX2_, tY2_, tZ2_,
                                        D_ANG(10), 0,
                                        TURN_CLOSE_TO, true);
            }
            if (!_pKurokoA->isTurningMvAng()) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_TURN2: {
            //ܕ␳
            if (_pProg->getFrameInProgress() % 8U == 0) {
                _pKurokoA->turnMvAngTwd(tX2_, tY2_, tZ2_,
                                        D_ANG(5), 0,
                                        TURN_CLOSE_TO, true);
            }
            if (_pProg->getFrameInProgress() > 60) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_INTO_MYSHIP: {
            if (_pProg->isJustChanged()) {
                _pSeTx->play3D(SE_FIRE);
                _pKurokoA->setMvVelo(_pKurokoA->_veloMv*2);
            }
            if (_pProg->getFrameInProgress() % 16U == 0) {
                _pKurokoA->turnMvAngTwd(tX2_, tY2_, tZ2_,
                                        100, 0,
                                        TURN_CLOSE_TO, true);
            }
            if (_pProg->getFrameInProgress() > 90) {
                _pKurokoA->stopTurnMvAngSequence();
                _pKurokoA->setRzRyMvAngVelo(0);
                _pProg->changeNext();
            }
            break;
        }
        case PROG_NOTHING: {
            break;
        }
    }
    _pKurokoA->behave();
    _pSeTx->behave();
}

void EnemyEsperiaLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //qbg
    //̗͌vZ
    int sta = UTIL::calcEnemyStamina(this, pOther);
    if (sta <= 0) {
        //qbgďŎ
        sayonara();
    } else {
        //qbgĐ
    }
}

EnemyEsperiaLaserChip001::~EnemyEsperiaLaserChip001() {
}

