#include "stdafx.h"
#include "VreathItem.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoB.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/ggaf/core/util/GgafStatus.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

VreathItem::VreathItem(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat)
               : Item(prm_name, prm_model, prm_pStat) {
    _class_name = "VreathItem";
    effectBlendOne(); //ZTechniquew
    setZEnable(true);        //Zobt@͍lL
    setZWriteEnable(false);  //Zobt@͏ݖ
    setAlpha(0.9);

    _pKurokoA->setFaceAngVelo(D_ANG(3), D_ANG(5), D_ANG(7));
    _pKurokoA->relateMvFaceAng(true);
    kDX_ = kDY_ = kDZ_ = 0;
    useProgress(PROG_ABSORB);
    setHitAble(true, false); //ʊO蔻͖
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 400000);
    _pSeTx->set(0, "WAVE_GET_ITEM_001");
}

void VreathItem::initialize() {
}

void VreathItem::onActive() {
    // _X, _Y, _Z ͔Wɐݒς
    setHitAble(true, false);

    _pKurokoB->forceVxyzMvVeloRange(-30000, 30000);
    _pKurokoB->setZeroVxyzMvVelo();
    _pKurokoB->setZeroVxyzMvAcce();
    _pKurokoB->stopGravitationMvSequence();

    //ݒ
    MyShip* pMyShip = P_MYSHIP;
//    //U΂͈͐`Pӂ̒
//    int scattered_renge    = _pColliChecker->_pCollisionArea->_papColliPart[0]->_dx; //蔻Ɠ
//    //n_A@ւ̕ւ̎U΂͈͐`̈悪ʒu鋗iscattered_distance > (scattered_renge/2) ł邱)
////    int scattered_distance = scattered_renge/2 + 400000;
//    //]āAscattered_distance ĂĂA@͓ȂĂ肬SĉłB

    _pKurokoA->forceMvVeloRange(0, 20000);
    float vX, vY, vZ;
    UTIL::getNormalizeVector(
            pMyShip->_X - _X,
            pMyShip->_Y - _Y,
            pMyShip->_Z - _Z,
            vX, vY, vZ);
    int d = PX_C(200);
    int r = PX_C(75);
    _pKurokoA->setMvAngTwd( (coord)(_X + (vX * d) + RND(-r, +r)),
                            (coord)(_Y + (vY * d) + RND(-r, +r)),
                            (coord)(_Z + (vZ * d) + RND(-r, +r)) );
    _pKurokoA->setMvVelo(2000);
    _pKurokoA->setMvAcce(100);

    _pProg->reset(PROG_DRIFT);
    _SX = _SY = _SZ = 1000;
}

void VreathItem::processBehavior() {
    //ʏړ
    if (_pProg->get() == PROG_DRIFT) {
        //TractorMagicPROG_ATTACHֈڍs
        if (getTractorMagic()->is_tracting_) {
            effectFlush(6); //tbV
            setHitAble(false);
            _pProg->change(PROG_ATTACH);
        }
        //邢 onHit()  PROG_ATTACH ԕω̂҂
    }

    //@Ɠ蔻肪qbgA@Ɍ
    if (_pProg->get() == PROG_ATTACH) {
        MyShip* pMyShip = P_MYSHIP;
        if (_pProg->isJustChanged()) {
            //@Ɉ͂ň񂹂悤ȓݒ
            _pKurokoB->setVxyzMvVelo(_pKurokoA->_vX*_pKurokoA->_veloMv,
                                     _pKurokoA->_vY*_pKurokoA->_veloMv,
                                     _pKurokoA->_vZ*_pKurokoA->_veloMv );
            _pKurokoB->execGravitationMvSequenceTwd(pMyShip, PX_C(20), 200, PX_C(100));
            _pKurokoA->stopMv();
        }

        //@ߕӂɓBH
        if (ABS(pMyShip->_X - _X) < 20000 &&
            ABS(pMyShip->_Y - _Y) < 20000 &&
            ABS(pMyShip->_Z - _Z) < 20000 ) {

            kDX_ = pMyShip->_X - _X;
            kDY_ = pMyShip->_Y - _Y;
            kDZ_ = pMyShip->_Z - _Z;
            _pProg->change(PROG_ABSORB); //zz
        }

    }

    //@ߕӂɓBAzAz̓
    if (_pProg->get() == PROG_ABSORB) {
        MyShip* pMyShip = P_MYSHIP;
        if (_pProg->isJustChanged()) {
            _pKurokoB->setZeroVxyzMvVelo();
            _pKurokoB->setZeroVxyzMvAcce();
            _pKurokoB->stopGravitationMvSequence();
        }
        _X = pMyShip->_X + kDX_;
        _Y = pMyShip->_Y + kDY_;
        _Z = pMyShip->_Z + kDZ_;
        _SX -= 100;
        _SY -= 100;
        _SZ -= 100;
        if (_SX < 5) {
            _pSeTx->play(0);
            _pProg->changeNothing();
            sayonara(); //I
        }
        pMyShip->_pStatus->plus(STAT_Stamina, 1);
    }
    _pKurokoA->behave();
    _pKurokoB->behave();
}

void VreathItem::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
//    //ʏړ
//    if (_pProg->get() == PROG_DRIFT) {
//        //onHit() ŏԕω̂҂
//    }
//
//    //@Ɠ蔻肪qbg
//    if (_pProg->get() == PROG_ATTACH) {
//
//    }
//
//    //@ɋzAz̓
//    if (_pProg->get() == PROG_ABSORB) {
//    }
}

void VreathItem::onInactive() {
}

void VreathItem::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg


    if (_pProg->get() == PROG_DRIFT && (pOther->getKind() & KIND_MY_BODY))  {
        setHitAble(false);
        _pProg->change(PROG_ATTACH);
    }

}

VreathItem::~VreathItem() {
}
