#ifndef MENUBOARD_H_
#define MENUBOARD_H_
#include "jp/ggaf/lib/actor/menu/MenuActor.hpp"

namespace VioletVreath {

/**
 * {Aṽj[{[hW .
 * XCh̃gWVB
 * LZ̎B
 * @version 1.00
 * @since 2011/12/26
 * @author Masatoshi Tsuge
 */
class MenuBoard : public GgafLib::StringBoardMenu {

public:
    enum {
        SE_ON_RISEN      ,
        SE_MOVE_CURSOR   ,
        SE_DECIDED_CANCEL,
    };
    coord slide_from_offset_X_;
    coord slide_from_offset_Y_;
    coord target_X_;
    coord target_Y_;

public:
    MenuBoard(const char* prm_name, const char* prm_model);

    /**
     * j[\̃XChgWV̐ݒ .
     * @param prm_menu_fade_frames j[̃tF[hCiƃtF[hAEgj̃t[
     * @param prm_slide_from_offset_X j[̃XChJn̑XW
     * @param prm_slide_from_offset_Y j[̃XChJn̑XW
     */
    void setTransition(frame prm_menu_fade_frames,
                       coord prm_slide_from_offset_X, coord prm_slide_from_offset_Y);

    virtual bool condDecision() override;
    virtual bool condCancel() override;
    virtual bool condSelectNext() override;
    virtual bool condSelectPrev() override;
    virtual bool condSelectExNext() override;
    virtual bool condSelectrExPrev() override;
    virtual bool condSelectCancel() override;
    virtual void moveCursor(bool prm_smooth = true) override;
    virtual void onMoveCursor(int prm_from, int prm_to) override;
    virtual void onSelect(int prm_from, int prm_to) override;

    virtual void initialize() override;

    /**
     * \ʒu݂_X, _YŐݒ肵j[(g)N .
     * ʏ͑̃IuWFNgĂяo郁\bhłB
     */
    virtual void riseMe() override;

    /**
     * \ʒuw肵ăj[(g)N .
     * W̓XChėWwB
     * ʏ͑̃IuWFNgĂяo郁\bhłB
     * @param prm_target_X \XW
     * @param prm_target_Y \YW
     */
    virtual void rise(coord prm_target_X, coord prm_target_Y);

    /**
     * \ʒuw肵ăTuj[N .
     * W̓Tuj[XChėWwB
     * ( void MenuActor<T>::riseSubMenu(int prm_index) B)
     * @param prm_index Tuj[CfbNX(ǉԁB0`)
     * @param prm_target_X Tuj[\XW
     * @param prm_target_Y Tuj[\YW
     */
    virtual void riseSubMenu(int prm_index, coord prm_target_X, coord prm_target_Y);

    virtual void onRise() override;
    virtual void processBehavior() override;
    virtual void processJudgement() override;
    virtual void onSink() override;

    virtual ~MenuBoard();
};

}
#endif /*MENUBOARD_H_*/

