#ifndef MENUSELECTSUB_H_
#define MENUSELECTSUB_H_
#include "jp/ggaf/lib/actor/menu/MenuActor.hpp"

namespace VioletVreath {

/**
 * {Aṽj[{[h̃ZNgi .
 * @version 1.00
 * @since 2013/06/06
 * @author Masatoshi Tsuge
 */
class MenuSelectSub : public GgafLib::StringBoardMenu {

public:
    enum {
        SE_MOVE_CURSOR   ,
    };
    coord target_X_;
    coord target_Y_;

public:
    MenuSelectSub(const char* prm_name, const char* prm_model);


    virtual bool condDecision() override;
    virtual bool condCancel() override;
    virtual bool condSelectNext() override;
    virtual bool condSelectPrev() override;
    virtual bool condSelectExNext() override;
    virtual bool condSelectrExPrev() override;
    virtual bool condSelectCancel() override;
    virtual void moveCursor(bool prm_smooth = true) override;
    virtual void onMoveCursor(int prm_from, int prm_to) override;
    virtual void onSelect(int prm_from, int prm_to) override;

    virtual void initialize() override;

    /**
     * \ʒu݂_X, _YŐݒ肵j[(g)N .
     * ʏ͑̃IuWFNgĂяo郁\bhłB
     */
    virtual void riseMe() override;

    /**
     * \ʒuw肵ăj[(g)N .
     * W̓XChėWwB
     * ʏ͑̃IuWFNgĂяo郁\bhłB
     * @param prm_target_X \XW
     * @param prm_target_Y \YW
     */
    virtual void rise(coord prm_target_X, coord prm_target_Y);

    /**
     * \ʒuw肵ăTuj[N .
     * W̓Tuj[XChėWwB
     * ( void MenuActor<T>::riseSubMenu(int prm_index) B)
     * @param prm_index Tuj[CfbNX(ǉԁB0`)
     * @param prm_target_X Tuj[\XW
     * @param prm_target_Y Tuj[\YW
     */
    virtual void riseSubMenu(int prm_index, coord prm_target_X, coord prm_target_Y);

    void onDecision(GgafDxCore::GgafDxDrawableActor* prm_pItem, int prm_item_index) override {
    }
    void onCancel(GgafDxCore::GgafDxDrawableActor* prm_pItem, int prm_item_index) override {
    }

    virtual void onRise() override;
    virtual void processBehavior() override;
    virtual void processJudgement() override;
    virtual void onSink() override;

    virtual ~MenuSelectSub();
};

}
#endif /*MENUBOARD_H_*/

