#ifndef MAGIC_H_
#define MAGIC_H_
#include "jp/ggaf/core/actor/GgafMainActor.h"

namespace VioletVreath {

typedef int magic_point;
typedef frame magic_time;

#define MAGIC_CAST_NG_INVOKING_NOW          (-3)
#define MAGIC_CAST_NG_MP_IS_SHORT           (-2)
#define MAGIC_CAST_CANCEL                   (-1)
#define MAGIC_CAST_NOTHING                  (0)
#define MAGIC_CAST_OK_LEVELUP               (1)
#define MAGIC_CAST_OK_LEVELDOWN             (2)
#define MAGIC_CAST_OK_CANCEL_AND_LEVELUP    (3)
#define MAGIC_CAST_OK_CANCEL_AND_LEVELDOWN  (4)

#define MAGIC_INVOKE_NG_INVOKING_NOW (-3)
#define MAGIC_INVOKE_NG_MP_IS_SHORT (-2)
#define MAGIC_INVOKE_NOTHING        (0)
#define MAGIC_INVOKE_OK_LEVELUP     (1)
#define MAGIC_INVOKE_OK_LEVELDOWN   (2)

#define MAGIC_EFFECT_NG_MP_IS_SHORT (-2)
#define MAGIC_EFFECT_NOTHING        (0)
#define MAGIC_EFFECT_OK_LEVELUP     (1)
#define MAGIC_EFFECT_OK_LEVELDOWN   (2)

#define MMETER_MAX_LEVEL 9

/**
 * ۖ@NX .
 * @MPɂĂ̖{NX̊{IȐB<BR>
 * E@gpƊe@ɐݒ肳ꂽMP܂Bu{@RXgvĂт܂B<BR>
 * E@ɂ̓xƂTOAȂԂ̓xOłBx{Pꍇu{@RXgv܂B<BR>
 *   AAуx({Qȏ)̏ꍇAMPɂݒ肪\łB<BR>
 * EуxAbvɂāAƂ΁uXs[hvƌ@ɃxP`TA{@RXg 10 Ƃ܂B<BR>
 *   uXs[h Level1vuXs[h Level2v ƂQ񃌃xAbvsꍇAMPRXg 10+10=20 łA<BR>
 *   ȂuXs[h Level2vƂꍇAMPRXg (10+10)*0.8 = 16 Ƃ悤Ȑݒ肪уxAbvł͉\łB<BR>
 *    0.8 ̂Ƃu팸vƌĂԎƂ܂B<BR>
 * Ex_E̊TO݂܂Bx_E͂łs܂B<BR>
 *   x_Eɂ̕MPɊ炩ҌƂݒo܂B<BR>
 * E@ɂ̓CtTCNÃXebv݂܂Bep[^ݒ\łB<BR>
 *   a) @̃xAbvs<BR>
 *   b) rF@rJnrrI (r͓rŃLZ)  <BR>
 *   c) F@Jn@@I (ɂȂƃLZs) <BR>
 *   d) F@ʎJn(RXgEʔ) ʎʎIi@̃x_Ej<BR>
 * E@̎ނɂ́Au@vAuʎ@v ̂Qނ܂B
 *   1)u@v ud) ṽvZX@łAxAbvE_EƂTO݂܂B<BR>
 *   2)uʎ@v́Aud) vAMPuێRXgLvAMPȂuێRXgv̂Qނ܂B
 *      ܂A\ߐݒ肳ꂽʎԂ𒴂ƎŃx_E(|P)܂B<BR>
 *      2-a)uێRXgLv ud) vMPArMP0ɂȂĂ܂ꍇAIɃx0ɂ܂Ńx_E܂B<BR>
 *      2-b)uێRXgv ud) vMP܂BrMP0łx_E͋N܂BiʎԐ؂݂̂ŋNj<BR>
 * @version 1.00
 * @since 2009/05/19
 * @author Masatoshi Tsuge
 */
class Magic : public GgafCore::GgafMainActor {
public:
    enum {
        STATE_NOTHING = 1,
        STATE_RE_CASTING,
        STATE_CASTING    ,
        STATE_INVOKING   ,
        STATE_RE_EFFECTING,
        STATE_EFFECTING  ,
        STATE_ABANDONING ,
    };

    /**
     * ex̏ .
     */
    class LevelInfo {
    public:
        /** [r]@ʎIc莞 */
        magic_time remainingtime_of_effect_;
        /** [r/w]@ʎ */
        magic_time time_of_effect_;
        /** [r/w]@ʎRXg  */
        magic_point keep_cost_;
        /** [r/w]Ajp^[ԍ */
        int pno_;

        LevelInfo() : remainingtime_of_effect_(0),
                      time_of_effect_(0),
                      keep_cost_(0),
                      pno_(0) {
        }
    };

public:

    /** [r]}WbN|Cg */
    int* const pMP_;

    /** [r]݂̍ōx */
    int max_level_;
    /** [r]݂̃x(݌ʎĂ郌xAIʎJñ^C~OŐ؂ւ) */
    int level_;
    /** [r]Vx(rA̎AɎɂȂ낤Ƃ郌x) */
    int new_level_;
    /** [r]Õx(ʎ̎AʎÕx) */
    int last_level_;
    /** [r]Pt[Õx */
    int prev_frame_level_;

    /** [r]{@ɕKvȃRXg̊{P */
    const magic_point cost_base_;
    /** [r]{@rJn ` @rI̊{Pʎ  */
    const magic_time time_of_casting_base_;
    /** [r]{@Jn ` @I̊{Pʎ */
    const magic_time time_of_invoking_base_;
    /** [r]{@ʎJn ` @ʎI̊{Pʎ  */
    const magic_time time_of_effect_base_;
    /** [r]{@ʎRXg̊{P  */
    const magic_point keep_cost_base_;

    /** [r]уx̖@RXg팸(0.0`1.0) */
    const double r_cost_;
    /** [r]уx̉rԍ팸(0.0`1.0) */
    const double r_time_of_casting_;
    /** [r]уx̔ԍ팸(0.0`1.0) */
    const double r_time_of_invoking_;
    /** [r]ex̌ʎԍ팸(0.0`1.0) */
    const double r_each_lv_time_of_effecting_;
    /** [r]eẍێRXg (1.0` )*/
    const double r_keep_cost_;

    /** [r]ex̏ 0`MMETER_MAX_LEVEL */
    LevelInfo lvinfo_[MMETER_MAX_LEVEL+1];

    /** [r]̐iԂɂȂׂɕKvȃt[(ꎞێ) */
    magic_time time_of_next_state_;
    /** [r]xAbvǂ */
    bool is_working_;

    /** [r]уxʖ@RXg 0`MMETER_MAX_LEVEL */
    magic_point interest_cost_[MMETER_MAX_LEVEL+1];
    /** [r]уxʉrԏ 0`MMETER_MAX_LEVEL */
    magic_time  interest_time_of_casting_[MMETER_MAX_LEVEL+1];
    /** [r]уxʔԏ 0`MMETER_MAX_LEVEL */
    magic_time  interest_time_of_invoking_[MMETER_MAX_LEVEL+1];

    progress temp_hold_status_;
    int temp_hold_new_level_;

public:

    /**
     * @̒`s .
     * уxƂ̓xP傫(xQȏ)wB
     * @param prm_name @
     * @param prm_pMP }WbN|Cg̐ʃo[
     * @param prm_max_level {@̏ōx 1`MMETER_MAX_LEVEL
     * @param prm_cost_base              {@RXg
     * @param prm_r_cost                 уx̖@RXg팸 0.0`1.0
     *                                   (yz1.0:уxłA
     *                                          0.8:xQȏ㎞ARXg=prm_cost_base*x*0.8)
     * @param prm_time_of_casting_base   {@r
     * @param prm_r_time_of_casting      уx̉rԍ팸0.0`1.0
     *                                   (yz1.0:уxł,
     *                                          0.8:xQȏ㎞Ar=prm_time_of_casting_base*x*0.8)
     * @param prm_time_of_invoking_base  {@
     * @param prm_r_time_of_invoking     уx̔ԍ팸0.0`1.0
     *                                   (yz1.0:уxł,
     *                                          0.8:xQȏ㎞A=prm_time_of_invoking_base*x*0.8)
     * @param prm_time_of_effect_base {@ʎԁB
     *                                0w肷ƁAu@vƉ߂B
     *                                0傫lݒ肷ƁAuʎ@vƉ߂B
     * @param prm_r_each_lv_time_of_effecting ex̌ʎԍ팸  0.0`1.0
     *                      (yz1.0:xɂʎ팸,
     *                             0.8:x1̂Ƃ prm_time_of_effect
     *                                 x2̂Ƃ prm_time_of_effect * 0.8
     *                                 x3̂Ƃ prm_time_of_effect * 0.8 * 0.8
     *                                 x4̂Ƃ prm_time_of_effect * 0.8 * 0.8 * 0.8  ƂԂݒ肳)
     * @param prm_keep_cost_base {@ʎێRXgB0Ȃ΁uێRXgv0傫lݒ肷ƁuێRXgLvƂȂB
     * @param prm_r_each_lv_keep_cost eẍێRXg 1.0`
     *                      (yz1.0:xɂێRXg,
     *                             1.2:x1̂Ƃ prm_keep_cost_base
     *                                 x2̂Ƃ prm_keep_cost_base * 1.2
     *                                 x3̂Ƃ prm_keep_cost_base * 1.2 * 1.2
     *                                 x4̂Ƃ prm_keep_cost_base * 1.2 * 1.2 * 1.2  ƂێRXgݒ肳)
     * @return
     */
    Magic(const char* prm_name, int* prm_pMP,
          int prm_max_level,
          magic_point prm_cost_base            , double prm_r_cost,
          magic_time  prm_time_of_casting_base , double prm_r_time_of_casting,
          magic_time  prm_time_of_invoking_base, double prm_r_time_of_invoking,
          magic_time  prm_time_of_effect_base  , double prm_r_each_lv_time_of_effecting,
          magic_point prm_keep_cost_base       , double prm_r_each_lv_keep_cost);

    void init();

    void initialize() override {}

    void onReset() override;

    void processBehavior() override;

    void processJudgement() override {}

    void processDraw() override {}

    void processFinal() override {}

    void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    void save(std::stringstream& sts);

    void load(std::stringstream& sts);

    /**
     * rJns .
     * @param prm_new_level
     */
    virtual int cast(int prm_new_level);

    /**
     * @rJnR[obN(P񂾂R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level rVx(1` )
     */
    virtual void processCastBegin(int prm_now_level, int prm_new_level) {};

    /**
     * @rR[obN(t[R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level r̐Vx(1` )
     */
    virtual void processCastingBehavior(int prm_now_level, int prm_new_level) {};

    /**
     * @rIR[obN(P񂾂R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level r\̐Vx(1` )
     */
    virtual void processCastFinish(int prm_now_level, int prm_new_level, int prm_result_invoke) {};

    /**
     * Jns .
     * @param prm_new_level
     */
    virtual int invoke(int prm_new_level);

    /**
     * @JnR[obNB܂łƉrLZ͕sƂB(P񂾂R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level 悤ƂĂVx(1` )
     */
    virtual void processInvokeBegin(int prm_now_level, int prm_new_level) {};

    /**
     * @R[obN(t[R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level ݔ̐Vx(1` )
     */
    virtual void processInvokingBehavior(int prm_now_level, int prm_new_level) {};

    /**
     * @IR[obN(P񂾂R[obN) .
     * @param prm_now_level @IÓÃ݂xB(0` )
     * @param prm_new_level @ÍAiׂVxB(1` )
     */
    virtual void processInvokeFinish(int prm_now_level, int prm_new_level, int prm_result_effect) {};

    /**
     * ʔs .
     * @param prm_level ʔx
     */
    virtual int effect(int prm_level);

    /**
     * @ʎJnR[obN(P񂾂R[obN) .
     * @I  @ʎJnÃ^C~OŌĂяoBɁA<BR>
     * @ʎ  xAbv or x_EÃ^C~OłĂяoB<BR>
     * prm_last_level < prm_now_level ̏ꍇxAbv .
     * prm_last_level > prm_now_level ̏ꍇx_E .
     * @param prm_last_level ʎJnÕxB(xAbvF0` ^x_EF1`)
     * @param prm_now_level ʎJnꂽxB(xAbvF1` ^x_EF1`)
     */
    virtual void processEffectBegin(int prm_last_level, int prm_now_level) {};

    /**
     * @ʎR[obN(t[R[obN) .
     * yӁz@(time_of_effect_base_==0)̖@́A{R[obN͍s܂B
     * @param prm_last_level  ȑÕxB
     * @param prm_now_level ()̃xB
     */
    virtual void processEffectingBehavior(int prm_last_level, int prm_now_level) {};

    /**
     * @SIR[obN(P񂾂R[obN) .
     * x0ɂȂ郌x_EsꂽOɌĂяo܂B<BR>
     * ߑFx0ɂȂȂx_E processEffectBegin() Ăяo܂B<BR>
     * @param prm_justbefore_level ʎI钼Õx(Ȃ݂Ɍ݃x͕K0)B
     */
    virtual void processEffectFinish(int prm_justbefore_level) {};

    /**
     * ̃x̖@rsł邩ׂ
     * @param prm_new_level r郌x
     * @return MAGIC_CAST_NG_INVOKING_NOW          (-3)  ݔׁ̂As
     *         MAGIC_CAST_NG_MP_IS_SHORT           (-2)  xAbvrƂȂ邪AMPȂׁAs
     *         MAGIC_CAST_CANCEL                   (-1)  ݉rŁÃx́Ã݂xƈvB܂rLZwɂȂBi\Es\ŌΉ\j
     *         MAGIC_CAST_NOTHING                  (0)   ̃x́Ã݂xƈvBȂɂwĂȂƂɂȂBi\Es\ŌΉ\j
     *         MAGIC_CAST_OK_LEVELUP               (1)   xAbvrƂȂBMP׉\
     *         MAGIC_CAST_OK_LEVELDOWN             (2)   x_ErƂȂB\
     *         MAGIC_CAST_OK_CANCEL_AND_LEVELUP    (3)   ݂̉rLZẴxAbvrƂȂBMP׉\
     *         MAGIC_CAST_OK_CANCEL_AND_LEVELDOWN  (4)   ݂̉rLZẴx_ErƂȂB\
     */
    int chkCastAble(int prm_new_level);

    /**
     * ̃x̖@sł邩ׂ
     * @param prm_new_level 郌x
     * @return
     */
    int chkInvokeAble(int prm_new_level);

    /**
     * ̃x̖@ʂsł邩ׂ
     * @param prm_level
     * @return
     */
    int chkEffectAble(int prm_level);

    /**
     * @LZ .
     */
    virtual void cancel();

    /**
     * _Exs̊ҌMPvZĕԂ .
     * cʎ̊悸B
     * x_Eقɂ邽߁B
     * @param prm_now_level ݂̃x
     * @param prm_target_down_level _Ex
     * @return
     */
    magic_point calcReduceMp(int prm_now_level, int prm_target_down_level);

    /**
     * ʎԍv̎Z .
     * @param prm_now_level ݂̃x
     * @param prm_target_up_level xAbṽx
     * @return Zꂽʎԍv
     */
    magic_time calcTotalEffecTime(int prm_now_level, int prm_target_up_level);

    virtual ~Magic();
};

}

#endif /*MAGIC_H_*/
