#ifndef GGAFCORE_GGAFVALUETRANSITIONER_H_
#define GGAFCORE_GGAFVALUETRANSITIONER_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/core/util/GgafUtil.h"

namespace GgafCore {

/**
 * l̑Jڃwp[ .
 * IɔŐʉB
 * @version 1.00
 * @since 2014/02/19
 * @author Masatoshi Tsuge
 */
template <class VAL_TYPE, int N>
class GgafValueTransitioner : public GgafObject {
    enum TransitionMethod {
        NO_TRANSITION,
        TARGET_LINER_TO,
        TARGET_LINER_STEP,
        BEAT_LINER,
        BEAT_TRIANGLEWAVE,
        BEAT_TRIGONOMETRIC,
        TARGET_ACCELERATION_STEP,
    };
public:
    /** [r/w]eΏۃCfbNX̖ڕW̑J */
    VAL_TYPE _target[N];
    /** [r/w]eΏۃCfbNX̑Jڏ */
    VAL_TYPE _top[N];
    /** [r/w]eΏۃCfbNX̑Jډ */
    VAL_TYPE _bottom[N];
    /** [r/w]eΏۃCfbNX̖t[̑Jڂ̑ */
    VAL_TYPE _velo[N];
    /** [r/w]eΏۃCfbNX̖t[̑Jڂ̑̑ */
    VAL_TYPE _acce[N];
    /** [r]eΏۃCfbNX̒lJڕ@ */
    TransitionMethod _method[N];
    /** [r]r[gAeΏۃCfbNX̑`g̔g`ŒlJڂ̃A^bNt[ */
    frame _beat_frame_of_attack_finish[N];
    frame _beat_frame_of_sustain_finish[N];
    /** [r]r[gAeΏۃCfbNX̃A^bN牺܂ł̃t[ */
    frame _beat_frame_of_decay_finish[N];
    /** [r]r[gAeΏۃCfbNX̑`g̔g`ŒlJڂ̃Xgt[ */
    frame _beat_roop_frames[N];
    /** [r]r[gAeΏۃCfbNX̒lJڂɔ₷t[ */
    frame _beat_target_frames[N];
    /** [r]r[gAJE^[ */
    frame _beat_frame_count_in_roop[N];
    /** [r]r[gAJE^[ */
    frame _beat_frame_count[N];

protected:
    /**
     * l擾ivj .
     * @param idx
     * @return
     */
    virtual VAL_TYPE getValue(int idx) = 0;

    /**
     * lݒ肷ivj .
     * @param idx
     * @param value
     */
    virtual void setValue(int idx, VAL_TYPE value) = 0;

public:
    /**
     * RXgN^<BR>
     */
    GgafValueTransitioner() : GgafObject() {
        for (int i = 0; i < N; i++) {
            _velo[i] = 0;
            _acce[i] = 0;
            _target[i] = 0;
            _top[i] = 0;
            _bottom[i] = 0;
            _beat_frame_of_attack_finish[i] = 0;
            _beat_frame_of_sustain_finish[i] = 0;
            _beat_frame_of_decay_finish[i] = 0;
            _beat_roop_frames[i] = 0;
            _beat_target_frames[i] = 0;
            _beat_frame_count_in_roop[i] = 0;
            _beat_frame_count[i] = 0;
            _method[i] = NO_TRANSITION;
        }
    }

    /**
     * lJڂ̏ݒiSΏۃCfbNXwj .
     * ̑召͋Cɂn(Ŏ)
     * @param prm1 Jڒl1
     * @param prm2 Jڒl2
     */
    void forceRange(VAL_TYPE prm1, VAL_TYPE prm2) {
        for (int i = 0; i < N; i++) {
            forceRange(i, prm1, prm2);
        }
    }

    /**
     * lJڂ̏lݒiΏۃCfbNXPʂŎwj
     * @param prm_idx ΏۃCfbNX
     * @param prm1 Jڒl1
     * @param prm2 Jڒl2
     */
    void forceRange(int prm_idx, VAL_TYPE prm1, VAL_TYPE prm2) {
        if (prm1 < prm2) {
            _bottom[prm_idx] = prm1;
            _top[prm_idx] = prm2;
        } else {
            _bottom[prm_idx] = prm2;
            _top[prm_idx] = prm1;
        }
    }

    /**
     * lJڂ̏l擾 .
     * @param prm_idx ΏۃCfbNX
     * @return l
     */
    virtual VAL_TYPE getTop(int prm_idx) {
        return _top[prm_idx];
    }

    /**
     * lJڂ̉l擾 .
     * @param prm_idx ΏۃCfbNX
     * @return
     */
    virtual VAL_TYPE getBottom(int prm_idx) {
        return _bottom[prm_idx];
    }

    /**
     * lJڂ̏l擾 .
     * ΏۃCfbNXQȏ̏ꍇASl̒ōŏԂB
     * @return l
     */
    virtual VAL_TYPE getTop() {
        //_top̍ŏlԂ
        VAL_TYPE minv = _top[0];
        for (int i = 1; i < N; i++) {
            if (minv > _top[i]) {
                minv = _top[i];
            }
        }
        return minv;
    }

    /**
     * lJڂ̉l擾 .
     * ΏۃCfbNXQȏ̏ꍇASl̒ōőԂB
     * @return l
     */
    virtual VAL_TYPE getBottom() {
        //_bottom̍őlԂ
        VAL_TYPE maxv = _bottom[0];
        for (int i = 1; i < N; i++) {
            if (maxv > _bottom[i]) {
                maxv = _bottom[i];
            }
        }
        return maxv;
    }

    /**
     * lJڂ~B iSΏۃCfbNXwj .
     */
    virtual void stop() {
        for (int i = 0; i < N; i++) {
            stop(i);
        }
    }

    /**
     * lJڂ~B iΏۃCfbNXPʂŎwj.
     * @param prm_idx
     */
    virtual void stop(int prm_idx) {
        _velo[prm_idx] = 0;
        _acce[prm_idx] = 0;
        _method[prm_idx] = NO_TRANSITION;
    }

    /**
     * ГlJځiSΏۃCfbNXEt[wj .
     * ڕW̑Jڂֈ葬xŒlJڂ
     * @param prm_target_T ڕWJ
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinerUntil(VAL_TYPE prm_target, frame prm_spend_frame) {
        for (int i = 0; i < N; i++) {
            transitionLinerUntil(i, prm_target, prm_spend_frame);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEt[wj .
     * ڕW̑Jڂֈ葬xŒlJڂB
     * @param prm_idx ΏۃCfbNX
     * @param prm_target_T ڕWJ
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinerUntil(int prm_idx, VAL_TYPE prm_target, frame prm_spend_frame) {
        _beat_frame_count[prm_idx] = 0;
        _beat_target_frames[prm_idx] = prm_spend_frame;
        _target[prm_idx] = prm_target;
        _method[prm_idx] = TARGET_LINER_TO;
        //ŏ̃A^bN܂ł̑x
        VAL_TYPE val = getValue(prm_idx);
        if (_beat_target_frames[prm_idx] > 0 ) {
            _velo[prm_idx] = (VAL_TYPE)( ((double)(_target[prm_idx] - val)) / ((double)(_beat_target_frames[prm_idx])) );
        } else if (_beat_target_frames[prm_idx] == 0 ) {
            _velo[prm_idx] = _target[prm_idx] - val;
        }
    }

    /**
     * Jڂ֕ГlJځiSΏۃCfbNXEt[wj .
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinerToTop(frame prm_spend_frame) {
        transitionLinerUntil(getTop(), prm_spend_frame);
    }

    /**
     * Jڂ֕ГlJځiSΏۃCfbNXEt[wj .
     * @param prm_spend_frame ₷t[
     */
    virtual void transitionLinerToBottom(frame prm_spend_frame) {
        transitionLinerUntil(getBottom(), prm_spend_frame);
    }

    /**
     * ГlJځiSΏۃCfbNXEJڑxwj .
     * ڕW̑Jڂֈ葬xŒlJڂ
     * @param prm_target_T ڕWJ
     * @param prm_velo_T t[ZJڍ(>0.0)B̑Jڂw肷鎖BZZ͎fB
     */
    virtual void transitionLinerStep(VAL_TYPE prm_target, VAL_TYPE prm_velo) {
        for (int i = 0; i < N; i++) {
            transitionLinerStep(i, prm_target, prm_velo);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEJڑxwj .
     * ڕW̑Jڂֈ葬xŒlJڂiJڍwj .
     * @param prm_idx ΏۃCfbNX
     * @param prm_target_T ڕWJ
     * @param prm_velo_T t[ZJڍ(>0.0)B̑Jڂw肷鎖BZZ͎fB
     */
    virtual void transitionLinerStep(int prm_idx, VAL_TYPE prm_target, VAL_TYPE prm_velo) {
        _method[prm_idx] = TARGET_LINER_STEP;
        _velo[prm_idx] = prm_velo;
        _target[prm_idx] = prm_target;
        _beat_frame_count[prm_idx] = 0;
        _beat_target_frames[prm_idx] = MAX_FRAME;
    }

    /**
     * ГlJځiSΏۃCfbNXEJڑxEJډxwj .
     * ڕW̑Jڂ։wŒlJڂ
     * Jډx0Ɏw肷 transitionLinerStep ƂقړӖɂȂB
     * transitionLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * Jډx̏ꍇAڕWJڂ𒴂ƒlJڏIB
     * Jډx̏ꍇAڕWJڂƒlJڏIB
     * @param prm_target_T ڕWJ
     * @param prm_velo_T Jڑx
     * @param prm_acce_T Jډx
     */
    virtual void transitionAcceStep(VAL_TYPE prm_target, VAL_TYPE prm_velo, VAL_TYPE prm_acce) {
        for (int i = 0; i < N; i++) {
            transitionAcceStep(i, prm_target, prm_velo, prm_acce);
        }
    }

    /**
     * ГlJځiΏۃCfbNXPʁEJڑxEJډxwj .
     * ڕW̑Jڂ։wŒlJڂiJڑxAJډxwj .
     * Jډx0Ɏw肷 transitionLinerStep ƂقړӖɂȂB
     * transitionLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * @param prm_idx ΏۃCfbNX
     * @param prm_target_T ڕWJ
     * @param prm_velo_T Jڑx
     * @param prm_acce_T Jډx
     */
    virtual void transitionAcceStep(int prm_idx, VAL_TYPE prm_target, VAL_TYPE prm_velo, VAL_TYPE prm_acce) {
        _method[prm_idx] = TARGET_ACCELERATION_STEP;
        _target[prm_idx] = prm_target;
        _velo[prm_idx] = prm_velo;
        _acce[prm_idx] = prm_acce;
        _beat_frame_count[prm_idx] = 0;
        _beat_target_frames[prm_idx] = MAX_FRAME;
    }

    /**
     * lJځiSΏۃCfbNXEt[wj .
     * Jڂֈ葬xŒlJڂA葬xŉJڂ֖߂B[vw肷BiP[ṽt[wj .
     * @param prm_roop_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(1.2ȂǏŎw\A-1 łقږ[v)
     * @param prm_is_to_top true:߂TOPɑJڂ^false:߂BOTTOMɑJ
     */
    void transitionLinerLoop(frame prm_roop_frames, double prm_beat_num, bool prm_is_to_top) {
        for (int i = 0; i < N; i++) {
            transitionLinerLoop(i, prm_roop_frames, prm_beat_num, prm_is_to_top);
        }
    }

    /**
     * lJځiΏۃCfbNXPʁEt[wj
     * Jڂֈ葬xŒlJڂA葬xŉJڂ֖߂B
     * [vw肷BiP[ṽt[wj .
     * @param prm_idx ΏۃCfbNX
     * @param prm_roop_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(1.2ȂǏŎw\A-1 łقږ[v)
     * @param prm_is_to_top true:߂TOPɑJڂ^false:߂BOTTOMɑJ
     */
    virtual void transitionLinerLoop(int prm_idx, frame prm_roop_frames, double prm_beat_num, bool prm_is_to_top) {
        VAL_TYPE val = getValue(prm_idx);
        _method[prm_idx] = BEAT_LINER;
        _beat_frame_count[prm_idx] = 0;
        _beat_frame_count_in_roop[prm_idx] = 0;
        _beat_roop_frames[prm_idx] = prm_roop_frames;
        if (prm_beat_num < 0) {
            _beat_target_frames[prm_idx] = MAX_FRAME;
        } else {
            _beat_target_frames[prm_idx] = prm_roop_frames * prm_beat_num;
        }
        if (prm_is_to_top) {
            _velo[prm_idx] = 1.0*(_top[prm_idx] - val) / ((int)prm_roop_frames / 2.0);
            if (ZEROd_EQ(_velo[prm_idx])) {
                _velo[prm_idx] = 1; //ł΂悢
            }
        } else {
            _velo[prm_idx] = 1.0*(_bottom[prm_idx] - val) / ((int)prm_roop_frames / 2.0);
            if (ZEROd_EQ(_velo[prm_idx])) {
                _velo[prm_idx] = -1; //ł΂悢
            }
        }
    }


//    virtual void transitionTrigonometricLoop(int prm_idx, frame prm_roop_frames, double prm_beat_num, bool prm_is_to_top) {
//        VAL_TYPE val = getValue(prm_idx);
//        _method[prm_idx] = BEAT_TRIGONOMETRIC;
//        _beat_frame_count[prm_idx] = 0;
//        _beat_frame_count_in_roop[prm_idx] = 0;
//        _beat_roop_frames[prm_idx] = prm_roop_frames;
//        if (prm_beat_num < 0) {
//            _beat_target_frames[prm_idx] = MAX_FRAME;
//        } else {
//            _beat_target_frames[prm_idx] = prm_roop_frames * prm_beat_num;
//        }
//        if (prm_is_to_top) {
//            _velo[prm_idx] = 1.0*(_top[prm_idx] - val) / ((int)prm_roop_frames / 2.0);
//            if (ZEROd_EQ(_velo[prm_idx])) {
//                _velo[prm_idx] = 1; //ł΂悢
//            }
//        } else {
//            _velo[prm_idx] = 1.0*(_bottom[prm_idx] - val) / ((int)prm_roop_frames / 2.0);
//            if (ZEROd_EQ(_velo[prm_idx])) {
//                _velo[prm_idx] = -1; //ł΂悢
//            }
//        }
//    }

    /**
     * `g̔g`ŒlJڂBiSΏۃCfbNXwj.
     * <PRE>
     * D  _ _ _   QQQ   _ _ _ _ _ _ _ _ _    QQQ   _ _ _ _ _ _ _ _ _
     *            /:    :_                     /      _
     *           / :    :  _                  /         _
     *          /  :    :    _               /            _
     *         /   :    :      _            /               _
     *        /    :    :        _         /                  _
     * EQQ/  _ _:_ _ : _ _ _ _  _QQQ/  _ _ _ _ _ _ _ _ _  _QQQ/
     *       @
     *       ABC
     * </PRE>
     * KvȐݒl<BR>
     * @ P[v(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN܂ł̃t[<BR>
     * B ێt[<BR>
     * C t[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEforceRange()̐ݒlgpB<BR>
     * @param prm_roop_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_decay_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void beat(frame prm_roop_frames,
                      frame prm_attack_frames,
                      frame prm_sustain_frames,
                      frame prm_decay_frames,
                      double prm_beat_num) {
        for (int i = 0; i < N; i++) {
            beat(i, prm_roop_frames, prm_attack_frames, prm_sustain_frames, prm_decay_frames, prm_beat_num);
        }
    }

    /**
     * `g̔g`ŒlJڂBiΏۃCfbNXʎwj.
     * <PRE>
     * D  _ _ _   QQQ   _ _ _ _ _ _ _ _ _    QQQ   _ _ _ _ _ _ _ _ _
     *            /:    :_                     /      _
     *           / :    :  _                  /         _
     *          /  :    :    _               /            _
     *         /   :    :      _            /               _
     *        /    :    :        _         /                  _
     * EQQ/  _ _:_ _ : _ _ _ _  _QQQ/  _ _ _ _ _ _ _ _ _  _QQQ/
     *       @
     *       ABC
     * </PRE>
     * KvȐݒl<BR>
     * @ P[v(ωČɖ߂܂)ɔ₷t[<BR>
     * A A^bN܂ł̃t[<BR>
     * B ێt[<BR>
     * C t[<BR>
     * D Jڏ(_top[ΏۃCfbNX] z񂪕ێ)<BR>
     * E Jډ(_bottom[ΏۃCfbNX] z񂪕ێ)<BR>
     * ̓ @`CŐݒADEforceRange()̐ݒlgpB<BR>
     * @param prm_idx ΏۃCfbNX
     * @param prm_roop_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_sustain_frames }ŇB̃t[
     * @param prm_decay_frames }ŇC̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    virtual void beat(int prm_idx,
                      frame prm_roop_frames,
                      frame prm_attack_frames,
                      frame prm_sustain_frames,
                      frame prm_decay_frames,
                      double prm_beat_num) {
        _method[prm_idx] = BEAT_TRIANGLEWAVE;
        _beat_frame_count[prm_idx] = 0;
        _beat_frame_count_in_roop[prm_idx] = 0;
        _beat_frame_of_attack_finish[prm_idx] = prm_attack_frames;
        _beat_frame_of_sustain_finish[prm_idx] = _beat_frame_of_attack_finish[prm_idx] + prm_sustain_frames;
        _beat_frame_of_decay_finish[prm_idx] = _beat_frame_of_sustain_finish[prm_idx] + prm_decay_frames;
        _beat_roop_frames[prm_idx] = prm_roop_frames; //
        if (prm_beat_num < 0) {
            _beat_target_frames[prm_idx] = MAX_FRAME;
        } else {
            _beat_target_frames[prm_idx] = _beat_roop_frames[prm_idx] * prm_beat_num;
        }
        //ŏ̃A^bN܂ł̑x
        VAL_TYPE val = getValue(prm_idx);
        if (_beat_frame_of_attack_finish[prm_idx] > 0 ) {
            _velo[prm_idx] = (VAL_TYPE)( ((double)(_top[prm_idx] - val)) / ((double)(_beat_frame_of_attack_finish[prm_idx])) );
        } else if (_beat_frame_of_attack_finish[prm_idx] == 0 ) {
            _velo[prm_idx] = _top[prm_idx] - val;
        }
    }

    /**
     * lJڒǂׂ .
     * @param prm_idx ΏۃCfbNX
     * @return true/false
     */
    virtual bool isTransitioning(int prm_idx) {
        if (_method[prm_idx] == NO_TRANSITION) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * lJڒǂׂ .
     * @return true/false
     */
    virtual bool isTransitioning() {
        for (int i = 0; i < N; i++) {
            if (_method[i] != NO_TRANSITION) {
                return true;
            }
        }
        return false;
    }

    virtual void reset() {
        for (int i = 0; i < N; i++) {
            _velo[i] = 0;
            _acce[i] = 0;
            _target[i] = 0;
            _top[i] = 0;
            _bottom[i] = 1;
            _beat_frame_of_attack_finish[i] = 0;
            _beat_frame_of_sustain_finish[i] = 0;
            _beat_frame_of_decay_finish[i] = 0;
            _beat_roop_frames[i] = 0;
            _beat_target_frames[i] = 0;
            _beat_frame_count_in_roop[i] = 0;
            _beat_frame_count[i] = 0;
            _method[i] = NO_TRANSITION;
        }
    }

    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     * @param s KpJnCfbNX
     * @param n KpCfbNX
     */
    virtual void behave(int s = 0, int n = N) {

        for (int i = s; i < s+n; i++) {
            TransitionMethod method = _method[i];
            VAL_TYPE val = getValue(i);
            VAL_TYPE top = _top[i];
            VAL_TYPE bottom = _bottom[i];
            _beat_frame_count[i]++;
            _velo[i] += _acce[i];
            val += _velo[i];

            if (method == NO_TRANSITION) {
                //Ȃ
            } else {
                if (method == TARGET_LINER_TO) {
                    if (_beat_frame_count[i] == _beat_target_frames[i]) {
                        val = _target[i];
                        stop(i);//I
                    }
                } else if (method == TARGET_LINER_STEP || method == TARGET_ACCELERATION_STEP) {
                    if ((_velo[i] > 0  && val >= _target[i]) || (_velo[i] < 0  && val <= _target[i])) {
                        val = _target[i];
                        stop(i);//I
                    }
                } else if (method == BEAT_LINER) {
                    _beat_frame_count_in_roop[i]++;
                    frame cnt = _beat_frame_count_in_roop[i];
                    if (cnt == _beat_roop_frames[i]/2) {
                        //܂Ԃ
                        if (_velo[i] > 0) { //R
                            val = top;
                            _velo[i] = (VAL_TYPE)( (2.0*(bottom-top)) / ((double)_beat_roop_frames[i]) ); //̑x
                        } else if (_velo[i] < 0) { //J
                            val = bottom;
                            _velo[i] = (VAL_TYPE)( (2.0*(top-bottom)) / ((double)_beat_roop_frames[i]) ); //̑x
                        }
                    }
                    if (cnt == _beat_roop_frames[i]) {
                        //P[vI
                        if (_velo[i] > 0) { //R
                            val = top;
                            _velo[i] = (VAL_TYPE)( (2.0*(bottom-top)) / ((double)_beat_roop_frames[i]) ); //̑x
                        } else if (_velo[i] < 0) { //J
                            val = bottom;
                            _velo[i] = (VAL_TYPE)( (2.0*(top-bottom)) / ((double)_beat_roop_frames[i]) ); //̑x
                        }
                        _beat_frame_count_in_roop[i] = 0;
                    }
//                } else if (method == BEAT_TRIGONOMETRIC) {
//                    _beat_frame_count_in_roop[i]++;
//                    frame cnt = _beat_frame_count_in_roop[i];
//                    angle p = (double)cnt / (double)_beat_roop_frames[i]
//                    val =(-ANG_COS(p) + 1.0) * (top-bottom)
                } else if (method == BEAT_TRIANGLEWAVE) {
                    _beat_frame_count_in_roop[i]++;
                    frame cnt = _beat_frame_count_in_roop[i];
                    //A^bNI
                    if (cnt == _beat_frame_of_attack_finish[i]) {
                        val = top;
                        _velo[i] = 0;
                    }
                    //ێI
                    if (cnt == _beat_frame_of_sustain_finish[i]) {
                        val = top;
                        frame attenuate_frames = _beat_frame_of_decay_finish[i] - _beat_frame_of_sustain_finish[i]; //
                        //܂ł̌xݒ
                        if (attenuate_frames > 0)  {
                            _velo[i] = (VAL_TYPE)( (double)(bottom-top) / ((double)attenuate_frames) );
                        } else {
                            _velo[i] = bottom-top;
                        }
                    }
                    //I
                    if (cnt == _beat_frame_of_decay_finish[i]) {
                        val = bottom;
                        _velo[i] = 0;
                    }
                    //xeI
                    if (cnt == _beat_roop_frames[i]) {
                        val = bottom;
                        _beat_frame_count_in_roop[i] = 0;
                        //̃A^bNւ̑xݒ
                        if (_beat_frame_of_attack_finish[i] > 0 ) {
                            _velo[i] = (VAL_TYPE)( ((double)(top - val)) / ((double)_beat_frame_of_attack_finish[i]) );
                        } else if (_beat_frame_of_attack_finish[i] == 0 ) {
                            _velo[i] = 0;
                            val = top;
                        }
                    }
                }
            }

            if (top < val) {
                val = top;
            } else if (bottom >  val) {
                val =  bottom;
            }

            setValue(i, val); //f

            if (_beat_frame_count[i] == _beat_target_frames[i]) {
                stop(i);//I
            }
        }
    }

    virtual ~GgafValueTransitioner() {
    }
};


}
#endif /*GGAFCORE_GGAFVALUETRANSITIONER_H_*/

