#include "jp/ggaf/core/util/GgafLinearOctreeElem.h"

#include "jp/ggaf/core/util/GgafLinearOctreeSpace.h"
#include "jp/ggaf/core/util/GgafLinearOctree.h"

using namespace GgafCore;

GgafLinearOctreeElem::GgafLinearOctreeElem(GgafObject* prm_pObject, uint32_t prm_kindbit) : GgafObject() {
    _pSpace_current = nullptr;
    _pNext = nullptr;
    _pPrev = nullptr;
    _pObject = prm_pObject;
    _kindbit = prm_kindbit;
    _pLinearOctree = nullptr;
    _pRegLinkNext = nullptr;
}

void GgafLinearOctreeElem::clear() {
    if(_pSpace_current == nullptr) {
        //_TRACE_("GgafLinearOctreeElem::extract() ł܂BӐ}Ă܂H");
        return;
    }
    //񃊃Zbg
    uint32_t index = _pSpace_current->_my_index;
    GgafLinearOctreeSpace* paSpace = _pLinearOctree->_paSpace;
    while (true) {
        if (paSpace[index]._kindinfobit == 0 ) {
            break;
        } else {
            paSpace[index]._kindinfobit = 0;
            paSpace[index]._pElem_first = nullptr;
            paSpace[index]._pElem_last = nullptr;
        }

        if (index == 0) {
            break;
        }
        // eԗvfԍŌJԂ
        index = (index-1)>>3;
    }
    _pNext = nullptr;
    _pPrev = nullptr;
    _pSpace_current = nullptr;

//vf͊eԂɃXgɂԂ牺Ă邽߁Aclear() ̋@\{YɎȂ΁A
//Ԃ _kindinfobit  XOR ȂǂărbgAZbgA
//_pElem_firstA_pElem_last ̃|C^̍iXgj؂藣ׂłB
//Aǂ clear() gp̂́ASԑSvfNAƂł̂ŁA
//_kindinfobit ́Al 0 ݒB _pElem_first  _pElem_last ȂnullptrŃNAB
//P clear() ƂƁAԏ͕邱Ƃ𒍈ӁAAvP[VWbN clear() ͎gpȂƁB
//{c[́Ao^ƁANÂݍsƂ݌v
}

void GgafLinearOctreeElem::belongTo(GgafLinearOctreeSpace* prm_pSpace_target) {
    if (_pSpace_current == prm_pSpace_target) {
        //_TRACE_("belongToł");
        return;
    } else {
        if (prm_pSpace_target->_pElem_first == nullptr) {
            //PԖڂɒǉ̏ꍇ
            prm_pSpace_target->_pElem_first = this;
            prm_pSpace_target->_pElem_last = this;
//nullptrclearݒς݁BȗĂvȂ͂B
//            _pNext = nullptr;
//            _pPrev = nullptr;
            _pSpace_current = prm_pSpace_target;
        } else {
            //ɒǉ̏ꍇ
            prm_pSpace_target->_pElem_last->_pNext = this;
            _pPrev = prm_pSpace_target->_pElem_last;
//nullptrclearݒς݁BȗĂvȂ͂B
//            _pNext = nullptr;
            prm_pSpace_target->_pElem_last = this;
            _pSpace_current = prm_pSpace_target;
        }
    }
    //̗vfԍ
    uint32_t index = prm_pSpace_target->_my_index;
    GgafLinearOctreeSpace* paSpace = _pLinearOctree->_paSpace;
    uint32_t this_kindbit = this->_kindbit;
    //eԂׂĂɗvfʏ𗬂
    while (true) {
        if (paSpace[index]._kindinfobit & this_kindbit) {
            //ʏ񂪐ݒς݂Ȃ΁Aȏ̐eݒςׁ݂̈A
            break;
        } else {
            //ԂɎʏ񂪖ݒȂΐݒ
            paSpace[index]._kindinfobit |= this_kindbit;
        }
        if (index == 0) {
            break;
        }
        //̐eԗvfԍŌJԂ
        index = (index-1)>>3;
    }
}

void GgafLinearOctreeElem::dump() {
    _TEXT_("o");
}

GgafLinearOctreeElem::~GgafLinearOctreeElem() {
}
