#ifndef GGAFDXCORE_GGAFDXKUROKOHELPERB_H_
#define GGAFDXCORE_GGAFDXKUROKOHELPERB_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/core/util/GgafValueAccelerator.hpp"

namespace GgafDxCore {

/**
 * ߂̏B .
 * t()̎]ppx̕⍲s܂B
 * @version 1.00
 * @since 2013/12/05
 * @author Masatoshi Tsuge
 */
class GgafDxKurokoAssistantB : public GgafCore::GgafObject {

public:
    /** [r]t */
    GgafDxKuroko* _pMaster;
    GgafCore::GgafValueAccelerator<int> _smthFaceAng[3];

public:
    /**
     * RXgN^<BR>
     * @param   prm_pMaster  t
     */
    explicit GgafDxKurokoAssistantB(GgafDxKuroko* prm_pMaster);


    /**
     * ]p炩ɉ]V[NGXs(pwAԎwApxϓ) .
     * p]ړɔ₳鎞(Te)3̃ZNVɕÂ悤ȊpxIɍsB<BR>
     * E 0     `  p1*Te ܂ EEE ݂̊pxgbvpx܂ŉ]x<BR>
     * E p1*Te `  p2*Te ܂ EEE gbvXs[hœpxœ]<BR>
     * E p2*Te `  Te    ܂ EEE gbvXs[hŏIpx։]x<BR>
     * }Q<BR>
     * <pre>
     *
     *    px()
     *     ^
     *     |                         :ڕWړpij    EEE prm_angular_distance
     *     |                        0:_̊px        EEE_angvelo_face[prm_axis]
     *     |                        t:gbvpx          EEEϓAvZ
     *     |                        e:ŏIx              EEE prm_end_angvelo
     *  t|....___________          Te:ڕWԁit[jEEE prm_target_frames
     *     |   /:         :_        p1:gbvpxɒB鎞ƂȂ悤ȁATeɑ΂銄EEE prm_p1
     *  e|../.:.........:.._      p2:]̌Jn鎞ƂȂ悤ȁATeɑ΂銄EEE prm_p2
     *     | /  :         :    |
     *     |/   :         :    |
     *  0|    :       :    |
     *     |    :         :    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |  p1*Te     p2*Te  Te
     *
     * </pre>
     * @param prm_axis ]p(AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_angular_distance ڕWp()iɂ]LBFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e) iŐprm_angular_distance̐ɍ킹j
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnFaceAngByDt(axis prm_axis,
                             angle prm_angular_distance, int prm_target_frames,
                             float prm_p1, float prm_p2, angvelo prm_end_angvelo,
                             bool prm_endacc_flg);

    /**
     * ڕW̎]p(Z)֊炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_ang_rz_target BڕWZ]p
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e) iŐprm_angular_distance̐ɍ킹j
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnRzFaceAngByDtTo(angle prm_ang_rz_target, int prm_way, int prm_target_frames,
                                 float prm_p1, float prm_p2, angvelo prm_end_angvelo,
                                 bool prm_endacc_flg);

    /**
     * ڕW̎]p(Y)֊炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_ang_rt_target BڕWY]p
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e) iŐprm_angular_distance̐ɍ킹j
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnRyFaceAngByDtTo(angle prm_ang_rt_target, int prm_way, int prm_target_frames,
                             float prm_p1, float prm_p2, angvelo prm_end_angvelo,
                             bool prm_endacc_flg);
    /**
     * ڕW̎]p(X)֊炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_ang_rt_target BڕWX]p
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e) iŐprm_angular_distance̐ɍ킹j
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void spinRxFaceAngByDtTo(angle prm_ang_rx_target, int prm_way, int prm_target_frames,
                                     float prm_p1, float prm_p2, angvelo prm_end_angvelo,
                                     bool prm_endacc_flg);

    /**
     * ڕW̎]p֊炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_ang_rz_target ڕWZ]p
     * @param prm_ang_ry_target ڕWY]p
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     *                         true:  prm_ang_rz_target, prm_ang_ry_target ܂ł̋ƁA<BR>
     *                               Ӗg RzRy ܂ł̋oA<BR>
     *                               Bt[̏Ȃ RzRy ̑gݍ킹̗pB<BR>
     *                               ]̕ɍŒZt[Ń^[Qbg邪A _angMvRz, _angMvRy <BR>
     *                               ̃^[QbgAOlƈvȂȂB(pقȂ\L)<BR>
     *                               (ӁFɒnY]邽߁AŒZt[͕KŒZɂ炸)<BR>
     *                         false: prm_ang_rz_target, prm_ang_ry_target ̂܂܃^[Q[gƂB<BR>
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e)
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnRzRyFaceAngByDtTo(
            angle prm_ang_rz_target, angle prm_ang_ry_target, int prm_way, bool prm_optimize_ang,
            int prm_target_frames,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    /**
     * ڕW̍WɌ悤ɁA炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_tx ڕWXW
     * @param prm_ty ڕWYW
     * @param prm_tz ڕWZW
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e)
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnFaceAngByDtTwd(
            coord prm_tx, coord prm_ty, coord prm_tz, int prm_way, bool prm_optimize_ang,
            int prm_target_frames,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    /**
     * ڕW̃AN^[̍WɌ悤ɁA炩ɉ]V[NGXs(ԎwApxϓ) .
     * @param prm_pActor_target ڕWAN^[
     * @param prm_way ^[Qbg邽߂́A]wB̂ꂩwB<BR>
     *                TURN_COUNTERCLOCKWISE/TURN_CLOCKWISE/TURN_CLOSE_TO/TURN_ANTICLOSE_TO
     * @param prm_optimize_ang ^[QbgAOœK邩ǂwB<BR>
     * @param prm_target_frames ₷(Te)(t[wA͕̐s)
     * @param prm_p1 gbvXs[hɒB鎞ƂȂ悤ȁATeɑ΂銄(p1)
     * @param prm_p2 JnƂȂ悤ȁATeɑ΂銄(p2)
     * @param prm_end_angvelo ڕWB̍ŏIpx(e)
     * @param prm_endacc_flg true:ڕWړɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnFaceAngByDtTwd(
            GgafDxGeometricActor* prm_pActor_target, int prm_way, bool prm_optimize_ang,
            int prm_target_frames,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    /**
     * ڕW̎]p(Z)֊炩ɉ]V[NGXs(xEwAԕϓ) .
     * ړ3̃ZNV(1,2,3)ɕÂ悤ȊpxIɍsB<BR>
     * Ep 0       ` p 1         ܂ EEE ݂̃ƑxgbvXs[h܂Ŋp(or)]<BR>
     * Ep 1     ` p 1+2     ܂ EEE gbvXs[hœp]<BR>
     * Ep 1+2 ` p 1+2+3 ܂ EEE gbvXs[hŏIXs[h֊p(or)]<BR>
     * }Q<BR>
     * <pre>
     *    px()
     *     ^
     *     |                        0:_̊px
     *     |                        t:gbvpx
     *     |                        e:ŏIpx
     *     |       =1+2+3    :ڕW]p
     *  t|....___________          p1:gbvpxɒBpƂȂ悤ȁAƂɑ΂銄
     *     |   /|         |_            ܂     1 = *p1 ƂȂ悤 p1 (0.0`1.0)
     *  e|../.|.........|.._      p2:JnƂȂ悤ȁAƑ΂銄
     *     | /  |         |    |         ܂ 1+2 = *p2 ƂȂ悤 p2 (0.0`1.0)
     *     |/   |         |    |     Te:₳Kvԁit[j
     *  0|1 |   2   |3 |
     *     |    |         |    |
     *   --+----+---------+----+-----> (t:t[)
     *   0 |                  Te
     *
     * </pre>
     * gbvXs[h(t)AŏIXs[h(e)AڕW]p()Ay p1, p2 w肷B<BR>
     * ₳鎞(Te)͓Ŏv肳B<BR>
     * <BR>
     * @param prm_axis ]p(AXIS_X or AXIS_Y or AXIS_Z)
     * @param prm_top_angvelo gbvpx(t)
     * @param prm_angular_distance ڕWp()iɂ]LBFTURN_COUNTERCLOCKWISEAFTURN_CLOCKWISEj
     * @param prm_p1 gbvXs[hɒB鋗ƂȂ悤ȁA]p()ɑ΂銄B(1 = *prm_p1)
     * @param prm_p2 p]̌JnpƂȂ悤ȁA]p()ɑ΂銄 (1+2 = *p2)
     * @param prm_end_angvelo ŏIpx(e)
     * @param prm_endacc_flg true:ڕWԂɒBۂɊpxOɋݒ/false:px͂̂܂܂ɂĂ
     */
    void turnFaceAngByVd(
            axis prm_axis,
            angvelo prm_top_angvelo, angle prm_angular_distance,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    void turnRzFaceAngByVdTo(
            angvelo prm_top_angvelo, angle prm_ang_rz_target, int prm_way,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    void turnRyFaceAngByVdTo(
            angvelo prm_top_angvelo, angle prm_ang_ry_target, int prm_way,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    void spinRxFaceAngByVdTo(
            angvelo prm_top_angvelo, angle prm_ang_rx_target, int prm_way,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);


    void turnRzRyFaceAngByVdTo(
            angvelo prm_top_angvelo,
            angle prm_ang_rz_target, angle prm_ang_ry_target, int prm_way, bool prm_optimize_ang,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    void turnFaceAngByVdTwd(
            angvelo prm_top_angvelo,
            coord prm_tx, coord prm_ty, coord prm_tz, int prm_way, bool prm_optimize_ang,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    void turnFaceAngByVdTwd(
            angvelo prm_top_angvelo,
            GgafDxGeometricActor* prm_pActor_target, int prm_way, bool prm_optimize_ang,
            float prm_p1, float prm_p2, angvelo prm_end_angvelo,
            bool prm_endacc_flg);

    inline bool isTurningFaceAng() {
        if (_smthFaceAng[AXIS_X]._prm._flg || _smthFaceAng[AXIS_Y]._prm._flg || _smthFaceAng[AXIS_Z]._prm._flg) {
            return true;
        } else {
            return false;
        }
    }

    inline void stopTurnFaceAng() {
        _smthFaceAng[AXIS_X]._prm._flg = false;
        _smthFaceAng[AXIS_Y]._prm._flg = false;
        _smthFaceAng[AXIS_Z]._prm._flg = false;
    }

    /**
     * ߂̏肪U镑 .
     * 肪Atɂ낢ݒs܂̂ŁAtU镑(behave())OɎs܂傤B
     */
    virtual void behave();

    virtual ~GgafDxKurokoAssistantB();
};

}
#endif /*GGAFDXCORE_GGAFDXKUROKOHELPERB_H_*/

