#include "jp/ggaf/lib/actor/WorldBoundActor.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/lib/DefaultGod.h"
#include "jp/ggaf/lib/scene/DefaultUniverse.h"
#include "jp/ggaf/lib/actor/DefaultCamera.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

WorldBoundActor::WorldBoundActor(const char* prm_name, const char* prm_model) :
        GgafDxWorldBoundActor(prm_name,
                              prm_model,
                              "WorldBoundEffect",
                              "WorldBoundTechnique",
                              nullptr,
                              nullptr) {

    _class_name = "WorldBoundActor";
    _offset_frames = 0;
    setSpecialDrawDepth(DRAW_DEPTH_LEVEL_WORLDBOUND);

    setZEnable(false);        //Zobt@͍l
    setZWriteEnable(false);  //Zobt@͏ݖ
}

void WorldBoundActor::initialize() {
    dxcoord dxworld_r = P_CAM->_zf-P_CAM->_zn; //EEa
    dxcoord dxmodel_r = 1.0f; //WorldBoundActor̃f͔aDIRECTX1̋ł鎖O
    _sx = _sy = _sz = R_SC(dxworld_r/dxmodel_r)*0.989;
}


void WorldBoundActor::processSettlementBehavior() {
    //ʊO薳ɔȂȗB
    //̏𖳎Ă܂
    //Eg{[̍l
    //EWؓo^
    //E䂩̋vZ
    //GgafDxGeometricActor::processSettlementBehavior() Ɠ鎖I
    positionAs(P_CAM);
    _fX = C_DX(_x);
    _fY = C_DX(_y);
    _fZ = C_DX(_z);
    UTIL::setWorldMatrix_ScRxRzRyMv(this, _matWorld); //[hϊ
}
//void WorldBoundActor::processPreDraw() {
//    //ʊO薳ɔȂȗ
//    //̏𖳎Ă܂
//    //EiK_O̐[xvZ
//    //EꎞeNjbNl
//    //GgafDxDrawableActor::processPreDraw() Ɠ鎖I
//    if (_pModel->_is_init_model == false) {
//        onCreateModel(); //f쐬̏
//        _pModel->_is_init_model = true;
//    }
//    GgafDxUniverse::setDrawDepthLevel(MAX_DRAW_DEPTH_LEVEL,this); //Ő[
//}

WorldBoundActor::~WorldBoundActor() {
}
