#include "MyLockonController.h"

#include "EffectLockon001_Main.h"
#include "EffectLockon001_Sub.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

/** PIvV̍ő\bNI */
int MyLockonController::max_lockon_num_ = 8;
int MyLockonController::lockon_num_ = 0;


MyLockonController::MyLockonController(const char* prm_name) :
        GgafDummyActor(prm_name, nullptr) {
    _class_name = "MyLockonController";
    pRingTarget_ = NEW GgafLinkedListRing<GgafDxCore::GgafDxGeometricActor>();
    pMainLockonEffect_ = NEW EffectLockon001_Main("MAIN");
    pMainLockonEffect_->inactivate();
    addSubLast(pMainLockonEffect_);
    for (int i = 1; i < MyLockonController::max_lockon_num_; i++) {
        std::string name = "SubLockon("+XTOS(i)+")";
        EffectLockon001_Sub* pSubLockon = NEW EffectLockon001_Sub(name.c_str());
        pSubLockon->inactivate();
        addSubLast(pSubLockon);
    }
}

void MyLockonController::initialize() {
}
void MyLockonController::onReset() {
    //bNI^[Qbg̃Xgɂ
    pRingTarget_->removeAll();
    //bNIAN^[̃Zbg
    EffectLockon001* pEffectLockon001;
    for (int i = 0; i < MyLockonController::max_lockon_num_; i++) {
        pEffectLockon001 = (EffectLockon001*)(getSub(i));
        pEffectLockon001->releaseLockon();
        pEffectLockon001->inactivate();
    }
}

void MyLockonController::onActive() {
    onReset();
}


void MyLockonController::processBehavior() {
    //bNI^[QbgmF
    GgafDxGeometricActor* pMainLockonTarget = pRingTarget_->getCurrent(); //CbNĨ^[Qbg
    GgafDxGeometricActor* pTarget = pRingTarget_->getCurrent();  //^[QbgJ[\
    GgafMainActor* pLockonEffect_Active = (GgafMainActor*)getSubFirst();         //bNIGtFNgJ[\
    int n = pRingTarget_->length();
    for (int i = 0; i < n; i++) {
        if (pTarget->isActiveInTheTree() && pTarget->getStatus()->get(STAT_Stamina) > 0) {
            //^[QbgȂ
            //GtFNgAN^[̃^[QbgXVAGtFNgYƂ܂
            ((EffectLockon001*)pLockonEffect_Active)->lockon(pTarget);
            if (!pLockonEffect_Active->isActiveInTheTree()) {
                pLockonEffect_Active->activate();
            }
            pLockonEffect_Active = pLockonEffect_Active->getNext(); //񏈗bNIGtFNgAN^[
            pTarget = pRingTarget_->next();                         //񏈗^[Qbg
        } else {
            //^[QbgS
            if (pTarget == pMainLockonTarget) {
                //S^[QbgCbNĨ^[Qbgłꍇ
                if (pRingTarget_->length() == 1) {
                    //S^[QbgCbNĨ^[QbgŃO̍Ō̈̏ꍇ
                    pRingTarget_->remove();                                    //^[Qbgo
                    ((EffectLockon001*)pLockonEffect_Active)->releaseLockon(); //bNIGtFNg[Xs
                    pTarget = nullptr;
                    break;
                } else {
                    //S^[QbgCbNĨ^[QbgŃO̍Ō̈ł͖ꍇ
                    pRingTarget_->remove();               //^[Qbgo
                    pTarget = pRingTarget_->getCurrent(); //񏈗^[Qbgցiremove()ɂ莟̃^[QbggetCurrent()ƂȂj
                    pMainLockonTarget = pTarget;          //CbNĨ^[QbgXV
                    //CbNIGtFNg𒼋߃bNI֖߂
                    //CbNIGtFNg̎̃GtFNgƂ
                    ((EffectLockon001*)pLockonEffect_Active->getNext())->releaseLockon(); //̃bNIGtFNg[Xs
                    pLockonEffect_Active->getNext()->moveLastImmed();               //̃bNIGtFNg𖖔
                    //u񏈗bNIGtFNgAN^[ցv̏Ώۈړ͕svBɏbNIGtFNgAN^[̂܂܂ł邽߁B
                }
            } else {
                //S^[QbgTubNĨ^[Qbgłꍇ
                pRingTarget_->remove();               //^[Qbgo
                pTarget = pRingTarget_->getCurrent(); //񏈗^[Qbgցiremove()ɂ莟̃^[QbggetCurrent()ƂȂj
                ((EffectLockon001*)pLockonEffect_Active)->releaseLockon(); //bNIGtFNg[Xs
                pLockonEffect_Active = pLockonEffect_Active->getNext();    //񏈗bNIGtFNgAN^[
                pLockonEffect_Active->getPrev()->moveLastImmed();    //񏈗bNIGtFNgAN^[𖖔
            }
        }
    }
}

void MyLockonController::processJudgement() {
}

void MyLockonController::onInactive() {
    onReset();
}

void MyLockonController::lockon(GgafDxGeometricActor* prm_pTarget) {
    if (MyLockonController::lockon_num_ == 0) {
        return; //݂̃bNI\0
    }

    if (pRingTarget_->indexOf(prm_pTarget) == -1) {
        //bNIς݂ɖ̂ŁAbNI
        if (pRingTarget_->length() >= MyLockonController::lockon_num_) { //^[QbgXgɖ̏ꍇ
            //bNI^[Qbg[e[g
            pRingTarget_->prev();           //JgŏIvf
            pRingTarget_->set(prm_pTarget, false); //ŏIvfƂɃC^[Qbg㏑
            //bNIGtFNgAN^[͂̂܂
            //ɂAprocessBehavior() ̃^[Qbĝɂ
            //YbƂB
        } else {   //܂^[QbgXgɉȂA͗]Tiǉ\ȏꍇj
            //^[Qbg[e[g
            pRingTarget_->addPrev(prm_pTarget, false);
            pRingTarget_->prev();
            //bNIGtFNg
            if (pRingTarget_->length() == 1) {
                //ŏ̃bNI^[QbgǉiCbNI^[Qbgj
                GgafMainActor* pLockonEffect = (GgafMainActor*)getSubFirst(); //CbNIGtFNg
                pLockonEffect->activate();
                ((EffectLockon001*)pLockonEffect)->lockon(prm_pTarget);

                //ŏ̃bNI^[QbgȊO̒ǉiTubNI^[Qbgǉj
            } else if (pRingTarget_->length() > 1) {
                //SubbNIǉ
                if (pRingTarget_->length() >= 3) {
                    //Rڂ̈ȍ~^[QbgǉiQڈȍ~̃TubNI^[Qbgǉj
                    //bNIGtFNg̓ȃ[e[gsBiŌ̃Rgǉ̏ꍇQƁj
                    //Last؂o
                    GgafMainActor* pLockonEffect = (GgafMainActor*)getSubFirst()->getPrev(); //Last
                    GgafMainActor* pLockonEffect_Next = pLockonEffect->getNext(); //MainbNIƂȂ
                    GgafMainActor* pLockonEffect_Prev = pLockonEffect->getPrev();
                    pLockonEffect_Prev->_pNext = pLockonEffect_Next;
                    pLockonEffect_Next->_pPrev = pLockonEffect_Prev;
                    pLockonEffect_Prev->_is_last_flg = true;
                    pLockonEffect->_is_last_flg = false;
                    //First->Next ̊Ԃɓ
                    GgafMainActor* pMainLockonEffect = (GgafMainActor*)getSubFirst();
                    GgafMainActor* pMainLockonEffect_Next = (GgafMainActor*)getSubFirst()->getNext();
                    pMainLockonEffect->_pNext = pLockonEffect;
                    pLockonEffect->_pPrev = pMainLockonEffect;
                    pLockonEffect->_pNext = pMainLockonEffect_Next;
                    pMainLockonEffect_Next->_pPrev = pLockonEffect;
                    pLockonEffect->activate(); //TubNIL
                    //TubNIGtFNgbNII
                    ((EffectLockon001*)pLockonEffect)->lockon(pRingTarget_->getNext());
                } else {
                    //Qڂ̃^[Qbgǉiŏ̃TubNI^[Qbgǉj
                    GgafMainActor* pLockonEffect = (GgafMainActor*)getSubFirst()->getPrev(); //QȂ̂ŌNexẗʒu
                    pLockonEffect->activate(); //TubNIL
                    ((EffectLockon001*)pLockonEffect)->lockon(pRingTarget_->getNext());
                }
            }
        }
    } else {
        //prm_pTarget ͊ɃbNIς
    }
}

void MyLockonController::releaseAllLockon() {
    if (pRingTarget_->length() == 0) {
        return;
    }
    pRingTarget_->removeAll();
    //bNIGtFNgCANeBuɂ
    GgafMainActor* pLockonEffect = (GgafMainActor*)getSubFirst();
    while (pLockonEffect) {
        ((EffectLockon001*)pLockonEffect)->releaseLockon();
        if (pLockonEffect->isLast()) {
            break;
        } else {
            pLockonEffect = pLockonEffect->getNext();
        }
    }
}

MyLockonController::~MyLockonController() {
    GGAF_DELETE(pRingTarget_);
}

void MyLockonController::dumpTarget(GgafDxGeometricActor* pMain) {
    if (pRingTarget_->getFromFirst(0) == nullptr) {
        _TEXT_("nullptr\n");
        return;
    } else {
        _TEXT_("");
    }
    for (int i = 0; i < pRingTarget_->length(); i++) {
        if (pRingTarget_->getFromFirst(i) == pMain) {
            _TEXT_("I");
        }
        _TEXT_(pRingTarget_->getFromFirst(i)->getName()<<"["<<i<<"]");
    }
    _TEXT_(" ... avtive="<<pRingTarget_->getCurrent()->getName()<<"\n");
}

//yY^z
//ubNI^[Qbg(G)ƃbNIGtFNg(Ə)̊֌Wv(2010/09/14)
//
//bNIAbNI[X
//bNI^[QbgƃbNIGtFNg̊֌WƂĎcB
//
//l      c CbNIGtFNg
//S0`S3  c TubNIGtFNg
//t1`t5  c bNI^[Qbg
//
//CbNIGtFNg(l)̏ꏊɈʒu郍bNI^[Qbg
//uCbNI^[Qbgv
//TubNIGtFNg(S0`S3)̏ꏊɈʒu郍bNI^[Qbg
//uTubNI^[Qbgv
//ƌĂԂƂɂB

//ǉ̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[
//                      t1bNI
// t1
// GtFNgAN^[ω
//                      t2ǉbNI
// t2t1
// ̂lS3S0S1S2
//                      t3ǉbNI
// t3t2t1
// ̂lS2S3S0S1
//                      t4ǉbNI
// t4t3t2t1
// ̂lS1S2S3S0
//                      t5ǉbNI
// t5t4t3t2t1
// ̂lS0S1S2S3

// Œǉ̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[͑sv
//
// t5t4t3t2t1
// t6t5t4t3t2   Y
// t7t6t5t4t3   Y
// t8t7t6t5t4   Y
// t9t8t7t6t5   YƂ܂

//S̏ꍇ
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t1)
// t5t4t3t2
// ̂lS0S1S2S3    EEEωiS3ցjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t2)
// t5t4t3t1
// ̂lS0S1S3S2    EEES2ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t3)
// t5t4t2t1
// ̂lS0S2S3S1    EEES1ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t4)
// t5t3t2t1
// ̂lS2S3S1S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t5t4t3t2t1
//              remove(t5)
// t4t3t2t1
// ̂lS1S2S3S0    EEE S0ցiӁjړlockonRelase()



//؂ꍇ2
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t1)
// t4t3t1
// ̂lS0S1S3S2    EEES2ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t2)
// t4t3t1
// ̂lS0S2S3S1    EEES1ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t3)
// t4t2t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t4t3t2t1
//              remove(t4)
// t3t2t1
// ̂lS1S2S3S0    EEES0ցiӁjړlockonRelase()



//؂ꍇ3
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t1)
// t3t2
// ̂lS0S2S3S1    EEES1ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t2)
// t3t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t3t2t1
//              remove(t3)
// t2t1
// ̂lS1S2S3S0    EEES0ֈړlockonRelase()



//؂ꍇ4
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t2t1
//              remove(t1)
// t2
// ̂lS1S2S3S0    EEES0ցiȗHjړlockonRelase()

// ̂lS0S1S2S3    EEEGtFNgAN^[
// t2t1
//              remove(t2)
// t2t1
// ̂lS1S2S3S0    EEES0wړlockonRelase()


//؂ꍇ5
// ̂lS0S1S2S3    EEEGtFNgAN^[
// t1
//              remove(t1)
//
// ̂lS1S2S3S0    EEEωMlockonRelase()
