#ifndef ENEMYEMUS_H_
#define ENEMYEMUS_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMorphMeshActor.h"

namespace VioletVreath {

/**
 * G@GX .
 * [U[nb`B
 * @version 1.00
 * @since 2012/10/22
 * @author Masatoshi Tsuge
 */
class EnemyEmus : public GgafLib::DefaultMorphMeshActor {

public:
    enum {
        PROG_INIT       ,
        PROG_HATCH_CLOSE,
        PROG_HATCH_OPEN ,
        PROG_FIRE       ,
        PROG_NOTHING    ,
        PROG_BANPEI,
    };

    enum {
        SE_DAMAGED  ,
        SE_EXPLOSION,
    };

    /** gkxIuWFNg */
    GgafDxCore::GgafDxScaler* pScaler_;

    /** [r] */
    bool is_open_hatch_;
    /** [r/w]nb`JĂt[Ԋu */
    frame frame_of_open_interval_;
    /** [r/w]nb`ĂĂt[Ԋu */
    frame frame_of_close_interval_;
    /** [r/w]nb`J yсAJ ̃[tAj[Vt[ */
    frame frame_of_morph_interval_;

//    /** [r][U[Zbg̃XgA[([U[`bṽf|Wg̃f|Wg) */
//    GgafCore::GgafActorDepositoryStore* pDepoStore_laser_set;
//    /** [r]f|Wg}l[W[ւ̐ڑ */
//    DepositoryConnection* pConn_pDepoStore_laser_set;
    /** [r][U[Zbg([U[`bṽf|Wg) */
    GgafLib::LaserChipDepository* pLaserChipDepo_;

    bool is_firing_;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    EnemyEmus(const char* prm_name);

    /**
     * GXfꂽۂɂP񂾂s鏈
     */
    void onCreateModel() override;
    /**
     * GX̏iCX^Xۏ؁j
     */
    void initialize() override;

    /**
     * GX̂ANeBuɂȂuԂ̏ .
     */
    void onActive() override;

    /**
     * GX̐U镑 .
     */
    void processBehavior() override;

    /**
     * GX̐U镑̔菈 .
     */
    void processJudgement() override;

    /**
     * GX̏Փˎ .
     * @param prm_pOtherActor ՓˑΏ
     */
    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;


    void onInactive() override;

    virtual ~EnemyEmus();
};

}
#endif /*ENEMYEMUS_H_*/

