#ifndef GGAFCORE_GGAFGOD_H_
#define GGAFCORE_GGAFGOD_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <windows.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

#undef P_GOD
#define P_GOD (GgafCore::GgafGod::_pGod)

namespace GgafCore {

#define  BEGIN_SYNCHRONIZED1   ::EnterCriticalSection(&(GgafCore::GgafGod::CS1))
#define  END_SYNCHRONIZED1     ::LeaveCriticalSection(&(GgafCore::GgafGod::CS1))
#define  BEGIN_SYNCHRONIZED2   ::EnterCriticalSection(&(GgafCore::GgafGod::CS2))
#define  END_SYNCHRONIZED2     ::LeaveCriticalSection(&(GgafCore::GgafGod::CS2))
#define  SLOWDOWN_MODE_DEFAULT 0
#define  SLOWDOWN_MODE_40FPS 1
#define  SLOWDOWN_MODE_30FPS 2
/**
 * _NX.
 * ɂ̐(GgafSpacetime)Ǘ삷邱ƂړIƂNXłBԂԂ炢B<BR>
 * {NX be() \bhĂё邱ƂŁA̐ƂɂȂAƂ݌vB<BR>
 * CX^X͂PłB<BR>
 * TODO:O[oȎQƂێ֗NXɂȂGB<BR>
 * TODO:ŏIIɂ _Q new āA݂ be() s΁AQ[Qs삷悤ɂ悤ȁB
 * (:GdxfwWorldNX)
 * @version 1.00
 * @since 2007/11/26
 * @author Masatoshi Tsuge
 */
class GgafGod : public GgafObject {

private:
    /** behavestO */
    bool _is_behaved_flg;
    /** materializestO */
    bool _is_materialized_flg;

public:
    /** [r] NeBJZNV̂P */
    static CRITICAL_SECTION CS1;
    /** [r] NeBJZNV̂Q */
    static CRITICAL_SECTION CS2;
    /** [r] g */
    static GgafGod* _pGod;
    /** [r] H(ʃXbh)̃G[ԁBnullptrғ^not nullptrُ픭 */
    static GgafCriticalException* _pException_factory;
    /** [r] ɂ̐鎞Ԃ̃ItZbg */
    static DWORD _aaTime_offset_of_next_view[3][60];

    /** [r] GgafFactory::work Xbhnh  */
    HANDLE _handleFactory01;
    /** [r] GgafFactory::work XbhID  */
    unsigned int _thID01;
    /** [r] _̃t[JnVXe */
    DWORD _time_at_beginning_frame;
    /** [r] ɂ̐VXe */
    DWORD _time_of_next_view;
    /** [r] _ãt[ */
    frame _frame_of_God;
    int _cnt_frame;

    /** [r] ̐ołȂiXLbvj */
    int _skip_count_of_frame;
    /** [r] ̐ */
    GgafSpacetime* _pSpacetime;
    /** [r] fpsli1000msɌvZj */
    float _fps;

    DWORD _time_calc_fps_next;
    /** [r] `t[JE^ */
    frame _visualize_frames;
    /** [r] OfpsvZ̕`t[JEgl */
    frame _prev_visualize_frames;
#ifdef MY_DEBUG
    /** [r] 1t[̕` */
    static unsigned int _num_drawing;
#endif
    /** [r] 1t[̊AN^[ */
    static unsigned int _num_active_actor;

    /** [r] `揈AōXLbvt[ */
    int _max_skip_frames;
    /** [r] ݂̏[h 0:60fps 1:40fps 2:30fpsB_aaTime_offset_of_next_vieẅڂ̗vf */
    int _slowdown_mode;
    /** [r] Ԃƃt[̓[htrue */
    bool _sync_frame_time;
    bool _was_cleaned;

public:
    /**
     * RXgN^ .
     * ʃXbhōHғ܂B
     */
    GgafGod();

    /**
     * u݂vƂ\bh .
     * _݂AȂ킿A̐(GgafSpacetime)AAvis܂B<BR>
     * ĂяoA̐(GgafSpacetime)쐬܂B<BR>
     * AvP[V́AŏԒPʂł̃\bhЂĂёĂB<BR>
     */
    void be();

    /**
     * ̐́AƂŏԒPʂ̏uԂn .
     */
    virtual void presentSpacetimeMoment();

    /**
     * ̐́AnꂽŏԒPʂ̏uԂɂĐRi`FbNj .
     */
    virtual void executeSpacetimeJudge();

    /**
     * ̐́AnꂽŏԒPʂ̏uԂ .
     */
    virtual void makeSpacetimeMaterialize();

    /**
     * ̐ɕ`AيE̐lԋɂFiڎjł悤ɕ\ʉ .
     */
    virtual void presentSpacetimeVisualize();

    /**
     * ̐̎̍ŏԒPʂ̏uԂn邽߂̏An .
     */
    virtual void finalizeSpacetime();

    /**
     * ̐擾 .
     * ʂŃI[o[Ch\B<BR>
     * @return ̐
     */
    virtual GgafSpacetime* getSpacetime() {
        return _pSpacetime;
    }

    /**
     * ̐n .
     * ʂł̐̑n@ĂB<BR>
     * @return ̐
     */
    virtual GgafSpacetime* createSpacetime() = 0;

    /**
     * `ꎞ~At[ƎԂ̓s
     */
    void syncTimeFrame() {
        _sync_frame_time = true;
    }

    virtual void clean();

    /**
     * _u܂`Iv .
     * OɃR[obN܂B
     */
    virtual void oops() {
        _TRACE_("(-_-;) {Oops!");
    }

    virtual ~GgafGod();
};

}
#endif /*GGAFCORE_GGAFGOD_H_*/
