#ifndef GGAFCORE_GGAFTREESPACE_H_
#define GGAFCORE_GGAFTREESPACE_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"


namespace GgafCore {

/**
 * `NؔzpԃNX .
 * @version 1.00
 * @since 2009/11/23
 * @author Masatoshi Tsuge
 */
template<uint32_t DIMENSION>
class GgafTreeSpace : public GgafObject {

public:
    /** [r]`Nؔz̎g̗vfԍ */
    uint32_t _my_index;
    /** [r]Ăvf̎ʏ */
    actorkind _kind_bit_field;
    /** [r]Ԃ牺vf̐擪 */
    GgafTreeElem<DIMENSION>* _pElem_first;
    /** [r]Ԃ牺vf̖ */
    GgafTreeElem<DIMENSION>* _pElem_last;

public:
    /**
     * RXgN^
     * @return
     */
    GgafTreeSpace() : GgafObject() {
        _pElem_first = nullptr;
        _pElem_last = nullptr;
        _kind_bit_field = 0;
        _my_index = 0xffffffff; //肦Ȃ0xffffffffĂ
    }

    void registerElem(GgafTreeElem<DIMENSION>* const prm_pElem) {
        if (prm_pElem->_pSpace_current == this) {
            //_TRACE_("belongToł");
            return;
        } else {
            if (_pElem_first == nullptr) {
                //PԖڂɒǉ̏ꍇ
                _pElem_first = prm_pElem;
                _pElem_last = prm_pElem;
                //nullptrclearݒς݁BȗĂvȂ͂B
                //            _pNext = nullptr;
                //            _pPrev = nullptr;
                prm_pElem->_pSpace_current = this;
            } else {
                //ɒǉ̏ꍇ
                _pElem_last->_pNext = prm_pElem;
                prm_pElem->_pPrev = _pElem_last;
                //nullptrclearݒς݁BȗĂvȂ͂B
                //            _pNext = nullptr;
                _pElem_last = prm_pElem;
                prm_pElem->_pSpace_current = this;
            }
        }
        //̗vfԍ
        uint32_t index = _my_index;
        const uint32_t this_kindbit = prm_pElem->_kindbit;
        GgafTreeSpace<DIMENSION>* p = this; //= & _paOctant[index]
        while (true) {
            if (p->_kind_bit_field & this_kindbit) {
                //ʏ񂪐ݒς݂Ȃ΁Aȏ̐eݒςׁ݂̈A
                break;
            } else {
                //ԂɎʏ񂪖ݒȂΐݒ
                p->_kind_bit_field |= this_kindbit;
            }
            if (index == 0) {
                break;
            }
            //̐eԗvfԍŌJԂ
            index = (index-1)>>DIMENSION;
            p = p - (p->_my_index - index);
        }
    }

    void dump() {
        if (_pElem_first == nullptr) {
            _TRACE_N_("x");
        } else {
            GgafTreeElem<DIMENSION>* pElem = _pElem_first;
            while (true) {
                pElem->dump();
                if (pElem == _pElem_last) {
                    break;
                }
                pElem = pElem -> _pNext;
            }
        }
    }

    virtual ~GgafTreeSpace() {
    }
};

}
#endif /*GGAFCORE_GGAFTREESPACE_H_*/

