#ifndef GGAFDXCORE_GGAFDXGOD_H_
#define GGAFDXCORE_GGAFDXGOD_H_
#include "GgafDxCommonHeader.h"

#include "jp/ggaf/core/GgafGod.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/scene/GgafDxSpacetime.h"


#undef P_GOD
#define P_GOD ((GgafDxCore::GgafDxGod*)GgafDxCore::GgafDxGod::_pGod)

namespace GgafDxCore {

/**
 * DirectX_ .
 * @version 1.00
 * @since 2009/01/10
 * @author Masatoshi Tsuge
 */
class GgafDxGod : public GgafCore::GgafGod {

private:
    /** Windows Display Driver ModeliWDDMjgp\ۂ */
    bool _can_wddm;
    /** Q[\̈ȊÕNbv̈wiF */
    D3DCOLOR _color_border;
    /** Q[\̈̕\NA̔wiF */
    D3DCOLOR _color_clear;

    /** tXN[A_O^[QbgeNX` */
    IDirect3DTexture9*  _pRenderTexture;
    /** tXN[A_O^[QbgeNX`̃T[tFCX */
    IDirect3DSurface9*  _pRenderTextureSurface;
    /** tXN[A_O^[QbgZobt@̃T[tFCX */
    IDirect3DSurface9*  _pRenderTextureZ;
    /** tXN[AA_v^Ɋ֘AtꂽXbv`F[A[0]:PʖځA[1]:Qʖ */
    IDirect3DSwapChain9* _apSwapChain[2];
    /** tXN[ADirectX̃obNobt@A[0]:PʖځA[1]:Qʖ */
    IDirect3DSurface9* _apBackBuffer[2];

    /** foCX쐬p[^[ */
    D3DPRESENT_PARAMETERS* _paPresetPrm;
    /** ̗pĂfoCXiWDDMgp̂ݕKvj */
    D3DDISPLAYMODEEX* _paDisplayMode;

    HWND* _paHWnd;

private:
    /**
     * WDDMǂ肵AfoCX쐬 .
     * ʂ GgafDxGod::_pID3D9  GgafDxGod::_pID3DDevice9ɕێB
     * @param adapter
     * @param deviceType
     * @param hFocusWindow
     * @param behavior_flags
     * @param pPresentationParameters
     * @param pFullscreenDisplayMode
     * @return
     */
    HRESULT createDx9Device(UINT adapter,
                            D3DDEVTYPE device_type,
                            HWND hFocusWindow,
                            DWORD behavior_flags,
                            D3DPRESENT_PARAMETERS* pPresentationParameters,
                            D3DDISPLAYMODEEX* pFullscreenDisplayMode
                          );
    HRESULT initDx9Device();

    HRESULT restoreFullScreenRenderTarget();

    HRESULT releaseFullScreenRenderTarget();

    /**
     * EBhE[hAEBhETCYɉ`͈͂Đݒ肷B
     * @param prm_pHWnd
     */
    void adjustGameWindow(HWND prm_pHWnd);

    /**
     * \ʒuԍɑΉ`W͈(sNZ)擾B
     * @param prm_pos \ʒuԍ
     * @param inout_rectPresent [in](pos=5)̗̈`A[out]\ʒuɑΉ`W͈
     * @param prm_screen_width ʕ(sNZ)
     * @param prm_screen_height ʍ(sNZ)
     */
    void setPositionPresentRect(int prm_pos, RECT& inout_rectPresent, pixcoord prm_screen_width, pixcoord prm_screen_height);

    /**
     * }`fBXvCtXN[[hAj^W擾 .
     * ʂ _paAvailableAdapter[] o[Ɋi[B
     * EnumDisplayMonitorsɂR[obN֐B
     */
    static BOOL CALLBACK updateMoniterPixcoordCallback(HMONITOR hMonitor,
                                                       HDC      hdcMonitor,
                                                       LPRECT   lprcMonitor,
                                                       LPARAM   dwData    );
public:

    ///////////////////////////////////////////////////////////
    class Adapter {
    public:
        int mode_num;
        HMONITOR hMonitor;
        RECT rcMonitor;
        D3DDISPLAYMODE* paModes;
        Adapter() {
            mode_num = 0;
            hMonitor = nullptr;
            paModes = nullptr;
        }
        void setModeNum(int prm_mode_num) {
            mode_num = prm_mode_num;
            paModes = NEW D3DDISPLAYMODE[mode_num];
        }
        ~Adapter() {
            GGAF_DELETEARR_NULLABLE(paModes);
        }
    };

    /** gp\ȃfoCX̃A_v^ */
    int _num_adapter;
    /** gp\ȃfoCX̃A_v^̏Zbg */
    Adapter* _paAvailableAdapter;
    ///////////////////////////////////////////////////////////
    struct RezoInfo {
        UINT width;
        UINT height;
        std::string item_str;
    };
    class AdapterRezos {
    public:
        int rezo_num;
        RezoInfo* paRezoInfo;
        AdapterRezos() {
            rezo_num = 0;
            paRezoInfo = nullptr;
        }
        void init(int prm_rezo_num) {
            rezo_num = prm_rezo_num;
            paRezoInfo = NEW RezoInfo[rezo_num];
        }
        ~AdapterRezos() {
            GGAF_DELETEARR_NULLABLE(paRezoInfo);
        }
    };
    /** gp\ȃfoCX̃A_v^̉𑜓xZbg */
    AdapterRezos* _paAdapterRezos;
    ////////////////////////////////////////////////////////////

    /** f(GgafDxModel)Ǘ */
    static GgafDxModelManager* _pModelManager;
    /** GtFNg(GgafDxEffect)Ǘ */
    static GgafDxEffectManager* _pEffectManager;
    /** }bvpeNX`[(GgafDxTexture)ǗҁBiʏ̃eNX`GgafDxModel̓Ǘj */
    static GgafDxTextureManager* _pCubeMapTextureManager;
    /** ov}bvpeNX`[(GgafDxTexture)ǗҁBiʏ̃eNX`GgafDxModel̓Ǘj */
    static GgafDxTextureManager* _pBumpMapTextureManager;
    /** [r] 1ʖڂ̃EBhEnh  */
    static HWND _pHWndPrimary;
    /** [r] 2ʖڂ̃EBhEnh  */
    static HWND _pHWndSecondary;
    /** [r] {AvP[ṼCX^Xnh */
    static HINSTANCE _hInstance;
    /** [r] fobO[hAC[t[\ */
    static D3DFILLMODE _d3dfillmode;
    /** [r] DirectX9̃IuWFNg */
    static IDirect3D9* _pID3D9;
    /** [r] foCX */
    static IDirect3DDevice9* _pID3DDevice9;
    /** [r] ftHg̃Cg */
    static D3DLIGHT9 _d3dlight9_default;
    /** [r] ArGgCg̃ftHg̖邳 */
    static DWORD _ambient_brightness_default;
    /** [r] foCXXgtO (true=Xg) */
    static bool _is_device_lost_flg;
    /** [r] ʃAXyNg䒲tO (true=EBhETCYA\̈ČvZ) */
    static bool _adjustGameWindow;
    /** [r] \̈ČvZKvȃEBhE(̃nh) */
    static HWND _pHWnd_adjustScreen;


    /** [r] _VF[_[̃o[W(D3DVS_VERSION(_Major,_Minor)) */
    static uint32_t _vs_v;
    /** [r] sNZVF[_[̃o[W(D3DPS_VERSION(_Major,_Minor)) */
    static uint32_t _ps_v;

    /** [r] Q[obt@̈(sNZIȌn) */
    RECT _rectGameBuffer;
    /** [r] tXN[A_O^[QbgeNX`̗̈(sNZ) */
    RECT _rectRenderTargetBuffer;
    /** [r] Q[obt@̈́A[0]:̈A[1]:Ë (sNZ) */
    RECT _aRect_HarfGameBuffer[2];
    /** [r] tXN[A_O^[QbgeNX`̈́A[0]:̈A[1]:Ë (sNZ) */
    RECT _aRect_HarfRenderTargetBuffer[2];
    /** [r] ŏI\tgobt@t[̗̈A[0]:PʖځA[1]:Qʖ (sNZ) */
    RECT _aRect_ViewScreen[2];
    /** [r] PresenẗA[0]:PʖځA[1]:Qʖ (sNZ) */
    RECT _aRect_Present[2];
    /** [r] PʖڃA_v^ԍA _aRect_HarfRenderTargetBuffer[] ̏ 0 ` */
    int _primary_adapter_no;
    /** [r] QʖڃA_v^ԍA _aRect_HarfRenderTargetBuffer[] ̏ 0 ` */
    int _secondary_adapter_no;

public:
    /**
     * RXgN^<BR>
     */
    GgafDxGod();

    /**
     * tXN[AłÓȉ𑜓xTB
     * @param prm_paRezos 𑜓xz
     * @param prm_rezo_num 𑜓xz̗vf
     * @param prm_width ]̉𑜓x̕
     * @param prm_height ]̉𑜓x̍
     * @return łÓȗvfCfbNX
     */
    static int checkAppropriateDisplaySize(GgafDxGod::RezoInfo* prm_paRezos, int prm_rezo_num,
                                           UINT prm_width, UINT prm_height);
    /**
     * EBhE
     * @param prm_wndclass1 PʖڂWNDCLASSEXp[^
     * @param prm_wndclass2 QʖڂWNDCLASSEXp[^
     * @param prm_title1 Pʖڂ̃^Cg
     * @param prm_title2 Qʖڂ̃^Cg
     * @param prm_dwStyle1 EBhE[h̃EChE1̃X^C萔(WS_OVERLAPPEDWINDOW )
     * @param prm_dwStyle2 EBhE[h̃EChE2̃X^C萔(WS_OVERLAPPEDWINDOW )
     * @param out_hWnd1 i߂ljPʖڂ̃EBhEnh
     * @param out_hWnd2 i߂ljQʖڂ̃EBhEnh
     */
    void createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                      const char* prm_title1   , const char* prm_title2,
                      DWORD       prm_dwStyle1 , DWORD       prm_dwStyle2,
                      HWND&       out_hWnd1    , HWND&       out_hWnd2);

    /**
     * EBhE .
     * WIȃEBhE쐬܂B
     * @param prm_WndProc EBhEvV[W֐
     * @param prm_title1 Pʖڂ̃^Cg
     * @param prm_title2 Qʖڂ̃^Cg
     * @param out_hWnd1 i߂ljPʖڂ̃EBhEnh
     * @param out_hWnd2 i߂ljQʖڂ̃EBhEnh
     */
    void createWindow(WNDPROC prm_WndProc,
                      const char* prm_title1, const char* prm_title2,
                      HWND&       out_hWnd1 , HWND&       out_hWnd2  );

    /**
     * EBhE .
     * WIȃEBhE쐬܂B
     * @param prm_WndProc EBhEvV[W֐
     * @param prm_title1 Pʖڂ̃^Cg
     * @param prm_title2 Qʖڂ̃^Cg
     */
    void createWindow(WNDPROC prm_WndProc,
                      const char* prm_title1, const char* prm_title2);

    /**
     * EBhE .
     * EBhE[h̃EChEX^C萔 WS_OVERLAPPEDWINDOW ݒ肳܂B
     * @param prm_wndclass1 PʖڂWNDCLASSEXp[^
     * @param prm_wndclass2 QʖڂWNDCLASSEXp[^
     * @param prm_title1 Pʖڂ̃^Cg
     * @param prm_title2 Qʖڂ̃^Cg
     * @param out_hWnd1 i߂ljPʖڂ̃EBhEnh
     * @param out_hWnd2 i߂ljQʖڂ̃EBhEnh
     */
    void createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                      const char* prm_title1   , const char* prm_title2,
                      HWND&       out_hWnd1    , HWND&       out_hWnd2);

    /**
     * EBhẼTCYĐݒ .
     * @param hWnd Đݒ肷EBhEHWND
     * @param client_width NCAg̈扡isNZj
     * @param client_height NCAg̈cisNZj
     */
    static void resetWindowsize(HWND hWnd, pixcoord client_width, pixcoord client_height);

    static void chengeViewPos1(int pos);
    static void chengeViewPos2(int pos);
    static void chengeViewPos(HWND prm_pHWnd, int pos);
    static void chengeViewAspect(bool prm_b);

    /**
     * EBhE̍ő剻ɂi{[_[XEtXN[EEBhEj .
     * @param prm_pHWnd Ώۂ̃EBhEnh
     */
    static void chengeToBorderlessFullWindow(HWND prm_pHWnd);

    /**
     * {[_[XEtXN[EEBhEɖ߂ .
     * @param prm_pHWnd Ώۂ̃EBhEnh
     */
    static void backToNomalWindow(HWND prm_pHWnd);

    /**
     * DirectX̃foCX̏ݒsB
     * @return E_FAIL:s^D3D_OK:
     */
    virtual HRESULT initDevice();
    virtual void presentSpacetimeMoment() override;
    virtual void executeSpacetimeJudge() override;
    virtual void makeSpacetimeMaterialize() override;
    virtual void presentSpacetimeVisualize() override;
    virtual void finalizeSpacetime() override;


    /**
     * ̐擾 .
     * ʂŃI[o[Ch\B<BR>
     * @return ̐
     */
    virtual GgafDxSpacetime* getSpacetime() override {  //ς̖߂l
        return (GgafDxSpacetime*)_pSpacetime;
    }

    virtual void clean() override;

    virtual ~GgafDxGod();
};

}
#endif /*GGAFDXCORE_GGAFDXGOD_H_*/
